/*
 * Decompiled with CFR 0.152.
 */
package myconext.manage;

import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import myconext.manage.ServiceProviderResolver;
import myconext.model.SamlAuthenticationRequest;
import myconext.security.CookieResolver;

public interface ServiceProviderHolder {
    public ServiceProviderResolver getServiceProviderResolver();

    default public String getServiceName(HttpServletRequest request, SamlAuthenticationRequest samlAuthenticationRequest) {
        String lang = CookieResolver.cookieByName((HttpServletRequest)request, (String)"lang").map(Cookie::getValue).orElse("en");
        String requesterEntityId = samlAuthenticationRequest.getRequesterEntityId();
        Optional optionalServiceProvider = this.getServiceProviderResolver().resolve(requesterEntityId);
        return optionalServiceProvider.map(serviceProvider -> lang.equals("en") ? serviceProvider.getName() : serviceProvider.getNameNl()).orElse(requesterEntityId);
    }
}

