/*
 * Decompiled with CFR 0.152.
 */
package myconext.tiqr;

import com.google.zxing.WriterException;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import myconext.crypto.HashGenerator;
import myconext.exceptions.ExpiredAuthenticationException;
import myconext.exceptions.ForbiddenException;
import myconext.exceptions.UserNotFoundException;
import myconext.log.MDCContext;
import myconext.manage.ServiceProviderResolver;
import myconext.model.SamlAuthenticationRequest;
import myconext.model.User;
import myconext.repository.AuthenticationRepository;
import myconext.repository.AuthenticationRequestRepository;
import myconext.repository.EnrollmentRepository;
import myconext.repository.RegistrationRepository;
import myconext.repository.UserRepository;
import myconext.security.CookieResolver;
import myconext.security.CookieValueEncoder;
import myconext.security.UserAuthentication;
import myconext.security.VerificationCodeGenerator;
import myconext.sms.SMSService;
import myconext.tiqr.DeactivateRequest;
import myconext.tiqr.EnrollmentVerificationKey;
import myconext.tiqr.FinishEnrollment;
import myconext.tiqr.GeneratedBackupCode;
import myconext.tiqr.ManualResponse;
import myconext.tiqr.PhoneCode;
import myconext.tiqr.PhoneVerification;
import myconext.tiqr.PollAuthenticationResult;
import myconext.tiqr.RateLimitEnforcer;
import myconext.tiqr.StartAuthentication;
import myconext.tiqr.StartEnrollment;
import myconext.tiqr.TiqrConfiguration;
import myconext.tiqr.TiqrRequest;
import myconext.tiqr.VerifyPhoneCode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.yaml.snakeyaml.Yaml;
import tiqr.org.DefaultTiqrService;
import tiqr.org.TiqrException;
import tiqr.org.TiqrService;
import tiqr.org.model.Authentication;
import tiqr.org.model.AuthenticationData;
import tiqr.org.model.AuthenticationStatus;
import tiqr.org.model.Enrollment;
import tiqr.org.model.EnrollmentStatus;
import tiqr.org.model.MetaData;
import tiqr.org.model.Registration;
import tiqr.org.model.RegistrationStatus;
import tiqr.org.model.Service;
import tiqr.org.secure.QRCodeGenerator;

@RestController
@RequestMapping(value={"/tiqr", "/mobile/tiqr"})
public class TiqrController
implements UserAuthentication {
    private static final Log LOG = LogFactory.getLog(TiqrController.class);
    private static final String SESSION_KEY = "sessionKey";
    private final TiqrService tiqrService;
    private final TiqrConfiguration tiqrConfiguration;
    private final AuthenticationRequestRepository authenticationRequestRepository;
    private final UserRepository userRepository;
    private final ServiceProviderResolver serviceProviderResolver;
    private final SMSService smsService;
    private final String magicLinkUrl;
    private final RegistrationRepository registrationRepository;
    private final RateLimitEnforcer rateLimitEnforcer;
    private final CookieValueEncoder cookieValueEncoder;

    @Autowired
    public TiqrController(@Value(value="${tiqr_configuration}") Resource resource, EnrollmentRepository enrollmentRepository, RegistrationRepository registrationRepository, AuthenticationRepository authenticationRepository, AuthenticationRequestRepository authenticationRequestRepository, UserRepository userRepository, ServiceProviderResolver serviceProviderResolver, SMSService smsService, Environment environment, @Value(value="${email.magic-link-url}") String magicLinkUrl, CookieValueEncoder cookieValueEncoder) throws IOException {
        this.tiqrConfiguration = (TiqrConfiguration)new Yaml().loadAs(resource.getInputStream(), TiqrConfiguration.class);
        this.cookieValueEncoder = cookieValueEncoder;
        String baseUrl = this.getEduIDServerBaseUrl();
        Service service = new Service(this.tiqrConfiguration.getDisplayName(), this.tiqrConfiguration.getIdentifier(), this.tiqrConfiguration.getVersion(), this.tiqrConfiguration.getLogoUrl(), this.tiqrConfiguration.getInfoUrl(), String.format("%s/tiqr/authentication", baseUrl), this.tiqrConfiguration.isPushNotificationsEnabled(), String.format("%s/tiqr/enrollment", baseUrl));
        if (environment.getActiveProfiles().length > 0) {
            this.tiqrConfiguration.getGcm().setAppName(UUID.randomUUID().toString());
        }
        this.tiqrService = new DefaultTiqrService((tiqr.org.repo.EnrollmentRepository)enrollmentRepository, (tiqr.org.repo.RegistrationRepository)registrationRepository, (tiqr.org.repo.AuthenticationRepository)authenticationRepository, service, this.tiqrConfiguration.getEncryptionSecret(), this.tiqrConfiguration.getApns(), this.tiqrConfiguration.getGcm());
        this.registrationRepository = registrationRepository;
        this.authenticationRequestRepository = authenticationRequestRepository;
        this.userRepository = userRepository;
        this.serviceProviderResolver = serviceProviderResolver;
        this.smsService = smsService;
        this.magicLinkUrl = magicLinkUrl;
        this.rateLimitEnforcer = new RateLimitEnforcer(userRepository, this.tiqrConfiguration);
    }

    private String getEduIDServerBaseUrl() {
        String baseUrl = this.tiqrConfiguration.getBaseUrl();
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        return baseUrl;
    }

    @Operation(summary="Start enrollment", description="Start Tiqr enrollment for the current user")
    @GetMapping(value={"/sp/start-enrollment"})
    public ResponseEntity<StartEnrollment> startEnrollment(org.springframework.security.core.Authentication authentication) throws IOException, WriterException {
        User user = this.userFromAuthentication(authentication);
        return this.doStartEnrollmentForUser(user);
    }

    @Operation(summary="Finish enrollment", description="Finish Tiqr enrollment for the current user")
    @GetMapping(value={"/sp/finish-enrollment"})
    public ResponseEntity<EnrollmentVerificationKey> finishEnrollment(org.springframework.security.core.Authentication authentication) {
        User user = this.userFromAuthentication(authentication);
        String enrollmentVerificationKey = UUID.randomUUID().toString();
        user.setEnrollmentVerificationKey(enrollmentVerificationKey);
        this.userRepository.save((Object)user);
        return ResponseEntity.ok((Object)new EnrollmentVerificationKey(enrollmentVerificationKey));
    }

    @GetMapping(value={"/start-enrollment"})
    @Hidden
    public ResponseEntity<StartEnrollment> startEnrollment(@RequestParam(value="hash", required=false) String hash) throws IOException, WriterException {
        if (!StringUtils.hasText((String)hash)) {
            throw new ForbiddenException("No hash parameter");
        }
        User user = this.getUserFromAuthenticationRequest(hash);
        return this.doStartEnrollmentForUser(user);
    }

    private ResponseEntity<StartEnrollment> doStartEnrollmentForUser(User user) throws WriterException, IOException {
        Enrollment enrollment;
        try {
            enrollment = this.tiqrService.startEnrollment(user.getId(), String.format("%s %s", user.getGivenName(), user.getFamilyName()));
        }
        catch (TiqrException e) {
            throw new ForbiddenException("Can not start enrollment when there is an existing Registration");
        }
        String enrollmentKey = enrollment.getKey();
        String metaDataUrl = String.format("%s/tiqr/metadata?enrollment_key=%s", this.getEduIDServerBaseUrl(), enrollmentKey);
        String url = String.format("%s/tiqrenroll/?metadata=%s", this.tiqrConfiguration.getEduIdAppBaseUrl(), this.encode(metaDataUrl));
        LOG.debug((Object)String.format("Enrollment url :  %s", url));
        StartEnrollment startEnrollment = new StartEnrollment(enrollmentKey, url, QRCodeGenerator.generateQRCodeImage((String)url));
        LOG.info((Object)String.format("Started enrollment for %s", user.getEmail()));
        return ResponseEntity.ok((Object)startEnrollment);
    }

    @GetMapping(value={"/metadata"})
    @Hidden
    public ResponseEntity<MetaData> metaData(@RequestParam(value="enrollment_key") String enrollmentKey) throws TiqrException {
        MetaData metaData = this.tiqrService.getMetaData(enrollmentKey);
        LOG.info((Object)String.format("Returning metaData for %s", metaData.getIdentity().getDisplayName()));
        return ResponseEntity.ok((Object)metaData);
    }

    @Operation(summary="Poll enrollment", description="Poll Tiqr enrollment status")
    @GetMapping(value={"/poll-enrollment"})
    public ResponseEntity<EnrollmentStatus> enrollmentStatus(@RequestParam(value="enrollmentKey") String enrollmentKey) throws TiqrException {
        Enrollment enrollment = this.tiqrService.enrollmentStatus(enrollmentKey);
        LOG.debug((Object)String.format("Polling enrollment for %s with status %s", enrollment.getUserDisplayName(), enrollment.getStatus()));
        return ResponseEntity.ok((Object)enrollment.getStatus());
    }

    @Operation(summary="Generate back-up code", description="Generate a back-up code for a finished authentication")
    @GetMapping(value={"/sp/generate-backup-code"})
    public ResponseEntity<GeneratedBackupCode> generateBackupCodeForSp(org.springframework.security.core.Authentication authentication) throws TiqrException {
        User user = this.userFromAuthentication(authentication);
        return this.doGenerateBackupCode(user, false);
    }

    @Operation(summary="Generate new back-up code", description="Generate a new back-up code for a finished authentication")
    @GetMapping(value={"/sp/re-generate-backup-code"})
    public ResponseEntity<GeneratedBackupCode> regenerateBackupCodeForSp(HttpServletRequest request, org.springframework.security.core.Authentication secAuthentication) throws TiqrException {
        User user = this.userFromAuthentication(secAuthentication);
        String sessionKey = (String)request.getSession().getAttribute(SESSION_KEY);
        Authentication authentication = this.tiqrService.authenticationStatus(sessionKey);
        if (!authentication.getStatus().equals((Object)AuthenticationStatus.SUCCESS)) {
            throw new ForbiddenException();
        }
        return this.doGenerateBackupCode(user, true);
    }

    @GetMapping(value={"/generate-backup-code"})
    @Hidden
    public ResponseEntity<GeneratedBackupCode> generateBackupCode(@RequestParam(value="hash") @Parameter(description="Hash 'h' query parameter") String hash) throws TiqrException {
        SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)this.authenticationRequestRepository.findByHash(hash).orElseThrow(() -> new ForbiddenException("Unknown hash"));
        String userId = samlAuthenticationRequest.getUserId();
        User user = (User)this.userRepository.findById((Object)userId).orElseThrow(() -> new UserNotFoundException(userId));
        samlAuthenticationRequest.setTiqrFlow(true);
        this.authenticationRequestRepository.save((Object)samlAuthenticationRequest);
        return this.doGenerateBackupCode(user, false);
    }

    private ResponseEntity<GeneratedBackupCode> doGenerateBackupCode(User user, boolean regenerateSpFlow) throws TiqrException {
        Registration registration;
        if (!regenerateSpFlow && !(registration = (Registration)this.registrationRepository.findRegistrationByUserId(user.getId()).orElseThrow(IllegalArgumentException::new)).getStatus().equals((Object)RegistrationStatus.INITIALIZED)) {
            throw new ForbiddenException();
        }
        Map surfSecureId = user.getSurfSecureId();
        if (regenerateSpFlow) {
            List.of("recovery-code", "phone-verification-code", "phone-verified", "phone-number").forEach(surfSecureId::remove);
        }
        String recoveryCode = (String)surfSecureId.computeIfAbsent("recovery-code", k -> VerificationCodeGenerator.generateBackupCode().replaceAll(" ", ""));
        this.userRepository.save((Object)user);
        if (!regenerateSpFlow) {
            this.tiqrService.finishRegistration(user.getId());
        }
        return ResponseEntity.ok((Object)new GeneratedBackupCode(this.magicLinkUrl, recoveryCode));
    }

    @Operation(summary="Send phone code", description="Send a verification code to mobile phone for a finished authentication")
    @PostMapping(value={"/sp/send-phone-code"})
    public ResponseEntity<FinishEnrollment> sendPhoneCodeForSp(HttpServletRequest request, org.springframework.security.core.Authentication authentication, @Valid @RequestBody PhoneCode phoneCode) {
        User user = this.userFromAuthentication(authentication);
        String phoneNumber = phoneCode.getPhoneNumber();
        return this.doSendPhoneCode(user, phoneNumber, false, request);
    }

    @Operation(summary="Send new phone code", description="Send a new verification code to mobile phone for a finished authentication")
    @PostMapping(value={"/sp/re-send-phone-code"})
    public ResponseEntity<FinishEnrollment> resendPhoneCodeForSp(HttpServletRequest request, org.springframework.security.core.Authentication secAuthentication, @Valid @RequestBody PhoneCode phoneCode) throws TiqrException {
        String sessionKey = (String)request.getSession().getAttribute(SESSION_KEY);
        Authentication authentication = this.tiqrService.authenticationStatus(sessionKey);
        if (!authentication.getStatus().equals((Object)AuthenticationStatus.SUCCESS)) {
            throw new ForbiddenException();
        }
        User user = this.userFromAuthentication(secAuthentication);
        String phoneNumber = phoneCode.getPhoneNumber();
        return this.doSendPhoneCode(user, phoneNumber, true, request);
    }

    @PostMapping(value={"/send-phone-code"})
    @Hidden
    public ResponseEntity<FinishEnrollment> sendPhoneCode(HttpServletRequest request, @RequestParam(value="hash") String hash, @RequestBody Map<String, String> requestBody) {
        User user = this.getUserFromAuthenticationRequest(hash);
        String phoneNumber = requestBody.get("phoneNumber");
        return this.doSendPhoneCode(user, phoneNumber, false, request);
    }

    private ResponseEntity<FinishEnrollment> doSendPhoneCode(User user, String phoneNumber, boolean regenerateSpFlow, HttpServletRequest request) {
        String phoneVerification = VerificationCodeGenerator.generatePhoneVerification();
        this.smsService.send(phoneNumber, phoneVerification, request.getLocale());
        Map surfSecureId = user.getSurfSecureId();
        surfSecureId.put("phone-verification-code", phoneVerification);
        surfSecureId.remove("rate-limit");
        if (regenerateSpFlow) {
            surfSecureId.put("new-unverified-phone-number", phoneNumber);
        } else {
            surfSecureId.put("phone-number", phoneNumber);
        }
        this.userRepository.save((Object)user);
        return ResponseEntity.ok((Object)new FinishEnrollment("ok"));
    }

    @Operation(summary="Verify phone code", description="Verify verification code for a finished authentication")
    @PostMapping(value={"/sp/verify-phone-code"})
    public ResponseEntity<VerifyPhoneCode> spVerifyPhoneCode(org.springframework.security.core.Authentication authentication, @Valid @RequestBody PhoneVerification phoneVerification) throws TiqrException {
        User user = this.userFromAuthentication(authentication);
        return this.doVerifyPhoneCode(phoneVerification, user, false);
    }

    @Operation(summary="Verify phone code again", description="Verify verification code again for a finished authentication")
    @PostMapping(value={"/sp/re-verify-phone-code"})
    public ResponseEntity<VerifyPhoneCode> spReverifyPhoneCode(HttpServletRequest request, org.springframework.security.core.Authentication secAuthentication, @Valid @RequestBody PhoneVerification phoneVerification) throws TiqrException {
        User user = this.userFromAuthentication(secAuthentication);
        String sessionKey = (String)request.getSession().getAttribute(SESSION_KEY);
        Authentication authentication = this.tiqrService.authenticationStatus(sessionKey);
        if (!authentication.getStatus().equals((Object)AuthenticationStatus.SUCCESS)) {
            throw new ForbiddenException();
        }
        return this.doVerifyPhoneCode(phoneVerification, user, true);
    }

    @PostMapping(value={"/verify-phone-code"})
    @Hidden
    public ResponseEntity<VerifyPhoneCode> verifyPhoneCode(@RequestParam(value="hash") String hash, @Valid @RequestBody PhoneVerification phoneVerification) throws TiqrException {
        SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)this.authenticationRequestRepository.findByHash(hash).orElseThrow(() -> new ForbiddenException("Unknown hash"));
        return this.idpVerifyPhoneCode(phoneVerification, samlAuthenticationRequest);
    }

    private ResponseEntity<VerifyPhoneCode> idpVerifyPhoneCode(PhoneVerification phoneVerification, SamlAuthenticationRequest samlAuthenticationRequest) throws TiqrException {
        String userId = samlAuthenticationRequest.getUserId();
        User user = (User)this.userRepository.findById((Object)userId).orElseThrow(() -> new UserNotFoundException(userId));
        ResponseEntity verifyPhoneCodeResponseEntity = this.doVerifyPhoneCode(phoneVerification, user, false);
        samlAuthenticationRequest.setTiqrFlow(true);
        this.authenticationRequestRepository.save((Object)samlAuthenticationRequest);
        return verifyPhoneCodeResponseEntity;
    }

    private ResponseEntity<VerifyPhoneCode> doVerifyPhoneCode(PhoneVerification phoneVerification, User user, boolean regenerateSpFlow) throws TiqrException {
        String code = phoneVerification.getPhoneVerification();
        Map surfSecureId = user.getSurfSecureId();
        String phoneVerificationStored = (String)surfSecureId.get("phone-verification-code");
        this.rateLimitEnforcer.checkRateLimit(user);
        if (MessageDigest.isEqual(code.getBytes(StandardCharsets.UTF_8), phoneVerificationStored.getBytes(StandardCharsets.UTF_8))) {
            surfSecureId.remove("phone-verification-code");
            surfSecureId.put("phone-verified", true);
            surfSecureId.remove("rate-limit");
            if (regenerateSpFlow) {
                String unverifiedPhoneNumber = (String)surfSecureId.get("new-unverified-phone-number");
                surfSecureId.put("phone-number", unverifiedPhoneNumber);
                surfSecureId.remove("new-unverified-phone-number");
                surfSecureId.remove("recovery-code");
            } else {
                this.tiqrService.finishRegistration(user.getId());
            }
        } else {
            throw new ForbiddenException();
        }
        this.userRepository.save((Object)user);
        return ResponseEntity.ok((Object)new VerifyPhoneCode(this.magicLinkUrl));
    }

    @Operation(summary="Start authentication", description="Start Tiqr authentication for current user")
    @PostMapping(value={"/sp/start-authentication"})
    public ResponseEntity<StartAuthentication> startAuthenticationForSP(HttpServletRequest request, org.springframework.security.core.Authentication authentication) throws IOException, WriterException, TiqrException {
        User user = this.userFromAuthentication(authentication);
        ResponseEntity startAuthenticationResponseEntity = this.doStartAuthentication(request, user);
        String sessionKey = ((StartAuthentication)startAuthenticationResponseEntity.getBody()).getSessionKey();
        request.getSession().setAttribute(SESSION_KEY, (Object)sessionKey);
        return startAuthenticationResponseEntity;
    }

    @PostMapping(value={"/start-authentication"})
    @Hidden
    public ResponseEntity<StartAuthentication> startAuthentication(HttpServletRequest request, @Valid @RequestBody TiqrRequest tiqrRequest) throws IOException, WriterException, TiqrException {
        this.authenticationRequestRepository.findByIdAndNotExpired(tiqrRequest.getAuthenticationRequestId()).orElseThrow(ExpiredAuthenticationException::new);
        String email = tiqrRequest.getEmail().trim();
        User user = (User)this.userRepository.findUserByEmail(email).orElseThrow(() -> new UserNotFoundException(String.format("User %s not found", email)));
        return this.doStartAuthentication(request, user);
    }

    private ResponseEntity<StartAuthentication> doStartAuthentication(HttpServletRequest request, User user) throws WriterException, IOException, TiqrException {
        boolean sendPushNotification;
        Optional optionalTiqrCookie = CookieResolver.cookieByName((HttpServletRequest)request, (String)"TIQR_COOKIE");
        AtomicBoolean tiqrCookiePresent = new AtomicBoolean(false);
        optionalTiqrCookie.ifPresent(tiqrCookie -> tiqrCookiePresent.set(this.cookieValueEncoder.matches(user.getUsername(), tiqrCookie.getValue())));
        boolean bl = sendPushNotification = tiqrCookiePresent.get() && this.tiqrConfiguration.isPushNotificationsEnabled();
        if (optionalTiqrCookie.isPresent() && !sendPushNotification) {
            LOG.info((Object)String.format("Tiqr cookie present for user %s, but not sending push notification because push notifications are disabled.", user.getEmail()));
        }
        this.rateLimitEnforcer.unsuspendUserAfterTiqrSuccess(user);
        Authentication authentication = this.tiqrService.startAuthentication(user.getId(), String.format("%s %s", user.getGivenName(), user.getFamilyName()), this.tiqrConfiguration.getEduIdAppBaseUrl(), sendPushNotification);
        String authenticationUrl = authentication.getAuthenticationUrl();
        String qrCode = QRCodeGenerator.generateQRCodeImage((String)authenticationUrl);
        StartAuthentication startAuthentication = new StartAuthentication(authentication.getSessionKey(), authenticationUrl, qrCode, sendPushNotification && authentication.isPushNotificationSend());
        return ResponseEntity.ok((Object)startAuthentication);
    }

    @Operation(summary="Poll authentication", description="Poll Tiqr authentication status for current user")
    @GetMapping(value={"/sp/poll-authentication"})
    public ResponseEntity<PollAuthenticationResult> spAuthenticationStatus(org.springframework.security.core.Authentication authentication, @RequestParam(value="sessionKey") @Parameter(description="Session key of the authentication") String sessionKey) throws TiqrException {
        this.userFromAuthentication(authentication);
        return this.doPollAuthentication(sessionKey, Optional.empty());
    }

    @GetMapping(value={"/poll-authentication"})
    @Hidden
    public ResponseEntity<PollAuthenticationResult> authenticationStatus(@RequestParam(value="sessionKey") String sessionKey, @RequestParam(value="id") String authenticationRequestId) throws TiqrException {
        return this.doPollAuthentication(sessionKey, Optional.of(authenticationRequestId));
    }

    private ResponseEntity<PollAuthenticationResult> doPollAuthentication(String sessionKey, Optional<String> authenticationRequestIdOptional) throws TiqrException {
        Authentication authentication = this.tiqrService.authenticationStatus(sessionKey);
        AuthenticationStatus status = authentication.getStatus();
        LOG.debug((Object)String.format("Polling authentication for %s with status %s", authentication.getUserDisplayName(), authentication.getStatus()));
        PollAuthenticationResult pollAuthenticationResult = new PollAuthenticationResult();
        pollAuthenticationResult.setStatus(status.name());
        if (status.equals((Object)AuthenticationStatus.SUCCESS)) {
            authenticationRequestIdOptional.ifPresent(authenticationRequestId -> {
                SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)this.authenticationRequestRepository.findById(authenticationRequestId).orElseThrow(ExpiredAuthenticationException::new);
                String requesterEntityId = samlAuthenticationRequest.getRequesterEntityId();
                String userID = authentication.getUserID();
                User user = (User)this.userRepository.findById((Object)userID).orElseThrow(() -> new UserNotFoundException(String.format("User %s not found", authentication.getUserDisplayName())));
                MDCContext.logWithContext((User)user, (String)"update", (String)"user", (Log)LOG, (String)("Updating user " + user.getEmail()));
                user.computeEduIdForServiceProviderIfAbsent(requesterEntityId, this.serviceProviderResolver);
                this.userRepository.save((Object)user);
                samlAuthenticationRequest.setHash(HashGenerator.hash());
                samlAuthenticationRequest.setTiqrFlow(true);
                samlAuthenticationRequest.setUserId(userID);
                this.authenticationRequestRepository.save((Object)samlAuthenticationRequest);
                pollAuthenticationResult.setRedirect(this.magicLinkUrl);
                pollAuthenticationResult.setHash(samlAuthenticationRequest.getHash());
            });
        } else if (status.equals((Object)AuthenticationStatus.SUSPENDED)) {
            String userID = authentication.getUserID();
            User user = (User)this.userRepository.findById((Object)userID).orElseThrow(() -> new UserNotFoundException(String.format("User %s not found", authentication.getUserDisplayName())));
            Object suspendedUntil = user.getSurfSecureId().get("suspendedUntil");
            if (suspendedUntil != null) {
                long time = suspendedUntil instanceof Date ? ((Date)suspendedUntil).getTime() : ((Instant)suspendedUntil).getEpochSecond();
                pollAuthenticationResult.setSuspendedUntil(time);
            } else {
                pollAuthenticationResult.setSuspendedUntil(Instant.now().getEpochSecond());
            }
        }
        return ResponseEntity.ok((Object)pollAuthenticationResult);
    }

    @Operation(summary="Manual authentication", description="Manual Tiqr authentication response")
    @PostMapping(value={"/sp/manual-response"})
    public ResponseEntity<FinishEnrollment> spManualResponse(org.springframework.security.core.Authentication authentication, @Valid @RequestBody ManualResponse manualResponse) throws TiqrException {
        this.userFromAuthentication(authentication);
        return this.doManualResponse(manualResponse);
    }

    @PostMapping(value={"/manual-response"})
    @Hidden
    public ResponseEntity<FinishEnrollment> manualResponse(@Valid @RequestBody ManualResponse manualResponse) throws TiqrException {
        return this.doManualResponse(manualResponse);
    }

    private ResponseEntity<FinishEnrollment> doManualResponse(ManualResponse manualResponse) throws TiqrException {
        String sessionKey = manualResponse.getSessionKey();
        String response = manualResponse.getResponse();
        this.tiqrService.postAuthentication(new AuthenticationData(sessionKey, response));
        return ResponseEntity.ok((Object)new FinishEnrollment("ok"));
    }

    @PostMapping(value={"/enrollment"}, consumes={"application/x-www-form-urlencoded"})
    @Hidden
    public ResponseEntity<Object> doEnrollment(@ModelAttribute Registration registration, @RequestParam(value="enrollment_secret") String enrollmentSecret) {
        registration.setEnrollmentSecret(enrollmentSecret);
        try {
            Registration savedRegistration = this.tiqrService.enrollData(registration);
            LOG.debug((Object)("Successful enrollment for user " + savedRegistration.getUserId()));
            return ResponseEntity.ok((Object)"OK");
        }
        catch (RuntimeException | TiqrException e) {
            LOG.error((Object)("Exception during enrollment for user: " + registration.getUserId()), e);
            return ResponseEntity.ok((Object)"ERROR");
        }
    }

    @PostMapping(value={"/authentication"}, consumes={"application/x-www-form-urlencoded"})
    @Hidden
    public ResponseEntity<Object> doAuthentication(@ModelAttribute AuthenticationData authenticationData) {
        String userId = authenticationData.getUserId();
        User user = (User)this.userRepository.findById((Object)userId).orElseThrow(() -> new UserNotFoundException(userId));
        if (!this.rateLimitEnforcer.isUserAllowedTiqrVerification(user)) {
            return ResponseEntity.ok((Object)"ERROR");
        }
        try {
            this.tiqrService.postAuthentication(authenticationData);
            LOG.debug((Object)("Successful authentication for user " + userId));
            this.rateLimitEnforcer.unsuspendUserAfterTiqrSuccess(user);
            return ResponseEntity.ok((Object)"OK");
        }
        catch (RuntimeException | TiqrException e) {
            LOG.error((Object)String.format("Exception during authentication for user %s, message %s", userId, e.getMessage()));
            this.rateLimitEnforcer.suspendUserAfterTiqrFailure(user);
            try {
                this.tiqrService.suspendAuthentication(authenticationData.getSessionKey());
            }
            catch (TiqrException tiqrException) {
                // empty catch block
            }
            return ResponseEntity.ok((Object)"ERROR");
        }
    }

    @PutMapping(value={"/remember-me"})
    @Hidden
    public ResponseEntity<FinishEnrollment> rememberMe(@RequestBody Map<String, String> body) {
        String hash = body.get("hash");
        SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)this.authenticationRequestRepository.findByHash(hash).orElseThrow(ExpiredAuthenticationException::new);
        samlAuthenticationRequest.setRememberMe(true);
        samlAuthenticationRequest.setRememberMeValue(UUID.randomUUID().toString());
        this.authenticationRequestRepository.save((Object)samlAuthenticationRequest);
        return ResponseEntity.ok((Object)new FinishEnrollment("ok"));
    }

    @Operation(summary="Send de-activation code", description="Send a de-activation code to the user")
    @GetMapping(value={"/sp/send-deactivation-phone-code"})
    public ResponseEntity<FinishEnrollment> sendDeactivationPhoneCodeForSp(HttpServletRequest request, org.springframework.security.core.Authentication authentication) {
        User user = this.userFromAuthentication(authentication);
        String phoneNumber = (String)user.getSurfSecureId().get("phone-number");
        if (!StringUtils.hasText((String)phoneNumber)) {
            throw new ForbiddenException();
        }
        return this.doSendPhoneCode(user, phoneNumber, false, request);
    }

    @Operation(summary="De-activate the app", description="De-activate the eduID app for the current user")
    @PostMapping(value={"/sp/deactivate-app"})
    public ResponseEntity<FinishEnrollment> deactivateApp(org.springframework.security.core.Authentication authentication, @Valid @RequestBody DeactivateRequest deactivateRequest) {
        User user = this.userFromAuthentication(authentication);
        Map surfSecureId = user.getSurfSecureId();
        String verificationCodeKey = surfSecureId.containsKey("recovery-code") ? "recovery-code" : "phone-verification-code";
        byte[] verificationCode = ((String)surfSecureId.get(verificationCodeKey)).replaceAll(" ", "").getBytes(StandardCharsets.UTF_8);
        byte[] userVerificationCode = deactivateRequest.getVerificationCode().replaceAll(" ", "").getBytes(StandardCharsets.UTF_8);
        this.rateLimitEnforcer.checkRateLimit(user);
        if (!MessageDigest.isEqual(userVerificationCode, verificationCode)) {
            throw new ForbiddenException();
        }
        user.getSurfSecureId().clear();
        this.userRepository.save((Object)user);
        Registration registration = (Registration)this.registrationRepository.findRegistrationByUserId(user.getId()).orElseThrow(IllegalArgumentException::new);
        this.registrationRepository.delete(registration);
        return ResponseEntity.ok((Object)new FinishEnrollment("ok"));
    }

    private User getUserFromAuthenticationRequest(String hash) {
        SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)this.authenticationRequestRepository.findByHash(hash).orElseThrow(() -> new ForbiddenException("Unknown hash"));
        String userId = samlAuthenticationRequest.getUserId();
        return (User)this.userRepository.findById((Object)userId).orElseThrow(() -> new UserNotFoundException(userId));
    }

    private String encode(String s) {
        return URLEncoder.encode(s, Charset.defaultCharset());
    }

    public UserRepository getUserRepository() {
        return this.userRepository;
    }
}

