/*
 * Decompiled with CFR 0.152.
 */
package myconext.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import myconext.cron.IdPMetaDataResolver;
import myconext.model.EduID;
import myconext.model.LinkedAccount;
import myconext.model.PublicKeyCredentials;
import myconext.model.User;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import tiqr.org.model.Registration;
import tiqr.org.model.RegistrationStatus;

public class UserResponse
implements Serializable {
    private final String id;
    private final String email;
    private final String chosenName;
    private final String givenName;
    private final String familyName;
    private final String displayName;
    private final boolean usePassword;
    private final boolean usePublicKey;
    private final boolean forgottenPassword;
    private final List<PublicKeyCredentials> publicKeyCredentials;
    private final List<LinkedAccount> linkedAccounts;
    private final String schacHomeOrganization;
    private final String uid;
    private final boolean rememberMe;
    private final long created;
    private final Map<String, EduID> eduIdPerServiceProvider;
    private final List<String> loginOptions;
    private final Map<String, Object> registration = new HashMap();

    public UserResponse(User user, Map<String, EduID> eduIdPerServiceProvider, Optional<Registration> optionalRegistration, boolean rememberMe, IdPMetaDataResolver idPMetaDataResolver) {
        this.id = user.getId();
        this.email = user.getEmail();
        this.chosenName = user.getChosenName();
        this.givenName = user.getGivenName();
        this.familyName = user.getFamilyName();
        this.displayName = this.givenName + " " + this.familyName;
        this.schacHomeOrganization = user.getSchacHomeOrganization();
        this.uid = user.getUid();
        this.usePassword = StringUtils.hasText((String)user.getPassword());
        this.publicKeyCredentials = user.getPublicKeyCredentials();
        this.linkedAccounts = user.getLinkedAccounts();
        if (!CollectionUtils.isEmpty((Collection)this.linkedAccounts)) {
            this.linkedAccounts.forEach(linkedAccount -> {
                Optional optionalIdentityProvider = idPMetaDataResolver.getIdentityProvider(linkedAccount.getSchacHomeOrganization());
                optionalIdentityProvider.ifPresent(identityProvider -> {
                    linkedAccount.setDisplayNameEn(identityProvider.getDisplayNameEn());
                    linkedAccount.setDisplayNameNl(identityProvider.getDisplayNameNl());
                    linkedAccount.setLogoUrl(identityProvider.getLogoUrl());
                });
            });
        }
        this.usePublicKey = !CollectionUtils.isEmpty((Collection)this.publicKeyCredentials);
        this.forgottenPassword = user.isForgottenPassword();
        this.rememberMe = rememberMe;
        this.created = user.getCreated();
        this.eduIdPerServiceProvider = eduIdPerServiceProvider;
        this.loginOptions = user.loginOptions();
        optionalRegistration.ifPresent(reg -> {
            if (!RegistrationStatus.FINALIZED.equals((Object)reg.getStatus())) {
                return;
            }
            Map surfSecureId = user.getSurfSecureId();
            boolean phoneVerified = surfSecureId.containsKey("phone-verified");
            this.registration.put("created", reg.getCreated().toEpochMilli());
            this.registration.put("status", reg.getStatus());
            this.registration.put("notificationType", reg.getNotificationType());
            this.registration.put("notificationAddress", reg.getNotificationAddress());
            this.registration.put("phoneVerified", phoneVerified);
            this.registration.put("recoveryCode", surfSecureId.containsKey("recovery-code"));
            if (phoneVerified) {
                String phoneNumber = (String)surfSecureId.get("phone-number");
                this.registration.put("phoneNumber", phoneNumber.substring(phoneNumber.length() - 3));
            }
            this.registration.put("updated", reg.getUpdated().toEpochMilli());
        });
    }

    public String getId() {
        return this.id;
    }

    public String getEmail() {
        return this.email;
    }

    public String getChosenName() {
        return this.chosenName;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isUsePassword() {
        return this.usePassword;
    }

    public boolean isUsePublicKey() {
        return this.usePublicKey;
    }

    public boolean isForgottenPassword() {
        return this.forgottenPassword;
    }

    public List<PublicKeyCredentials> getPublicKeyCredentials() {
        return this.publicKeyCredentials;
    }

    public List<LinkedAccount> getLinkedAccounts() {
        return this.linkedAccounts;
    }

    public String getSchacHomeOrganization() {
        return this.schacHomeOrganization;
    }

    public String getUid() {
        return this.uid;
    }

    public boolean isRememberMe() {
        return this.rememberMe;
    }

    public long getCreated() {
        return this.created;
    }

    public Map<String, EduID> getEduIdPerServiceProvider() {
        return this.eduIdPerServiceProvider;
    }

    public List<String> getLoginOptions() {
        return this.loginOptions;
    }

    public Map<String, Object> getRegistration() {
        return this.registration;
    }
}

