/*
 * Decompiled with CFR 0.152.
 */
package myconext.security;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.security.core.CredentialsContainer;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class RemoteUser
implements UserDetails,
CredentialsContainer {
    private String username;
    private String password;
    private String institutionGUID;
    private String schacHome;
    private List<String> scopes;

    public RemoteUser(RemoteUser remoteUser) {
        this.username = remoteUser.username;
        this.password = remoteUser.password;
        this.institutionGUID = remoteUser.institutionGUID;
        this.schacHome = remoteUser.schacHome;
        this.scopes = remoteUser.scopes;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.scopes.stream().map(scope -> new SimpleGrantedAuthority("ROLE_" + scope)).collect(Collectors.toList());
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public void eraseCredentials() {
        this.password = null;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getInstitutionGUID() {
        return this.institutionGUID;
    }

    @Generated
    public String getSchacHome() {
        return this.schacHome;
    }

    @Generated
    public List<String> getScopes() {
        return this.scopes;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setInstitutionGUID(String institutionGUID) {
        this.institutionGUID = institutionGUID;
    }

    @Generated
    public void setSchacHome(String schacHome) {
        this.schacHome = schacHome;
    }

    @Generated
    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    @Generated
    public RemoteUser() {
    }
}

