/*
 * Decompiled with CFR 0.152.
 */
package myconext.model;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import lombok.Generated;
import myconext.model.User;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="password_reset_hashes")
public class PasswordResetHash
implements Serializable {
    @Id
    private String id;
    private String hash;
    private Date expiresIn;
    private String userId;

    public PasswordResetHash(User user, String hash) {
        this.userId = user.getId();
        this.hash = hash;
        this.expiresIn = Date.from(LocalDateTime.now().plusHours(1L).atZone(ZoneId.systemDefault()).toInstant());
    }

    @Transient
    public boolean isExpired() {
        return this.expiresIn.before(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
    }

    @Generated
    public PasswordResetHash() {
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getHash() {
        return this.hash;
    }

    @Generated
    public Date getExpiresIn() {
        return this.expiresIn;
    }

    @Generated
    public String getUserId() {
        return this.userId;
    }
}

