/*
 * Decompiled with CFR 0.152.
 */
package myconext.security;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import myconext.security.RemoteUser;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class ExtendedInMemoryUserDetailsManager
implements UserDetailsService {
    private final Map<String, RemoteUser> users;

    public ExtendedInMemoryUserDetailsManager(List<RemoteUser> users) {
        this.users = users.stream().collect(Collectors.toMap(UserDetails::getUsername, Function.identity()));
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        RemoteUser remoteUser = (RemoteUser)this.users.get(username);
        return remoteUser != null ? new RemoteUser(remoteUser) : null;
    }
}

