/*
 * Decompiled with CFR 0.152.
 */
package myconext.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;
import myconext.api.AccountLinkerController;
import myconext.cron.DisposableEmailProviders;
import myconext.crypto.HashGenerator;
import myconext.exceptions.DuplicateUserEmailException;
import myconext.exceptions.ForbiddenException;
import myconext.exceptions.UserNotFoundException;
import myconext.log.MDCContext;
import myconext.mail.MailBox;
import myconext.manage.Manage;
import myconext.model.AuthorizationURL;
import myconext.model.CreateInstitutionEduID;
import myconext.model.ExternalLinkedAccount;
import myconext.model.IdinIssuers;
import myconext.model.IdpScoping;
import myconext.model.LinkedAccount;
import myconext.model.LoginStatus;
import myconext.model.MobileLinkAccountRequest;
import myconext.model.RequestInstitutionEduID;
import myconext.model.SamlAuthenticationRequest;
import myconext.model.StepUpStatus;
import myconext.model.User;
import myconext.model.VerifyIssuer;
import myconext.repository.AuthenticationRequestRepository;
import myconext.repository.MobileLinkAccountRequestRepository;
import myconext.repository.RequestInstitutionEduIDRepository;
import myconext.repository.UserRepository;
import myconext.security.ACR;
import myconext.security.CookieResolver;
import myconext.security.EmailGuessingPrevention;
import myconext.security.GuestIdpAuthenticationRequestFilter;
import myconext.security.UserAuthentication;
import myconext.verify.AttributeMapper;
import myconext.verify.VerifyState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/myconext/api", "/mobile/api"})
public class AccountLinkerController
implements UserAuthentication {
    private static final Log LOG = LogFactory.getLog(AccountLinkerController.class);
    private final String oidcBaseUrl;
    private final String clientId;
    private final String clientSecret;
    private final String idpFlowRedirectUri;
    private final String spFlowRedirectUri;
    private final String mobileFlowRedirectUri;
    private final String spCreateFromInstitutionRedirectUri;
    private final AuthenticationRequestRepository authenticationRequestRepository;
    private final RequestInstitutionEduIDRepository requestInstitutionEduIDRepository;
    private final MobileLinkAccountRequestRepository mobileLinkAccountRequestRepository;
    private final UserRepository userRepository;
    private final MailBox mailBox;
    private final AttributeMapper attributeMapper;
    private final String magicLinkUrl;
    private final String idpBaseRedirectUrl;
    private final String spRedirectUrl;
    private final String basePath;
    private final long removalValidatedDurationDays;
    private final String myConextSpEntityId;
    private final Manage manage;
    private final String mijnEduIDEntityId;
    private final String schacHomeOrganization;
    private final boolean createEduIDInstitutionEnabled;
    private final BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder(4);
    private final RestTemplate restTemplate = new RestTemplate();
    private final EmailGuessingPrevention emailGuessingPreventor;
    private final DisposableEmailProviders disposableEmailProviders;
    private final String verifySecret;
    private final String verifyClientId;
    private final String verifyBaseUri;
    private final String spVerifyRedirectUri;
    private final String mobileVerifyRedirectUri;
    private final String idpVerifyRedirectUri;
    private final List<VerifyIssuer> issuers;
    private final List<String> unknownIssuers = List.of("CURRNL2A");

    public AccountLinkerController(AuthenticationRequestRepository authenticationRequestRepository, UserRepository userRepository, RequestInstitutionEduIDRepository requestInstitutionEduIDRepository, MobileLinkAccountRequestRepository mobileLinkAccountRequestRepository, MailBox mailBox, AttributeMapper attributeMapper, Manage manage, DisposableEmailProviders disposableEmailProviders, @Value(value="${mijn_eduid_entity_id}") String mijnEduIDEntityId, @Value(value="${schac_home_organization}") String schacHomeOrganization, @Value(value="${email.magic-link-url}") String magicLinkUrl, @Value(value="${idp_redirect_url}") String idpBaseRedirectUrl, @Value(value="${sp_redirect_url}") String spRedirectUrl, @Value(value="${oidc.client-id}") String clientId, @Value(value="${oidc.secret}") String clientSecret, @Value(value="${oidc.idp-flow-redirect-url}") String idpFlowRedirectUri, @Value(value="${oidc.sp-flow-redirect-url}") String spFlowRedirectUri, @Value(value="${oidc.mobile-flow-redirect-url}") String mobileFlowRedirectUri, @Value(value="${oidc.sp-create-from-institution-redirect-url}") String spCreateFromInstitutionRedirectUri, @Value(value="${oidc.base-url}") String oidcBaseUrl, @Value(value="${base_path}") String basePath, @Value(value="${linked_accounts.removal-duration-days-validated}") long removalValidatedDurationDays, @Value(value="${account_linking.myconext_sp_entity_id}") String myConextSpEntityId, @Value(value="${feature.create_eduid_institution_enabled}") boolean createEduIDInstitutionEnabled, @Value(value="${email_guessing_sleep_millis}") int emailGuessingSleepMillis, @Value(value="${verify.client_id}") String verifyClientId, @Value(value="${verify.secret}") String verifySecret, @Value(value="${verify.sp_verify_redirect_url}") String spVerifyRedirectUri, @Value(value="${verify.idp_verify_redirect_url}") String idpVerifyRedirectUri, @Value(value="${verify.mobile_verify_redirect_url}") String mobileVerifyRedirectUri, @Value(value="${verify.base_uri}") String verifyBaseUri, @Value(value="${verify.issuers_path}") Resource issuersResource, ObjectMapper objectMapper) throws IOException {
        this.authenticationRequestRepository = authenticationRequestRepository;
        this.userRepository = userRepository;
        this.requestInstitutionEduIDRepository = requestInstitutionEduIDRepository;
        this.mobileLinkAccountRequestRepository = mobileLinkAccountRequestRepository;
        this.mailBox = mailBox;
        this.attributeMapper = attributeMapper;
        this.manage = manage;
        this.disposableEmailProviders = disposableEmailProviders;
        this.schacHomeOrganization = schacHomeOrganization;
        this.mijnEduIDEntityId = mijnEduIDEntityId;
        this.magicLinkUrl = magicLinkUrl;
        this.idpBaseRedirectUrl = idpBaseRedirectUrl;
        this.spRedirectUrl = spRedirectUrl;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.idpFlowRedirectUri = idpFlowRedirectUri;
        this.spFlowRedirectUri = spFlowRedirectUri;
        this.mobileFlowRedirectUri = mobileFlowRedirectUri;
        this.spCreateFromInstitutionRedirectUri = spCreateFromInstitutionRedirectUri;
        this.basePath = basePath;
        this.oidcBaseUrl = oidcBaseUrl;
        this.removalValidatedDurationDays = removalValidatedDurationDays;
        this.myConextSpEntityId = myConextSpEntityId;
        this.createEduIDInstitutionEnabled = createEduIDInstitutionEnabled;
        this.emailGuessingPreventor = new EmailGuessingPrevention(emailGuessingSleepMillis);
        this.verifyClientId = verifyClientId;
        this.verifySecret = verifySecret;
        this.verifyBaseUri = verifyBaseUri;
        this.mobileVerifyRedirectUri = mobileVerifyRedirectUri;
        this.spVerifyRedirectUri = spVerifyRedirectUri;
        this.idpVerifyRedirectUri = idpVerifyRedirectUri;
        List idinIssuers = (List)objectMapper.readValue(issuersResource.getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        this.issuers = ((IdinIssuers)idinIssuers.get(0)).getIssuers().stream().filter(issuer -> !this.unknownIssuers.contains(issuer.getId())).collect(Collectors.toList());
        LOG.debug((Object)String.format("Initialized IDIN issuers %s from %s", this.issuers, issuersResource.getDescription()));
    }

    @GetMapping(value={"/idp/oidc/account/{id}"})
    @Hidden
    public ResponseEntity startIdPLinkAccountFlow(@PathVariable(value="id") String id, @RequestParam(value="forceAuth", required=false, defaultValue="false") boolean forceAuth) throws UnsupportedEncodingException {
        Optional optionalSamlAuthenticationRequest = this.authenticationRequestRepository.findByIdAndNotExpired(id);
        if (!optionalSamlAuthenticationRequest.isPresent()) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).location(URI.create(this.idpBaseRedirectUrl + "/expired"))).build();
        }
        SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)optionalSamlAuthenticationRequest.get();
        String userId = samlAuthenticationRequest.getUserId();
        User user = (User)this.userRepository.findById((Object)userId).orElseThrow(() -> new UserNotFoundException(userId));
        LOG.info((Object)String.format("Start IdP link account flow for user %s", user.getEmail()));
        String state = String.format("id=%s&user_uid=%s", id, this.passwordEncoder.encode((CharSequence)user.getUid()));
        UriComponents uriComponents = this.doStartLinkAccountFlow(state, this.idpFlowRedirectUri, forceAuth, samlAuthenticationRequest.getRequesterEntityId());
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).location(uriComponents.toUri())).build();
    }

    @GetMapping(value={"/sp/create-from-institution"})
    @Hidden
    public ResponseEntity<Map<String, String>> createFromInstitution(HttpServletRequest request, @RequestParam(value="forceAuth", required=false, defaultValue="false") boolean forceAuth) throws UnsupportedEncodingException {
        LOG.info((Object)"Start create from institution");
        String state = request.getSession(true).getId();
        UriComponents uriComponents = this.doStartLinkAccountFlow(state, this.spCreateFromInstitutionRedirectUri, forceAuth, this.myConextSpEntityId);
        return ResponseEntity.ok(Collections.singletonMap("url", uriComponents.toUriString()));
    }

    @GetMapping(value={"/sp/create-from-institution/oidc-redirect"})
    @Hidden
    public ResponseEntity spCreateFromInstitutionRedirect(HttpServletRequest request, @RequestParam(value="code") String code, @RequestParam(value="state") String state) throws UnsupportedEncodingException {
        LOG.info((Object)"In redirect for create-institution-flow");
        HttpSession session = request.getSession(false);
        if (session == null || !this.createEduIDInstitutionEnabled) {
            throw new ForbiddenException("No session enabled");
        }
        String storedState = session.getId();
        if (!MessageDigest.isEqual(storedState.getBytes(StandardCharsets.UTF_8), URLDecoder.decode(state, StandardCharsets.UTF_8).getBytes(StandardCharsets.UTF_8))) {
            throw new ForbiddenException("No session enabled");
        }
        Map userInfo = this.requestUserInfo(code, this.spCreateFromInstitutionRedirectUri);
        String eppn = (String)userInfo.get("eduperson_principal_name");
        String eppnAlreadyLinkedRequiredUri = this.spRedirectUrl + "/create-from-institution/eppn-already-linked?fromInstitution=true";
        Optional eppnAlreadyLinkedOptional = this.checkEppnAlreadyLinked(eppnAlreadyLinkedRequiredUri, eppn);
        if (eppnAlreadyLinkedOptional.isPresent()) {
            LOG.debug((Object)("EPPN already linked in create-institution-flow for " + eppn));
            return (ResponseEntity)eppnAlreadyLinkedOptional.get();
        }
        RequestInstitutionEduID requestInstitutionEduID = new RequestInstitutionEduID(HashGenerator.hash(), userInfo);
        this.requestInstitutionEduIDRepository.save((Object)requestInstitutionEduID);
        String returnUri = this.spRedirectUrl + "/create-from-institution/link/" + requestInstitutionEduID.getHash();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).location(URI.create(returnUri))).build();
    }

    @GetMapping(value={"/sp/create-from-institution/info"})
    @Hidden
    public Map<String, Object> createFromInstitutionInfo(@RequestParam(value="hash") String hash) {
        RequestInstitutionEduID requestInstitutionEduID = (RequestInstitutionEduID)this.requestInstitutionEduIDRepository.findByHash(hash).orElseThrow(() -> new ForbiddenException("Wrong hash"));
        LOG.info((Object)String.format("Info details for create-institution-flow %s", requestInstitutionEduID));
        return requestInstitutionEduID.getUserInfo();
    }

    @PostMapping(value={"/sp/create-from-institution/email"})
    @Hidden
    public ResponseEntity<Map<String, String>> linkFromInstitution(@Valid @RequestBody CreateInstitutionEduID createInstitutionEduID) {
        LOG.info((Object)String.format("Post details for account verification in create-institution-flow %s", createInstitutionEduID.getEmail()));
        RequestInstitutionEduID requestInstitutionEduID = (RequestInstitutionEduID)this.requestInstitutionEduIDRepository.findByHash(createInstitutionEduID.getHash()).orElseThrow(() -> new ForbiddenException("Wrong hash"));
        String email = createInstitutionEduID.getEmail();
        this.disposableEmailProviders.verifyDisposableEmailProviders(email);
        this.emailGuessingPreventor.potentialUserEmailGuess();
        Optional userByEmail = this.userRepository.findUserByEmail(email);
        boolean newUser = createInstitutionEduID.isNewUser();
        if (newUser && userByEmail.isPresent()) {
            throw new DuplicateUserEmailException("There already exists a user with email " + email);
        }
        if (!newUser && userByEmail.isEmpty()) {
            throw new UserNotFoundException("User not found: " + email);
        }
        User user = userByEmail.orElse(new User(createInstitutionEduID, requestInstitutionEduID.getUserInfo()));
        requestInstitutionEduID.setUserId(user.getId());
        requestInstitutionEduID.setCreateInstitutionEduID(createInstitutionEduID);
        requestInstitutionEduID.setEmailHash(HashGenerator.hash());
        this.requestInstitutionEduIDRepository.save((Object)requestInstitutionEduID);
        String uri = this.basePath + "/myconext/api/sp/create-from-institution/finish";
        this.mailBox.sendAccountVerificationCreateFromInstitution(user, requestInstitutionEduID.getEmailHash(), uri);
        return ResponseEntity.ok(Map.of("status", "ok"));
    }

    @GetMapping(value={"/sp/create-from-institution/poll"})
    @Hidden
    public int pollCreateFromInstitution(@RequestParam(value="hash") String hash) {
        LOG.debug((Object)"Poll login status for create-institution-flow");
        RequestInstitutionEduID requestInstitutionEduID = (RequestInstitutionEduID)this.requestInstitutionEduIDRepository.findByHash(hash).orElseThrow(() -> new ForbiddenException("Wrong hash"));
        return requestInstitutionEduID.getLoginStatus().ordinal();
    }

    @GetMapping(value={"/sp/create-from-institution/resendMail"})
    @Hidden
    public void resendMailCreateFromInstitution(@RequestParam(value="hash") String hash) {
        LOG.debug((Object)"Resend mail for create-institution-flow");
        RequestInstitutionEduID requestInstitutionEduID = (RequestInstitutionEduID)this.requestInstitutionEduIDRepository.findByHash(hash).orElseThrow(() -> new ForbiddenException("Wrong hash"));
        if (!requestInstitutionEduID.getLoginStatus().equals((Object)LoginStatus.NOT_LOGGED_IN)) {
            throw new ForbiddenException("User status is not NOT_LOGGED_IN, but " + requestInstitutionEduID.getLoginStatus());
        }
        String uri = this.basePath + "/myconext/api/sp/create-from-institution/finish";
        User user = new User(requestInstitutionEduID.getCreateInstitutionEduID(), requestInstitutionEduID.getUserInfo());
        this.mailBox.sendAccountVerificationCreateFromInstitution(user, requestInstitutionEduID.getEmailHash(), uri);
    }

    @GetMapping(value={"/sp/create-from-institution/finish"})
    @Hidden
    public ResponseEntity createFromInstitutionFinish(HttpServletRequest request, @RequestParam(value="h") String emailHash) throws UnsupportedEncodingException {
        LOG.debug((Object)"Finish create-institution-flow flow and create account");
        RequestInstitutionEduID requestInstitutionEduID = (RequestInstitutionEduID)this.requestInstitutionEduIDRepository.findByEmailHashAndLoginStatus(emailHash, LoginStatus.NOT_LOGGED_IN).orElseThrow(() -> new ForbiddenException("Wrong emailHash"));
        CreateInstitutionEduID createInstitutionEduID = requestInstitutionEduID.getCreateInstitutionEduID();
        if (createInstitutionEduID == null) {
            throw new ForbiddenException("Tampering");
        }
        Map userInfo = requestInstitutionEduID.getUserInfo();
        String preferredLanguage = CookieResolver.cookieByName((HttpServletRequest)request, (String)"lang").map(Cookie::getValue).orElse("en");
        boolean existingUser = !createInstitutionEduID.isNewUser() && StringUtils.hasText((String)requestInstitutionEduID.getUserId());
        User user = existingUser ? (User)this.userRepository.findById((Object)requestInstitutionEduID.getUserId()).orElseThrow(() -> new UserNotFoundException("User not found")) : new User(UUID.randomUUID().toString(), createInstitutionEduID.getEmail(), (String)userInfo.get("given_name"), (String)userInfo.get("given_name"), (String)userInfo.get("family_name"), this.schacHomeOrganization, preferredLanguage, this.mijnEduIDEntityId, this.manage);
        user.setCreateFromInstitutionKey(HashGenerator.hash());
        ResponseEntity responseEntity = this.saveOrUpdateLinkedAccountToUser(user, this.idpBaseRedirectUrl + "/create-from-institution-login?key=" + user.getCreateFromInstitutionKey(), false, false, false, null, null, null, userInfo);
        requestInstitutionEduID.setLoginStatus(LoginStatus.LOGGED_IN_SAME_DEVICE);
        this.requestInstitutionEduIDRepository.save((Object)requestInstitutionEduID);
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)user, null, user.getAuthorities());
        SecurityContext context = SecurityContextHolder.getContext();
        context.setAuthentication((Authentication)authentication);
        HttpSession session = request.getSession();
        session.setAttribute("SPRING_SECURITY_CONTEXT", (Object)context);
        return responseEntity;
    }

    @GetMapping(value={"/sp/oidc/link"})
    @Operation(summary="Start link account flow", description="Start the link account flow for the current user.<br/>After the account has been linked the user is redirect to one the following URL's:<ul><li>Success: <a href=\"\">https://login.{environment}.eduid.nl/client/mobile/account-linked</a></li><li>Failure, EPPN already linked: <a href=\"\">https://login.{environment}.eduid.nl/client/mobile/eppn-already-linked?email=jdoe%40example.com</a></li><li>Failure, session expired: <a href=\"\">https://login.{environment}.eduid.nl/client/mobile/expired</a></li></ul>", responses={@ApiResponse(responseCode="200", description="Url for authentication", useReturnTypeSchema=true, content={@Content(schema=@Schema(implementation=AuthorizationURL.class), examples={@ExampleObject(value="{\"url\":\"https://connect.test2.surfconext.nl/oidc/authorize?scope=openid&response_type=code&redirect_uri=https://mijn.test2.eduid.nl/myconext/api/sp/oidc/redirect&state=%242a%2410%249cyC3mjeJW0ljb%2FmPAGj0O4DVXz9LPw5U%2Fthl110BVYWFpMhjwKyK&prompt=login&client_id=myconext.ala.eduid\"}")})})})
    public ResponseEntity<AuthorizationURL> startSPLinkAccountFlow(Authentication authentication) throws UnsupportedEncodingException {
        String redirectUri;
        String state;
        User user = this.userFromAuthentication(authentication);
        LOG.info((Object)String.format("Start link account flow for user %s", user.getEmail()));
        if (this.isMobileRequest(authentication)) {
            MobileLinkAccountRequest mobileLinkAccountRequest = (MobileLinkAccountRequest)this.mobileLinkAccountRequestRepository.save((Object)new MobileLinkAccountRequest(HashGenerator.hash(), user.getId()));
            state = mobileLinkAccountRequest.getHash();
            redirectUri = this.mobileFlowRedirectUri;
        } else {
            state = this.passwordEncoder.encode((CharSequence)user.getUid());
            redirectUri = this.spFlowRedirectUri;
        }
        UriComponents uriComponents = this.doStartLinkAccountFlow(state, redirectUri, true, this.myConextSpEntityId);
        return ResponseEntity.ok((Object)new AuthorizationURL(uriComponents.toUriString()));
    }

    @GetMapping(value={"/sp/idin/issuers"})
    @Operation(summary="All verify issuers", description="All verify issuers to build the select Bank page for ID verificatin")
    public ResponseEntity<List<VerifyIssuer>> issuers() {
        LOG.debug((Object)"Retrieve IDIN issuers");
        return ResponseEntity.ok((Object)this.issuers);
    }

    @GetMapping(value={"/sp/verify/link"})
    @Operation(summary="Start verify ID flow for signicat from SP flow", description="Start the verify ID flow for the current user.<br/>After the account has been linked the user is redirect to one the following URL's:<ul><li>Success: <a href=\"\">https://login.{environment}.eduid.nl/client/mobile/verify-account-linked</a></li><li>Failure, something went wrong: <a href=\"\">https://login.{environment}.eduid.nl/client/mobile/verify-error</a></li></ul>", responses={@ApiResponse(responseCode="200", description="Url for authentication", useReturnTypeSchema=true, content={@Content(schema=@Schema(implementation=AuthorizationURL.class), examples={@ExampleObject(value="{\"url\":\"https://validate.test.eduid.nl/broker/sp/oidc/authenticate?scope=openid&response_type=code&redirect_uri=https://mijn.test2.eduid.nl/myconext/api/sp/verify/redirect&state=%242a%2410%249cyC3mjeJW0ljb%2FmPAGj0O4DVXz9LPw5U%2Fthl110BVYWFpMhjwKyK&prompt=login&client_id=myconext.ala.eduid\"}")})})})
    public ResponseEntity<AuthorizationURL> startSPVerifyIDLinkAccountFlow(Authentication authentication, @RequestParam(value="idpScoping") IdpScoping idpScoping, @RequestParam(value="bankId", required=false) String bankId) {
        String redirectUri;
        String stateIdentifier;
        User user = this.userFromAuthentication(authentication);
        LOG.info((Object)String.format("Start verify account flow for user %s for flow %s", user.getEmail(), idpScoping));
        if (this.isMobileRequest(authentication)) {
            MobileLinkAccountRequest mobileLinkAccountRequest = (MobileLinkAccountRequest)this.mobileLinkAccountRequestRepository.save((Object)new MobileLinkAccountRequest(HashGenerator.hash(), user.getId()));
            stateIdentifier = mobileLinkAccountRequest.getHash();
            redirectUri = this.mobileVerifyRedirectUri;
        } else {
            stateIdentifier = this.passwordEncoder.encode((CharSequence)user.getUid());
            redirectUri = this.spVerifyRedirectUri;
        }
        VerifyIssuer verifyIssuer = idpScoping.equals((Object)IdpScoping.idin) ? this.issuers.stream().filter(issuer -> issuer.getId().equals(bankId)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown verify issuer: " + bankId)) : new VerifyIssuer(IdpScoping.eherkenning.name(), IdpScoping.eherkenning.name());
        VerifyState verifyState = new VerifyState(stateIdentifier, idpScoping, verifyIssuer);
        String state = this.attributeMapper.serializeToBase64(verifyState);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", this.verifyClientId);
        params.put("response_type", "code");
        params.put("scope", String.format("openid dateofbirth name idp_scoping:%s%s", idpScoping.name(), StringUtils.hasText((String)bankId) ? " signicat:param:idin_idp:" + bankId : ""));
        params.put("redirect_uri", redirectUri);
        params.put("state", state);
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)(this.verifyBaseUri + "/broker/sp/oidc/authenticate"));
        params.forEach((x$0, xva$1) -> builder.queryParam(x$0, new Object[]{xva$1}));
        UriComponents uriComponents = builder.build();
        return ResponseEntity.ok((Object)new AuthorizationURL(uriComponents.toUriString()));
    }

    @GetMapping(value={"/sp/verify/redirect"})
    @Hidden
    public ResponseEntity spVerifyIDRedirect(Authentication authentication, @RequestParam(value="code", required=false) String code, @RequestParam(value="state", required=false) String state, @RequestParam(value="error", required=false) String error, @RequestParam(value="error_description", required=false) String errorDescription) {
        User user = this.userFromAuthentication(authentication);
        if (!StringUtils.hasText((String)code) || !StringUtils.hasText((String)state)) {
            URI location = URI.create(String.format("%s/external-account-linked-error?error=%s&error_description=%s", this.spRedirectUrl, StringUtils.hasText((String)error) ? URLEncoder.encode(error, Charset.defaultCharset()) : "", StringUtils.hasText((String)errorDescription) ? URLEncoder.encode(errorDescription, Charset.defaultCharset()) : "Unexpected+error+occurred"));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).location(location)).build();
        }
        VerifyState verifyState = this.attributeMapper.serializeFromBase64(state);
        LOG.info((Object)String.format("In SP verify ID redirect link account for user %s and party %s", user.getEmail(), verifyState.getIdpScoping()));
        if (!this.passwordEncoder.matches((CharSequence)user.getUid(), verifyState.getStateIdentifier())) {
            throw new ForbiddenException("Non matching user");
        }
        HttpHeaders headers = this.getHttpHeaders();
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"client_id", (Object)this.verifyClientId);
        map.add((Object)"client_secret", (Object)this.verifySecret);
        map.add((Object)"code", (Object)code);
        map.add((Object)"grant_type", (Object)"authorization_code");
        map.add((Object)"redirect_uri", (Object)this.spVerifyRedirectUri);
        map.add((Object)"scope", (Object)"openid");
        HttpEntity request = new HttpEntity((Object)map, (MultiValueMap)headers);
        2 parameterizedTypeReference = new /* Unavailable Anonymous Inner Class!! */;
        Map body = (Map)this.restTemplate.exchange(this.verifyBaseUri + "/broker/sp/oidc/token", HttpMethod.POST, request, (ParameterizedTypeReference)parameterizedTypeReference, new Object[0]).getBody();
        LinkedMultiValueMap tokenMap = new LinkedMultiValueMap();
        tokenMap.add((Object)"access_token", (Object)((String)body.get("access_token")));
        request = new HttpEntity((Object)tokenMap, (MultiValueMap)headers);
        Map attributes = (Map)this.restTemplate.exchange(this.verifyBaseUri + "/broker/sp/oidc/userinfo", HttpMethod.POST, request, (ParameterizedTypeReference)parameterizedTypeReference, new Object[0]).getBody();
        ExternalLinkedAccount externalLinkedAccount = this.attributeMapper.externalLinkedAccountFromAttributes(attributes, verifyState);
        List optionalUsers = this.userRepository.findByExternalLinkedAccounts_SubjectId(externalLinkedAccount.getSubjectId());
        if (!optionalUsers.isEmpty() && optionalUsers.stream().anyMatch(existingUser -> !user.getId().equals(existingUser.getId()))) {
            LOG.warn((Object)String.format("SP redirect for external account linking: subject %s already linked to %s for party %s", externalLinkedAccount.getSubjectId(), user.getEmail(), verifyState.getIdpScoping()));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).location(URI.create(this.spRedirectUrl + "/subject-already-linked?idp_scoping"))).build();
        }
        List externalLinkedAccounts = user.getExternalLinkedAccounts();
        externalLinkedAccounts.clear();
        externalLinkedAccounts.add(externalLinkedAccount);
        if (StringUtils.hasText((String)externalLinkedAccount.getFirstName()) && IdpScoping.eherkenning.equals((Object)externalLinkedAccount.getIdpScoping())) {
            user.setGivenName(externalLinkedAccount.getFirstName());
        }
        if (StringUtils.hasText((String)externalLinkedAccount.getInitials()) && IdpScoping.idin.equals((Object)externalLinkedAccount.getIdpScoping())) {
            user.setGivenName(externalLinkedAccount.getInitials());
        }
        if (StringUtils.hasText((String)externalLinkedAccount.getLegalLastName())) {
            user.setFamilyName(externalLinkedAccount.getLegalLastName());
        }
        if (externalLinkedAccount.getDateOfBirth() != null) {
            user.setDateOfBirth(externalLinkedAccount.getDateOfBirth());
        }
        this.userRepository.save((Object)user);
        URI location = URI.create(this.spRedirectUrl + "/personal?verify=" + externalLinkedAccount.getIdpScoping());
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).location(location)).build();
    }

    @GetMapping(value={"/idp/verify/link/{id}"})
    @Hidden
    public ResponseEntity<AuthorizationURL> startIdPVerifyIDLinkAccountFlow(@PathVariable(value="id") String id, @RequestParam(value="idpScoping") IdpScoping idpScoping, @RequestParam(value="bankId", required=false) String bankId) {
        Optional optionalSamlAuthenticationRequest = this.authenticationRequestRepository.findByIdAndNotExpired(id);
        if (!optionalSamlAuthenticationRequest.isPresent()) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).location(URI.create(this.idpBaseRedirectUrl + "/expired"))).build();
        }
        SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)optionalSamlAuthenticationRequest.get();
        String userId = samlAuthenticationRequest.getUserId();
        User user = (User)this.userRepository.findById((Object)userId).orElseThrow(() -> new UserNotFoundException(userId));
        LOG.info((Object)String.format("Start Idp verify account flow for user %s and party %s", user.getEmail(), idpScoping));
        VerifyIssuer verifyIssuer = idpScoping.equals((Object)IdpScoping.idin) ? this.issuers.stream().filter(issuer -> issuer.getId().equals(bankId)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown verify issuer: " + bankId)) : new VerifyIssuer(IdpScoping.eherkenning.name(), IdpScoping.eherkenning.name());
        String stateIdentifier = String.format("id=%s&user_uid=%s", id, this.passwordEncoder.encode((CharSequence)user.getUid()));
        VerifyState verifyState = new VerifyState(stateIdentifier, idpScoping, verifyIssuer);
        String state = this.attributeMapper.serializeToBase64(verifyState);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", this.verifyClientId);
        params.put("response_type", "code");
        params.put("scope", String.format("openid dateofbirth name idp_scoping:%s%s", idpScoping.name(), StringUtils.hasText((String)bankId) ? " signicat:param:idin_idp:" + bankId : ""));
        params.put("redirect_uri", this.idpVerifyRedirectUri);
        params.put("state", state);
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)(this.verifyBaseUri + "/broker/sp/oidc/authenticate"));
        params.forEach((x$0, xva$1) -> builder.queryParam(x$0, new Object[]{xva$1}));
        UriComponents uriComponents = builder.build();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).location(uriComponents.toUri())).build();
    }

    @GetMapping(value={"/idp/verify/redirect"})
    @Hidden
    public ResponseEntity idpVerifyIDRedirect(@RequestParam(value="code", required=false) String code, @RequestParam(value="state", required=false) String state, @RequestParam(value="error", required=false) String error, @RequestParam(value="error_description", required=false) String errorDescription) {
        LOG.debug((Object)"In IDP verify ID redirect link account");
        if (!StringUtils.hasText((String)code) || !StringUtils.hasText((String)state)) {
            URI location = URI.create(String.format("%s/external-account-linked-error?error=%s&error_description=%s", this.idpBaseRedirectUrl, StringUtils.hasText((String)error) ? URLEncoder.encode(error, Charset.defaultCharset()) : "", StringUtils.hasText((String)errorDescription) ? URLEncoder.encode(errorDescription, Charset.defaultCharset()) : "Unexpected+error+occurred"));
            LOG.warn((Object)"Error response from trusted party for external account linking");
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).location(location)).build();
        }
        VerifyState verifyState = this.attributeMapper.serializeFromBase64(state);
        String httpUrl = "http://localhost?" + verifyState.getStateIdentifier();
        MultiValueMap params = UriComponentsBuilder.fromHttpUrl((String)httpUrl).build().getQueryParams();
        String id = (String)params.getFirst((Object)"id");
        String encodedUserUid = (String)params.getFirst((Object)"user_uid");
        Optional optionalSamlAuthenticationRequest = this.authenticationRequestRepository.findByIdAndNotExpired(id);
        if (!optionalSamlAuthenticationRequest.isPresent()) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).location(URI.create(this.idpBaseRedirectUrl + "/expired"))).build();
        }
        SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)optionalSamlAuthenticationRequest.get();
        String userId = samlAuthenticationRequest.getUserId();
        User user = (User)this.userRepository.findById((Object)userId).orElseThrow(() -> new UserNotFoundException(userId));
        LOG.info((Object)String.format("In IDP verify ID redirect link account for user %s and party %s", user.getEmail(), verifyState.getIdpScoping()));
        if (!this.passwordEncoder.matches((CharSequence)user.getUid(), encodedUserUid)) {
            throw new ForbiddenException("Non matching user");
        }
        HttpHeaders headers = this.getHttpHeaders();
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"client_id", (Object)this.verifyClientId);
        map.add((Object)"client_secret", (Object)this.verifySecret);
        map.add((Object)"code", (Object)code);
        map.add((Object)"grant_type", (Object)"authorization_code");
        map.add((Object)"redirect_uri", (Object)this.spVerifyRedirectUri);
        map.add((Object)"scope", (Object)"openid");
        HttpEntity request = new HttpEntity((Object)map, (MultiValueMap)headers);
        3 parameterizedTypeReference = new /* Unavailable Anonymous Inner Class!! */;
        Map body = (Map)this.restTemplate.exchange(this.verifyBaseUri + "/broker/sp/oidc/token", HttpMethod.POST, request, (ParameterizedTypeReference)parameterizedTypeReference, new Object[0]).getBody();
        LinkedMultiValueMap tokenMap = new LinkedMultiValueMap();
        tokenMap.add((Object)"access_token", (Object)((String)body.get("access_token")));
        request = new HttpEntity((Object)tokenMap, (MultiValueMap)headers);
        Map attributes = (Map)this.restTemplate.exchange(this.verifyBaseUri + "/broker/sp/oidc/userinfo", HttpMethod.POST, request, (ParameterizedTypeReference)parameterizedTypeReference, new Object[0]).getBody();
        ExternalLinkedAccount externalLinkedAccount = this.attributeMapper.externalLinkedAccountFromAttributes(attributes, verifyState);
        List optionalUsers = this.userRepository.findByExternalLinkedAccounts_SubjectId(externalLinkedAccount.getSubjectId());
        if (!optionalUsers.isEmpty() && optionalUsers.stream().anyMatch(existingUser -> !user.getId().equals(existingUser.getId()))) {
            LOG.warn((Object)String.format("Subject %s already linked to user %s", externalLinkedAccount.getSubjectId(), user.getEmail()));
            String subjectAlreadyLinkedRequiredUri = this.idpBaseRedirectUrl + "/subject-already-linked/" + samlAuthenticationRequest.getId() + "?h=" + samlAuthenticationRequest.getHash() + "&redirect=" + URLEncoder.encode(this.magicLinkUrl, Charset.defaultCharset());
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).location(URI.create(subjectAlreadyLinkedRequiredUri))).build();
        }
        List externalLinkedAccounts = user.getExternalLinkedAccounts();
        externalLinkedAccounts.clear();
        externalLinkedAccounts.add(externalLinkedAccount);
        LOG.info((Object)String.format("New external linked account %s for user %s", externalLinkedAccount, user.getEmail()));
        if (StringUtils.hasText((String)externalLinkedAccount.getFirstName()) && IdpScoping.eherkenning.equals((Object)externalLinkedAccount.getIdpScoping())) {
            user.setGivenName(externalLinkedAccount.getFirstName());
        }
        if (StringUtils.hasText((String)externalLinkedAccount.getLegalLastName())) {
            user.setFamilyName(externalLinkedAccount.getLegalLastName());
        }
        if (externalLinkedAccount.getDateOfBirth() != null) {
            user.setDateOfBirth(externalLinkedAccount.getDateOfBirth());
        }
        this.userRepository.save((Object)user);
        String location = this.magicLinkUrl + "?h=" + samlAuthenticationRequest.getHash();
        samlAuthenticationRequest.setSteppedUp(StepUpStatus.IN_STEP_UP);
        this.authenticationRequestRepository.save((Object)samlAuthenticationRequest);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).location(URI.create(location))).build();
    }

    private UriComponents doStartLinkAccountFlow(String state, String redirectUri, boolean forceAuth, String requesterEntityId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", this.clientId);
        params.put("response_type", "code");
        params.put("scope", "openid");
        params.put("redirect_uri", redirectUri);
        params.put("state", URLEncoder.encode(state, StandardCharsets.UTF_8));
        if (forceAuth) {
            params.put("prompt", "login");
        }
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)(this.oidcBaseUrl + "/oidc/authorize"));
        params.forEach((x$0, xva$1) -> builder.queryParam(x$0, new Object[]{xva$1}));
        return builder.build();
    }

    private HttpHeaders getHttpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        return headers;
    }

    @GetMapping(value={"/sp/oidc/redirect"})
    @Hidden
    public ResponseEntity spFlowRedirect(Authentication authentication, @RequestParam(value="code") String code, @RequestParam(value="state") String state) throws UnsupportedEncodingException {
        LOG.debug((Object)"");
        User user = this.userFromAuthentication(authentication);
        LOG.info((Object)String.format("In SP redirect link account for user %s", user.getEmail()));
        if (!this.passwordEncoder.matches((CharSequence)user.getUid(), URLDecoder.decode(state, StandardCharsets.UTF_8))) {
            throw new ForbiddenException("Non matching user");
        }
        return this.doRedirect(code, user, this.spFlowRedirectUri, this.spRedirectUrl + "/personal", false, false, true, null, null, this.spRedirectUrl + "/eppn-already-linked");
    }

    @GetMapping(value={"/mobile/oidc/redirect"})
    @Hidden
    public ResponseEntity mobileFlowRedirect(@RequestParam(value="code") String code, @RequestParam(value="state") String state) throws UnsupportedEncodingException {
        String decodedState = URLDecoder.decode(state, StandardCharsets.UTF_8);
        Optional optionalMobileLinkAccountRequest = this.mobileLinkAccountRequestRepository.findByHash(decodedState);
        if (!optionalMobileLinkAccountRequest.isPresent()) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).location(URI.create(this.idpBaseRedirectUrl + "/client/mobile/expired"))).build();
        }
        MobileLinkAccountRequest mobileLinkAccountRequest = (MobileLinkAccountRequest)optionalMobileLinkAccountRequest.get();
        String userId = mobileLinkAccountRequest.getUserId();
        User user = (User)this.userRepository.findById((Object)userId).orElseThrow(() -> new UserNotFoundException(userId));
        LOG.info((Object)String.format("In Mobile redirect link account for user %s", user.getEmail()));
        this.mobileLinkAccountRequestRepository.delete((Object)mobileLinkAccountRequest);
        return this.doRedirect(code, user, this.mobileFlowRedirectUri, this.idpBaseRedirectUrl + "/client/mobile/account-linked", false, false, true, null, null, this.idpBaseRedirectUrl + "/client/mobile/eppn-already-linked");
    }

    @GetMapping(value={"/idp/oidc/redirect"})
    @Hidden
    public ResponseEntity idpFlowRedirect(@RequestParam(value="code") String code, @RequestParam(value="state") String state) throws UnsupportedEncodingException {
        String eppnAlreadyLinkedRequiredUri;
        String idpValidNamesRequiredUri;
        String decodedState = URLDecoder.decode(state, StandardCharsets.UTF_8);
        MultiValueMap params = UriComponentsBuilder.fromHttpUrl((String)("http://localhost?" + decodedState)).build().getQueryParams();
        String id = (String)params.getFirst((Object)"id");
        String encodedUserUid = (String)params.getFirst((Object)"user_uid");
        Optional optionalSamlAuthenticationRequest = this.authenticationRequestRepository.findByIdAndNotExpired(id);
        if (!optionalSamlAuthenticationRequest.isPresent()) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).location(URI.create(this.idpBaseRedirectUrl + "/expired"))).build();
        }
        SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)optionalSamlAuthenticationRequest.get();
        String userId = samlAuthenticationRequest.getUserId();
        User user = (User)this.userRepository.findById((Object)userId).orElseThrow(() -> new UserNotFoundException(userId));
        LOG.info((Object)String.format("In IdP oidc redirect link account for user %s", user.getEmail()));
        if (!this.passwordEncoder.matches((CharSequence)user.getUid(), encodedUserUid)) {
            throw new ForbiddenException("Non matching user");
        }
        boolean validateNames = samlAuthenticationRequest.getAuthenticationContextClassReferences().contains(ACR.VALIDATE_NAMES);
        boolean studentAffiliationRequired = samlAuthenticationRequest.getAuthenticationContextClassReferences().contains(ACR.AFFILIATION_STUDENT);
        String location = this.magicLinkUrl + "?h=" + samlAuthenticationRequest.getHash();
        String charSet = Charset.defaultCharset().name();
        String idpStudentAffiliationRequiredUri = this.idpBaseRedirectUrl + "/affiliation-missing/" + samlAuthenticationRequest.getId() + "?h=" + samlAuthenticationRequest.getHash() + "&redirect=" + URLEncoder.encode(this.magicLinkUrl, charSet);
        ResponseEntity redirect = this.doRedirect(code, user, this.idpFlowRedirectUri, location, validateNames, studentAffiliationRequired, false, idpStudentAffiliationRequiredUri, idpValidNamesRequiredUri = this.idpBaseRedirectUrl + "/valid-name-missing/" + samlAuthenticationRequest.getId() + "?h=" + samlAuthenticationRequest.getHash() + "&redirect=" + URLEncoder.encode(this.magicLinkUrl, charSet), eppnAlreadyLinkedRequiredUri = this.idpBaseRedirectUrl + "/eppn-already-linked/" + samlAuthenticationRequest.getId() + "?h=" + samlAuthenticationRequest.getHash() + "&redirect=" + URLEncoder.encode(this.magicLinkUrl, charSet));
        StepUpStatus stepUpStatus = redirect.getHeaders().getLocation().toString().contains("affiliation-missing") ? StepUpStatus.MISSING_AFFILIATION : StepUpStatus.IN_STEP_UP;
        samlAuthenticationRequest.setSteppedUp(stepUpStatus);
        this.authenticationRequestRepository.save((Object)samlAuthenticationRequest);
        return redirect;
    }

    private ResponseEntity doRedirect(@RequestParam(value="code") String code, User user, String oidcRedirectUri, String clientRedirectUri, boolean validateNames, boolean studentAffiliationRequired, boolean appendEPPNQueryParam, String idpStudentAffiliationRequiredUri, String idpValidNamesRequiredUri, String eppnAlreadyLinkedRequiredUri) throws UnsupportedEncodingException {
        Map body = this.requestUserInfo(code, oidcRedirectUri);
        LOG.info((Object)String.format("In redirect link account for user %s with user info %s", user.getEmail(), body));
        return this.saveOrUpdateLinkedAccountToUser(user, clientRedirectUri, validateNames, studentAffiliationRequired, appendEPPNQueryParam, idpStudentAffiliationRequiredUri, idpValidNamesRequiredUri, eppnAlreadyLinkedRequiredUri, body);
    }

    private ResponseEntity<Object> saveOrUpdateLinkedAccountToUser(User user, String clientRedirectUri, boolean validateNames, boolean studentAffiliationRequired, boolean appendEPPNQueryParam, String idpStudentAffiliationRequiredUri, String idpValidNamesRequiredUri, String eppnAlreadyLinkedRequiredUri, Map<String, Object> body) throws UnsupportedEncodingException {
        String eppn = (String)body.get("eduperson_principal_name");
        String subjectId = (String)body.get("subject_id");
        String surfCrmId = (String)body.get("surf-crm-id");
        String schacHomeOrganization = (String)body.get("schac_home_organization");
        String givenName = (String)body.get("given_name");
        String familyName = (String)body.get("family_name");
        String institutionIdentifier = StringUtils.hasText((String)surfCrmId) ? surfCrmId : schacHomeOrganization;
        List affiliations = AccountLinkerController.parseAffiliations(body, (String)schacHomeOrganization);
        if (StringUtils.hasText((String)schacHomeOrganization)) {
            Date expiresAt = Date.from(new Date().toInstant().plus(this.removalValidatedDurationDays, ChronoUnit.DAYS));
            List linkedAccounts = user.getLinkedAccounts();
            Optional<LinkedAccount> optionalLinkedAccount = linkedAccounts.stream().filter(linkedAccount -> linkedAccount.getEduPersonPrincipalName().equalsIgnoreCase(eppn)).findFirst();
            if (optionalLinkedAccount.isPresent()) {
                optionalLinkedAccount.get().updateExpiresIn(institutionIdentifier, eppn, subjectId, givenName, familyName, affiliations, expiresAt);
            } else {
                Optional eppnAlreadyLinkedOptional = this.checkEppnAlreadyLinked(eppnAlreadyLinkedRequiredUri, eppn);
                if (eppnAlreadyLinkedOptional.isPresent()) {
                    return (ResponseEntity)eppnAlreadyLinkedOptional.get();
                }
                linkedAccounts.add(new LinkedAccount(institutionIdentifier, schacHomeOrganization, eppn, subjectId, givenName, familyName, affiliations, linkedAccounts.isEmpty(), new Date(), expiresAt));
            }
            if (linkedAccounts.size() == 1) {
                if (StringUtils.hasText((String)givenName)) {
                    user.setGivenName(givenName);
                }
                if (StringUtils.hasText((String)familyName)) {
                    user.setFamilyName(familyName);
                }
            }
            String eppnValue = StringUtils.hasText((String)eppn) ? String.format("eppn %s", eppn) : "NO eppn";
            MDCContext.logWithContext((User)user, (String)"add", (String)"linked_accounts", (Log)LOG, (String)String.format("Account link with EPPN %s for institution %s with the affiliations %s", eppnValue, institutionIdentifier, affiliations));
            this.userRepository.save((Object)user);
        } else {
            LOG.error((Object)"Account linking requested, but no schacHomeOrganization provided by the IdP");
        }
        boolean hasStudentAffiliation = user.getLinkedAccounts().stream().anyMatch(linkedAccount -> GuestIdpAuthenticationRequestFilter.hasRequiredStudentAffiliation((List)linkedAccount.getEduPersonAffiliations()));
        if (studentAffiliationRequired && !hasStudentAffiliation) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).location(URI.create(idpStudentAffiliationRequiredUri))).build();
        }
        boolean hasValidNames = GuestIdpAuthenticationRequestFilter.hasValidatedName((User)user);
        if (validateNames && !hasValidNames) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).location(URI.create(idpValidNamesRequiredUri))).build();
        }
        if (appendEPPNQueryParam) {
            String appender = ((String)clientRedirectUri).contains("?") ? "&" : "?";
            clientRedirectUri = (String)clientRedirectUri + appender + "institution=" + URLEncoder.encode(eppn, Charset.defaultCharset());
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).location(URI.create((String)clientRedirectUri))).build();
    }

    private Optional<ResponseEntity<Object>> checkEppnAlreadyLinked(String eppnAlreadyLinkedRequiredUri, String eppn) throws UnsupportedEncodingException {
        List optionalUsers;
        if (StringUtils.hasText((String)eppn) && !(optionalUsers = this.userRepository.findByLinkedAccounts_EduPersonPrincipalName(eppn)).isEmpty()) {
            String charSet = Charset.defaultCharset().name();
            eppnAlreadyLinkedRequiredUri = (String)eppnAlreadyLinkedRequiredUri + (((String)eppnAlreadyLinkedRequiredUri).contains("?") ? "&" : "?");
            eppnAlreadyLinkedRequiredUri = (String)eppnAlreadyLinkedRequiredUri + "email=" + URLEncoder.encode(((User)optionalUsers.get(0)).getEmail(), charSet);
            return Optional.of(((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FOUND).location(URI.create((String)eppnAlreadyLinkedRequiredUri))).build());
        }
        return Optional.empty();
    }

    private Map<String, Object> requestUserInfo(String code, String oidcRedirectUri) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"client_id", (Object)this.clientId);
        map.add((Object)"client_secret", (Object)this.clientSecret);
        map.add((Object)"code", (Object)code);
        map.add((Object)"grant_type", (Object)"authorization_code");
        map.add((Object)"redirect_uri", (Object)oidcRedirectUri);
        map.add((Object)"scope", (Object)"openid");
        HttpEntity request = new HttpEntity((Object)map, (MultiValueMap)headers);
        4 parameterizedTypeReference = new /* Unavailable Anonymous Inner Class!! */;
        Map body = (Map)this.restTemplate.exchange(this.oidcBaseUrl + "/oidc/token", HttpMethod.POST, request, (ParameterizedTypeReference)parameterizedTypeReference, new Object[0]).getBody();
        LinkedMultiValueMap accessTokenMap = new LinkedMultiValueMap(Map.of("access_token", List.of((String)body.get("access_token"))));
        request = new HttpEntity((Object)accessTokenMap, (MultiValueMap)headers);
        return (Map)this.restTemplate.exchange(this.oidcBaseUrl + "/oidc/userinfo", HttpMethod.POST, request, (ParameterizedTypeReference)parameterizedTypeReference, new Object[0]).getBody();
    }

    protected static List<String> parseAffiliations(Map<String, Object> idpAttributes, String schacHomeOrganization) {
        if (!StringUtils.hasText((String)schacHomeOrganization)) {
            return new ArrayList<String>();
        }
        List eduPersonAffiliations = ((List)idpAttributes.getOrDefault("eduperson_affiliation", new ArrayList())).stream().map(affiliation -> String.format("%s@%s", affiliation, schacHomeOrganization)).collect(Collectors.toList());
        List eduPersonScopedAffiliations = idpAttributes.getOrDefault("eduperson_scoped_affiliation", eduPersonAffiliations);
        HashSet uniqueAffiliations = new HashSet(eduPersonAffiliations);
        uniqueAffiliations.addAll(eduPersonScopedAffiliations);
        return CollectionUtils.isEmpty(uniqueAffiliations) ? Arrays.asList(String.format("affiliate@%s", schacHomeOrganization)) : new ArrayList<String>(uniqueAffiliations);
    }

    public UserRepository getUserRepository() {
        return this.userRepository;
    }
}

