/*
 * Decompiled with CFR 0.152.
 */
package myconext.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.PublicKeyCredentialDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import myconext.exceptions.WeakPasswordException;
import myconext.manage.Manage;
import myconext.model.CreateInstitutionEduID;
import myconext.model.EduID;
import myconext.model.ExternalLinkedAccount;
import myconext.model.IdentityProvider;
import myconext.model.LinkedAccount;
import myconext.model.LoginOptions;
import myconext.model.PublicKeyCredentials;
import myconext.model.RemoteProvider;
import myconext.model.ServiceProvider;
import myconext.remotecreation.NewExternalEduID;
import myconext.validation.PasswordStrength;
import myconext.verify.AttributeMapper;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Document(collection="users")
public class User
implements Serializable,
UserDetails {
    @Id
    private String id;
    private String email;
    private String chosenName;
    private String givenName;
    private String familyName;
    private Date dateOfBirth;
    @Indexed
    private String uid;
    private String schacHomeOrganization;
    private String password;
    private boolean newUser;
    private String preferredLanguage;
    private String webAuthnIdentifier;
    private String userHandle;
    private boolean forgottenPassword;
    @Indexed
    private String enrollmentVerificationKey;
    @Indexed
    private String createFromInstitutionKey;
    private Map<String, List<String>> attributes = new HashMap();
    private Map<String, Object> surfSecureId = new HashMap();
    private List<PublicKeyCredentials> publicKeyCredentials = new ArrayList();
    private List<LinkedAccount> linkedAccounts = new ArrayList();
    private List<ExternalLinkedAccount> externalLinkedAccounts = new ArrayList();
    private List<EduID> eduIDS = new ArrayList();
    private long created;
    private long updatedAt = System.currentTimeMillis() / 1000L;
    @Indexed
    private String trackingUuid;
    private long lastSeenAppNudge;
    @Transient
    @JsonIgnore
    private boolean mobileAuthentication;

    public User(CreateInstitutionEduID createInstitutionEduID, Map<String, Object> userInfo) {
        this.email = createInstitutionEduID.getEmail();
        this.chosenName = (String)userInfo.get("given_name");
        this.givenName = (String)userInfo.get("given_name");
        this.familyName = (String)userInfo.get("family_name");
    }

    public User(String uid, String email, String chosenName, String givenName, String familyName, String schacHomeOrganization, String preferredLanguage, String serviceProviderEntityId, Manage manage) {
        this.uid = uid;
        this.email = email;
        this.chosenName = chosenName;
        this.givenName = givenName;
        this.familyName = familyName;
        this.schacHomeOrganization = schacHomeOrganization;
        this.preferredLanguage = preferredLanguage;
        this.computeEduIdForServiceProviderIfAbsent(serviceProviderEntityId, manage);
        this.newUser = true;
        this.updatedAt = this.created = System.currentTimeMillis() / 1000L;
    }

    public User(String uid, String email, String chosenName, String givenName, String familyName, String schacHomeOrganization, String preferredLanguage, IdentityProvider identityProvider, Manage manage) {
        this.uid = uid;
        this.email = email;
        this.chosenName = chosenName;
        this.givenName = givenName;
        this.familyName = familyName;
        this.schacHomeOrganization = schacHomeOrganization;
        this.preferredLanguage = preferredLanguage;
        this.computeEduIdForIdentityProviderProviderIfAbsent(identityProvider, manage);
        this.newUser = true;
        this.updatedAt = this.created = System.currentTimeMillis() / 1000L;
    }

    public void validate() {
        Assert.notNull((Object)this.email, (String)"Email is required");
        Assert.notNull((Object)this.givenName, (String)"GivenName is required");
        Assert.notNull((Object)this.familyName, (String)"FamilyName is required");
    }

    public void encryptPassword(String password, PasswordEncoder encoder) {
        if (!PasswordStrength.strongEnough((String)password)) {
            throw new WeakPasswordException();
        }
        this.password = encoder.encode((CharSequence)password);
    }

    public void deletePassword() {
        this.password = null;
    }

    @Transient
    public void addPublicKeyCredential(PublicKeyCredentialDescriptor publicKeyCredentialDescriptor, ByteArray publicKeyCredential, String name) {
        this.publicKeyCredentials.add(new PublicKeyCredentials(publicKeyCredentialDescriptor, publicKeyCredential, name));
    }

    @Transient
    public String computeEduIdForServiceProviderIfAbsent(String entityId, Manage manage) {
        ServiceProvider serviceProvider = manage.findServiceProviderByEntityId(entityId).orElse(new ServiceProvider(new RemoteProvider(entityId, entityId, entityId, null, null), null));
        return this.doComputeEduIDIfAbsent(serviceProvider, manage);
    }

    @Transient
    public String computeEduIdForIdentityProviderProviderIfAbsent(IdentityProvider identityProvider, Manage manage) {
        ServiceProvider serviceProvider = new ServiceProvider(new RemoteProvider(null, identityProvider.getName(), identityProvider.getNameNl(), identityProvider.getInstitutionGuid(), identityProvider.getLogoUrl()), null);
        return this.doComputeEduIDIfAbsent(serviceProvider, manage);
    }

    private String doComputeEduIDIfAbsent(ServiceProvider serviceProvider, Manage manage) {
        String institutionGuid = serviceProvider.getInstitutionGuid();
        String entityId = serviceProvider.getEntityId();
        Optional<EduID> optionalExistingEduID = this.eduIDS.stream().filter(eduID -> {
            boolean matchByInstitutionGUID = StringUtils.hasText((String)institutionGuid) && (institutionGuid.equals(eduID.getServiceInstutionGuid()) || eduID.getServices().stream().anyMatch(sp -> institutionGuid.equals(sp.getInstitutionGuid())));
            boolean matchByEntityId = StringUtils.hasText((String)entityId) && (entityId.equals(eduID.getServiceProviderEntityId()) || eduID.getServices().stream().anyMatch(sp -> entityId.equals(sp.getEntityId())));
            return matchByInstitutionGUID || matchByEntityId;
        }).findFirst();
        String eduIDValue = optionalExistingEduID.map(eduId -> eduId.updateServiceProvider(serviceProvider).getValue()).orElseGet(() -> {
            EduID eduID = new EduID(UUID.randomUUID().toString(), serviceProvider);
            this.eduIDS.add(eduID);
            return eduID.getValue();
        });
        List<EduID> otherEduIDs = this.eduIDS.stream().filter(eduID -> !eduID.getValue().equals(eduIDValue)).filter(eduID -> eduID.getServices().isEmpty() && eduID.getServiceProviderEntityId() != null).collect(Collectors.toList());
        otherEduIDs.forEach(eduID -> {
            String otherEntityId = eduID.getServiceProviderEntityId();
            ServiceProvider serviceProviderFromManage = manage.findServiceProviderByEntityId(otherEntityId).orElse(new ServiceProvider(new RemoteProvider(otherEntityId, otherEntityId, otherEntityId, null, null), null));
            eduID.updateServiceProvider(serviceProviderFromManage);
        });
        return eduIDValue;
    }

    @JsonIgnore
    public Collection<? extends GrantedAuthority> getAuthorities() {
        return Collections.singletonList(new SimpleGrantedAuthority("ROLE_GUEST"));
    }

    public String getPassword() {
        return this.password;
    }

    @JsonIgnore
    public String getUsername() {
        return this.email;
    }

    @Transient
    @JsonIgnore
    public boolean isAccountNonExpired() {
        return true;
    }

    @Transient
    @JsonIgnore
    public boolean isAccountNonLocked() {
        return true;
    }

    @Transient
    @JsonIgnore
    public boolean isCredentialsNonExpired() {
        return true;
    }

    @Transient
    @JsonIgnore
    public boolean isEnabled() {
        return true;
    }

    @Transient
    @JsonIgnore
    public List<LinkedAccount> linkedAccountsSorted() {
        return this.linkedAccounts.stream().sorted(Comparator.comparing(LinkedAccount::getExpiresAt).reversed()).collect(Collectors.toList());
    }

    @Transient
    @JsonIgnore
    public List<String> allEduPersonAffiliations() {
        return this.linkedAccounts.stream().map(LinkedAccount::getEduPersonAffiliations).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Transient
    @JsonIgnore
    public List<String> loginOptions() {
        ArrayList<LoginOptions> result = new ArrayList<LoginOptions>();
        if (!CollectionUtils.isEmpty((Map)this.surfSecureId) && (this.surfSecureId.containsKey("phone-verified") || this.surfSecureId.containsKey("recovery-code"))) {
            result.add(LoginOptions.APP);
        }
        if (!CollectionUtils.isEmpty((Collection)this.publicKeyCredentials)) {
            result.add(LoginOptions.FIDO);
        }
        if (StringUtils.hasText((String)this.password)) {
            result.add(LoginOptions.PASSWORD);
        }
        result.add(LoginOptions.MAGIC);
        return result.stream().map(LoginOptions::getValue).collect(Collectors.toList());
    }

    @Transient
    @JsonIgnore
    public Map<String, EduID> convertEduIdPerServiceProvider() {
        HashMap<String, EduID> result = new HashMap<String, EduID>();
        this.getEduIDS().forEach(eduID -> {
            if (CollectionUtils.isEmpty((Collection)eduID.getServices()) && StringUtils.hasText((String)eduID.getServiceProviderEntityId())) {
                result.put(eduID.getServiceProviderEntityId(), (EduID)eduID);
            } else {
                eduID.getServices().forEach(service -> {
                    String entityId = service.getEntityId();
                    String key = StringUtils.hasText((String)entityId) ? entityId : service.getInstitutionGuid();
                    result.put(key, eduID.copy(key));
                });
            }
        });
        if (this.isMobileAuthentication()) {
            result.forEach((entityId, eduID) -> {
                if (!CollectionUtils.isEmpty((Collection)eduID.getServices())) {
                    ServiceProvider serviceProvider = eduID.getServices().stream().filter(sp -> entityId.equals(sp.getEntityId())).findFirst().orElse((ServiceProvider)eduID.getServices().get(0));
                    eduID.backwardCompatibleTransformation(serviceProvider);
                }
            });
        }
        return result;
    }

    @Transient
    @JsonIgnore
    public void updateWithExternalEduID(NewExternalEduID externalEduID) {
        if (CollectionUtils.isEmpty((Collection)this.externalLinkedAccounts) && CollectionUtils.isEmpty((Collection)this.linkedAccounts)) {
            this.givenName = externalEduID.getFirstName();
            String lastNamePrefix = externalEduID.getLastNamePrefix();
            this.familyName = StringUtils.hasText((String)lastNamePrefix) ? String.format("%s %s", lastNamePrefix, externalEduID.getLastName()) : externalEduID.getLastName();
            this.dateOfBirth = AttributeMapper.parseDate((String)externalEduID.getDateOfBirth());
        }
    }

    public String getEduPersonPrincipalName() {
        return this.uid + "@" + this.schacHomeOrganization;
    }

    @Generated
    public User() {
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getChosenName() {
        return this.chosenName;
    }

    @Generated
    public String getGivenName() {
        return this.givenName;
    }

    @Generated
    public String getFamilyName() {
        return this.familyName;
    }

    @Generated
    public Date getDateOfBirth() {
        return this.dateOfBirth;
    }

    @Generated
    public String getUid() {
        return this.uid;
    }

    @Generated
    public String getSchacHomeOrganization() {
        return this.schacHomeOrganization;
    }

    @Generated
    public boolean isNewUser() {
        return this.newUser;
    }

    @Generated
    public String getPreferredLanguage() {
        return this.preferredLanguage;
    }

    @Generated
    public String getWebAuthnIdentifier() {
        return this.webAuthnIdentifier;
    }

    @Generated
    public String getUserHandle() {
        return this.userHandle;
    }

    @Generated
    public boolean isForgottenPassword() {
        return this.forgottenPassword;
    }

    @Generated
    public String getEnrollmentVerificationKey() {
        return this.enrollmentVerificationKey;
    }

    @Generated
    public String getCreateFromInstitutionKey() {
        return this.createFromInstitutionKey;
    }

    @Generated
    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    @Generated
    public Map<String, Object> getSurfSecureId() {
        return this.surfSecureId;
    }

    @Generated
    public List<PublicKeyCredentials> getPublicKeyCredentials() {
        return this.publicKeyCredentials;
    }

    @Generated
    public List<LinkedAccount> getLinkedAccounts() {
        return this.linkedAccounts;
    }

    @Generated
    public List<ExternalLinkedAccount> getExternalLinkedAccounts() {
        return this.externalLinkedAccounts;
    }

    @Generated
    public List<EduID> getEduIDS() {
        return this.eduIDS;
    }

    @Generated
    public long getCreated() {
        return this.created;
    }

    @Generated
    public long getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public String getTrackingUuid() {
        return this.trackingUuid;
    }

    @Generated
    public long getLastSeenAppNudge() {
        return this.lastSeenAppNudge;
    }

    @Generated
    public boolean isMobileAuthentication() {
        return this.mobileAuthentication;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setChosenName(String chosenName) {
        this.chosenName = chosenName;
    }

    @Generated
    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    @Generated
    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    @Generated
    public void setDateOfBirth(Date dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    @Generated
    public void setNewUser(boolean newUser) {
        this.newUser = newUser;
    }

    @Generated
    public void setPreferredLanguage(String preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
    }

    @Generated
    public void setWebAuthnIdentifier(String webAuthnIdentifier) {
        this.webAuthnIdentifier = webAuthnIdentifier;
    }

    @Generated
    public void setUserHandle(String userHandle) {
        this.userHandle = userHandle;
    }

    @Generated
    public void setForgottenPassword(boolean forgottenPassword) {
        this.forgottenPassword = forgottenPassword;
    }

    @Generated
    public void setEnrollmentVerificationKey(String enrollmentVerificationKey) {
        this.enrollmentVerificationKey = enrollmentVerificationKey;
    }

    @Generated
    public void setCreateFromInstitutionKey(String createFromInstitutionKey) {
        this.createFromInstitutionKey = createFromInstitutionKey;
    }

    @Generated
    public void setPublicKeyCredentials(List<PublicKeyCredentials> publicKeyCredentials) {
        this.publicKeyCredentials = publicKeyCredentials;
    }

    @Generated
    public void setLinkedAccounts(List<LinkedAccount> linkedAccounts) {
        this.linkedAccounts = linkedAccounts;
    }

    @Generated
    public void setEduIDS(List<EduID> eduIDS) {
        this.eduIDS = eduIDS;
    }

    @Generated
    public void setTrackingUuid(String trackingUuid) {
        this.trackingUuid = trackingUuid;
    }

    @Generated
    public void setLastSeenAppNudge(long lastSeenAppNudge) {
        this.lastSeenAppNudge = lastSeenAppNudge;
    }

    @JsonIgnore
    @Generated
    public void setMobileAuthentication(boolean mobileAuthentication) {
        this.mobileAuthentication = mobileAuthentication;
    }
}

