/*
 * Decompiled with CFR 0.152.
 */
package myconext.model;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import lombok.Generated;
import myconext.model.ExternalLinkedAccount;
import myconext.model.IdpScoping;
import myconext.model.Verification;
import myconext.model.VerifyIssuer;
import org.springframework.util.StringUtils;

public class ExternalLinkedAccount
implements Serializable {
    private String subjectId;
    private IdpScoping idpScoping;
    private VerifyIssuer issuer;
    private Verification verification;
    private String serviceUUID;
    private String serviceID;
    private String subjectIssuer;
    private String brinCode;
    private String initials;
    private String chosenName;
    private String firstName;
    private String preferredLastName;
    private String legalLastName;
    private String partnerLastNamePrefix;
    private String legalLastNamePrefix;
    private String preferredLastNamePrefix;
    private String partnerLastName;
    @Schema(type="integer", format="int64", example="1634813554997")
    private Date dateOfBirth;
    @Schema(type="integer", format="int64", example="1634813554997")
    private Date createdAt;
    @Schema(type="integer", format="int64", example="1634813554997")
    private Date expiresAt;
    private boolean external = true;

    public ExternalLinkedAccount(String subjectId, IdpScoping idpScoping, boolean external) {
        this.subjectId = subjectId;
        this.idpScoping = idpScoping;
        this.external = external;
        this.expiresAt = Date.from(Instant.now().plus(1825L, ChronoUnit.DAYS));
    }

    public ExternalLinkedAccount(String subjectId, IdpScoping idpScoping, VerifyIssuer issuer, Verification verification, String serviceUUID, String serviceID, String subjectIssuer, String brinCode, String initials, String chosenName, String firstName, String preferredLastName, String legalLastName, String partnerLastNamePrefix, String legalLastNamePrefix, String preferredLastNamePrefix, String partnerLastName, Date dateOfBirth, Date createdAt, Date expiresAt, boolean external) {
        this.subjectId = subjectId;
        this.idpScoping = idpScoping;
        this.issuer = issuer;
        this.verification = verification;
        this.serviceUUID = serviceUUID;
        this.serviceID = serviceID;
        this.subjectIssuer = subjectIssuer;
        this.brinCode = brinCode;
        this.initials = initials;
        this.chosenName = chosenName;
        this.firstName = firstName;
        this.preferredLastName = preferredLastName;
        this.legalLastName = legalLastName;
        this.partnerLastNamePrefix = partnerLastNamePrefix;
        this.legalLastNamePrefix = legalLastNamePrefix;
        this.preferredLastNamePrefix = preferredLastNamePrefix;
        this.partnerLastName = partnerLastName;
        this.dateOfBirth = dateOfBirth;
        this.createdAt = createdAt;
        this.expiresAt = expiresAt;
        this.external = external;
        this.nameInvariant();
    }

    private void nameInvariant() {
        if (StringUtils.hasText((String)this.preferredLastName) && StringUtils.hasText((String)this.preferredLastNamePrefix)) {
            this.preferredLastName = String.format("%s %s", this.preferredLastNamePrefix, this.preferredLastName);
        }
        if (StringUtils.hasText((String)this.legalLastName) && StringUtils.hasText((String)this.legalLastNamePrefix)) {
            this.legalLastName = String.format("%s %s", this.legalLastNamePrefix, this.legalLastName);
        }
    }

    public boolean areNamesValidated() {
        switch (1.$SwitchMap$myconext$model$IdpScoping[this.idpScoping.ordinal()]) {
            case 1: {
                return StringUtils.hasText((String)this.initials) && StringUtils.hasText((String)this.legalLastName);
            }
            case 2: {
                return StringUtils.hasText((String)this.firstName) && StringUtils.hasText((String)this.preferredLastName);
            }
            case 3: {
                return StringUtils.hasText((String)this.firstName) && StringUtils.hasText((String)this.legalLastName) && !Verification.Ongeverifieerd.equals((Object)this.verification);
            }
        }
        throw new IllegalArgumentException("Won't happen");
    }

    @Generated
    public ExternalLinkedAccount() {
    }

    @Generated
    public String getSubjectId() {
        return this.subjectId;
    }

    @Generated
    public IdpScoping getIdpScoping() {
        return this.idpScoping;
    }

    @Generated
    public VerifyIssuer getIssuer() {
        return this.issuer;
    }

    @Generated
    public Verification getVerification() {
        return this.verification;
    }

    @Generated
    public String getServiceUUID() {
        return this.serviceUUID;
    }

    @Generated
    public String getServiceID() {
        return this.serviceID;
    }

    @Generated
    public String getSubjectIssuer() {
        return this.subjectIssuer;
    }

    @Generated
    public String getBrinCode() {
        return this.brinCode;
    }

    @Generated
    public String getInitials() {
        return this.initials;
    }

    @Generated
    public String getChosenName() {
        return this.chosenName;
    }

    @Generated
    public String getFirstName() {
        return this.firstName;
    }

    @Generated
    public String getPreferredLastName() {
        return this.preferredLastName;
    }

    @Generated
    public String getLegalLastName() {
        return this.legalLastName;
    }

    @Generated
    public String getPartnerLastNamePrefix() {
        return this.partnerLastNamePrefix;
    }

    @Generated
    public String getLegalLastNamePrefix() {
        return this.legalLastNamePrefix;
    }

    @Generated
    public String getPreferredLastNamePrefix() {
        return this.preferredLastNamePrefix;
    }

    @Generated
    public String getPartnerLastName() {
        return this.partnerLastName;
    }

    @Generated
    public Date getDateOfBirth() {
        return this.dateOfBirth;
    }

    @Generated
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Date getExpiresAt() {
        return this.expiresAt;
    }

    @Generated
    public boolean isExternal() {
        return this.external;
    }

    @Generated
    public String toString() {
        return "ExternalLinkedAccount(subjectId=" + this.getSubjectId() + ", idpScoping=" + this.getIdpScoping() + ", issuer=" + this.getIssuer() + ", verification=" + this.getVerification() + ", serviceUUID=" + this.getServiceUUID() + ", serviceID=" + this.getServiceID() + ", subjectIssuer=" + this.getSubjectIssuer() + ", brinCode=" + this.getBrinCode() + ", initials=" + this.getInitials() + ", chosenName=" + this.getChosenName() + ", firstName=" + this.getFirstName() + ", preferredLastName=" + this.getPreferredLastName() + ", legalLastName=" + this.getLegalLastName() + ", partnerLastNamePrefix=" + this.getPartnerLastNamePrefix() + ", legalLastNamePrefix=" + this.getLegalLastNamePrefix() + ", preferredLastNamePrefix=" + this.getPreferredLastNamePrefix() + ", partnerLastName=" + this.getPartnerLastName() + ", dateOfBirth=" + this.getDateOfBirth() + ", createdAt=" + this.getCreatedAt() + ", expiresAt=" + this.getExpiresAt() + ", external=" + this.isExternal() + ")";
    }

    @Generated
    public void setVerification(Verification verification) {
        this.verification = verification;
    }

    @Generated
    public void setBrinCode(String brinCode) {
        this.brinCode = brinCode;
    }

    @Generated
    public void setDateOfBirth(Date dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }
}

