/*
 * Decompiled with CFR 0.152.
 */
package myconext.verify;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import myconext.model.ExternalLinkedAccount;
import myconext.model.IdpScoping;
import myconext.model.Verification;
import myconext.model.VerifyIssuer;
import myconext.remotecreation.NewExternalEduID;
import myconext.verify.AttributeMapper;
import myconext.verify.VerifyState;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AttributeMapper {
    private static final int DEFAULT_EXPIRATION_YEARS = 6;
    private static final Map<Pattern, DateTimeFormatter> datePatterns = Map.of(Pattern.compile("^\\d{8}$"), DateTimeFormatter.ofPattern("yyyyMMdd"), Pattern.compile("^\\d{4}-\\d{2}-\\d{2}$"), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    private final ObjectMapper objectMapper;

    @Autowired
    public AttributeMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public ExternalLinkedAccount externalLinkedAccountFromAttributes(Map<String, Object> attributes, VerifyState verifyState) {
        switch (1.$SwitchMap$myconext$model$IdpScoping[verifyState.getIdpScoping().ordinal()]) {
            case 1: {
                return new ExternalLinkedAccount(this.getAttribute(attributes, "sub"), verifyState.getIdpScoping(), verifyState.getVerifyIssuer(), Verification.Decentraal, this.getAttribute(attributes, "urn:nl:bvn:bankid:1.0:bankid.deliveredserviceid"), this.getAttribute(attributes, "urn:nl:bvn:bankid:1.0:bankid.deliveredserviceid"), this.getAttribute(attributes, "subject_issuer"), null, this.getAttribute(attributes, "urn:nl:bvn:bankid:1.0:consumer.initials"), null, this.getAttribute(attributes, "urn:nl:bvn:bankid:1.0:consumer.initials"), this.getAttribute(attributes, "urn:nl:bvn:bankid:1.0:consumer.preferredlastname"), this.getAttribute(attributes, "urn:nl:bvn:bankid:1.0:consumer.legallastname"), this.getAttribute(attributes, "urn:nl:bvn:bankid:1.0:consumer.partnerlastnameprefix"), this.getAttribute(attributes, "urn:nl:bvn:bankid:1.0:consumer.legallastnameprefix"), this.getAttribute(attributes, "urn:nl:bvn:bankid:1.0:consumer.preferredlastnameprefix"), this.getAttribute(attributes, "urn:nl:bvn:bankid:1.0:consumer.partnerlastname"), AttributeMapper.parseDate((String)this.getAttribute(attributes, "urn:nl:bvn:bankid:1.0:consumer.dateofbirth")), new Date(), Date.from(Instant.now().plus(2190L, ChronoUnit.DAYS)), true);
            }
            case 2: {
                return new ExternalLinkedAccount(this.getAttribute(attributes, "sub"), verifyState.getIdpScoping(), verifyState.getVerifyIssuer(), Verification.Decentraal, this.getAttribute(attributes, "urn:etoegang:core:ServiceUUID"), this.getAttribute(attributes, "urn:etoegang:DV:00000003411824080000:services:9001"), this.getAttribute(attributes, "subject_issuer"), null, this.getAttribute(attributes, "urn:etoegang:1.9:attribute:Initials"), null, this.getAttribute(attributes, "urn:etoegang:1.9:attribute:FirstName"), this.getAttribute(attributes, "urn:etoegang:1.9:attribute:FamilyName"), this.getAttribute(attributes, "urn:etoegang:1.9:attribute:FamilyName"), null, null, null, null, AttributeMapper.parseDate((String)this.getAttribute(attributes, "urn:etoegang:1.9:attribute:DateOfBirth")), new Date(), Date.from(Instant.now().plus(2190L, ChronoUnit.DAYS)), true);
            }
        }
        throw new IllegalArgumentException();
    }

    public ExternalLinkedAccount createExternalLinkedAccount(NewExternalEduID eduID, IdpScoping idpScoping) {
        return new ExternalLinkedAccount(eduID.getIdentifier(), idpScoping, new VerifyIssuer(idpScoping.name(), idpScoping.name(), null), eduID.getVerification(), null, null, IdpScoping.studielink.name(), eduID.getBrinCodes(), null, eduID.getChosenName(), eduID.getFirstName(), eduID.getLastName(), eduID.getLastName(), null, eduID.getLastNamePrefix(), eduID.getLastNamePrefix(), null, AttributeMapper.parseDate((String)eduID.getDateOfBirth()), new Date(), Date.from(Instant.now().plus(2190L, ChronoUnit.DAYS)), true);
    }

    public String serializeToBase64(VerifyState verifyState) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("i", verifyState.getStateIdentifier());
        result.put("s", verifyState.getIdpScoping().name());
        VerifyIssuer verifyIssuer = verifyState.getVerifyIssuer();
        if (Objects.nonNull(verifyIssuer)) {
            result.put("vi", verifyIssuer.getId());
            result.put("vn", verifyIssuer.getName());
        }
        byte[] bytes = this.objectMapper.writeValueAsBytes(result);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GZIPOutputStream gout = new GZIPOutputStream(bos);
        gout.write(bytes);
        gout.finish();
        return new String(Base64.encodeBase64((byte[])bos.toByteArray(), (boolean)false, (boolean)true));
    }

    public VerifyState serializeFromBase64(String base64) {
        byte[] decoded = Base64.decodeBase64((String)base64);
        if (decoded.length / 1024 >= 42) {
            throw new IllegalArgumentException("GZip bomb detected");
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(decoded);
        GZIPInputStream gin = new GZIPInputStream(bis);
        Map map = (Map)this.objectMapper.readValue((InputStream)gin, Map.class);
        VerifyIssuer verifyIssuer = null;
        if (map.containsKey("vi") && map.containsKey("vn")) {
            verifyIssuer = new VerifyIssuer((String)map.get("vi"), (String)map.get("vn"), null);
        }
        return new VerifyState((String)map.get("i"), IdpScoping.valueOf((String)((String)map.get("s"))), verifyIssuer);
    }

    public static Date parseDate(String dateString) {
        if (StringUtils.hasText((String)dateString)) {
            DateTimeFormatter dateTimeFormatter = datePatterns.entrySet().stream().filter(e -> ((Pattern)e.getKey()).matcher(dateString).matches()).map(e -> (DateTimeFormatter)e.getValue()).findFirst().orElse(DateTimeFormatter.ISO_LOCAL_DATE);
            try {
                LocalDate localDate = LocalDate.parse(dateString, dateTimeFormatter);
                return Date.from(localDate.atStartOfDay(ZoneOffset.UTC).toInstant());
            }
            catch (DateTimeException dateTimeException) {
                // empty catch block
            }
        }
        return null;
    }

    private String getAttribute(Map<String, Object> attributes, String key) {
        return (String)attributes.get(key);
    }
}

