/*
 * Decompiled with CFR 0.152.
 */
package myconext.cron;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import myconext.exceptions.DisposableEmailProviderException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.core.io.ClassPathResource;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class DisposableEmailProviders {
    private static final Log LOG = LogFactory.getLog(DisposableEmailProviders.class);
    private final ObjectMapper objectMapper;
    private final boolean testEnvironment;
    private Set<String> disposableEmailProviders = new HashSet();
    private final boolean denyDisposableEmailProviders;
    private final TypeReference<Map<String, Object>> mapTypeReference = new /* Unavailable Anonymous Inner Class!! */;

    @Autowired
    public DisposableEmailProviders(ObjectMapper objectMapper, Environment environment, @Value(value="${feature.deny_disposable_email_providers}") boolean denyDisposableEmailProviders) {
        this.objectMapper = objectMapper;
        this.testEnvironment = environment.acceptsProfiles(Profiles.of((String[])new String[]{"test"}));
        this.denyDisposableEmailProviders = denyDisposableEmailProviders;
    }

    @Scheduled(initialDelay=1L, fixedRate=24L, timeUnit=TimeUnit.HOURS)
    public void resolveIDisposableEmailProviders() {
        if (!this.denyDisposableEmailProviders) {
            return;
        }
        long start = System.currentTimeMillis();
        try {
            String remoteLocation = "https://raw.githubusercontent.com/7c/fakefilter/main/json/data.json";
            String localLocation = "email/fake_filter.json";
            Map emailProviders = this.testEnvironment ? (Map)this.objectMapper.readValue(new ClassPathResource(localLocation).getInputStream(), this.mapTypeReference) : (Map)this.objectMapper.readValue(new URL(remoteLocation), this.mapTypeReference);
            Map domains = (Map)emailProviders.get("domains");
            this.disposableEmailProviders = this.parseDisposableEmailProviders(domains);
            LOG.info((Object)String.format("Resolved %s disposable email providers %s in %s ms", this.disposableEmailProviders.size(), this.testEnvironment ? localLocation : remoteLocation, System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            LOG.error((Object)"Error in resolveIDisposableEmailProviders", (Throwable)e);
        }
    }

    private HashSet<String> parseDisposableEmailProviders(Map<String, Object> domains) {
        Set<Map.Entry<String, Object>> entries = domains.entrySet();
        HashSet<String> newDisposableEmailProviders = new HashSet<String>();
        entries.forEach(entry -> {
            String domain = (String)entry.getKey();
            Map provider = (Map)entry.getValue();
            newDisposableEmailProviders.add(domain.toLowerCase());
            newDisposableEmailProviders.add(((String)provider.get("provider")).toLowerCase());
        });
        return newDisposableEmailProviders;
    }

    public void verifyDisposableEmailProviders(String email) {
        int beginIndex;
        String domainLowerCase;
        boolean disposableEmail;
        if (!this.denyDisposableEmailProviders) {
            return;
        }
        if (this.disposableEmailProviders.isEmpty()) {
            this.resolveIDisposableEmailProviders();
        }
        if (disposableEmail = this.disposableEmailProviders.contains(domainLowerCase = email.substring(beginIndex = email.indexOf("@") + 1).toLowerCase())) {
            throw new DisposableEmailProviderException("Disposable email: " + email);
        }
    }
}

