/*
 * Decompiled with CFR 0.152.
 */
package myconext.invite;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import lombok.Generated;
import myconext.api.HasUserRepository;
import myconext.exceptions.IdentityProviderNotFoundException;
import myconext.exceptions.UserNotFoundException;
import myconext.invite.EduIDProvision;
import myconext.manage.Manage;
import myconext.model.IdentityProvider;
import myconext.model.User;
import myconext.repository.UserRepository;
import myconext.security.RemoteUser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/myconext/api/invite"}, produces={"application/json"})
@SecurityRequirement(name="basic")
public class InviteController
implements HasUserRepository {
    private static final Log LOG = LogFactory.getLog(InviteController.class);
    private final UserRepository userRepository;
    private final Manage manage;

    public InviteController(UserRepository userRepository, Manage manage) {
        this.userRepository = userRepository;
        this.manage = manage;
    }

    @PostMapping(value={"/provision-eduid"})
    @PreAuthorize(value="hasRole('ROLE_invite')")
    public ResponseEntity<EduIDProvision> provisionEduid(@Parameter(hidden=true) @AuthenticationPrincipal(errorOnInvalidType=true) RemoteUser remoteUser, @RequestBody @Validated EduIDProvision eduIDProvision) {
        LOG.info((Object)String.format("POST api/invite/provision-eduid by %s for %s", remoteUser.getUsername(), eduIDProvision));
        User user = (User)this.userRepository.findByEduIDS_value(eduIDProvision.getEduIDValue()).orElseThrow(() -> new UserNotFoundException("User not found with eduID: " + eduIDProvision.getEduIDValue()));
        IdentityProvider identityProvider = (IdentityProvider)this.manage.findIdentityProviderByInstitutionGUID(eduIDProvision.getInstitutionGUID()).orElseThrow(() -> new IdentityProviderNotFoundException("IdentityProvider not found with institutionGUID: " + eduIDProvision.getInstitutionGUID()));
        String newEduIDValue = user.computeEduIdForIdentityProviderProviderIfAbsent(identityProvider, this.manage);
        this.userRepository.save((Object)user);
        eduIDProvision.setEduIDValue(newEduIDValue);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)eduIDProvision);
    }

    @Generated
    public UserRepository getUserRepository() {
        return this.userRepository;
    }
}

