/*
 * Decompiled with CFR 0.152.
 */
package myconext.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import myconext.model.ServiceProvider;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.util.StringUtils;

public class EduID
implements Serializable {
    @Indexed
    private String value;
    private String serviceProviderEntityId;
    private String serviceName;
    private String serviceNameNl;
    private String serviceLogoUrl;
    private String serviceHomeUrl;
    private String serviceInstutionGuid;
    private List<ServiceProvider> services = new ArrayList();
    @Schema(type="integer", format="int64", example="1634813554997")
    private Date createdAt;

    public EduID(String value, ServiceProvider serviceProvider) {
        this.value = value;
        this.services.add(serviceProvider);
        this.createdAt = new Date();
    }

    public EduID updateServiceProvider(ServiceProvider serviceProvider) {
        Optional<ServiceProvider> optionalServiceProvider = this.services.stream().filter(sp -> StringUtils.hasText((String)sp.getEntityId()) && sp.getEntityId().equals(serviceProvider.getEntityId()) || !StringUtils.hasText((String)sp.getEntityId()) && !StringUtils.hasText((String)serviceProvider.getEntityId()) && StringUtils.hasText((String)sp.getInstitutionGuid()) && sp.getInstitutionGuid().equals(serviceProvider.getInstitutionGuid())).findFirst();
        optionalServiceProvider.ifPresentOrElse(sp -> {
            sp.setName(serviceProvider.getName());
            sp.setNameNl(serviceProvider.getNameNl());
            sp.setHomeUrl(serviceProvider.getHomeUrl());
            sp.setLogoUrl(serviceProvider.getLogoUrl());
            sp.setInstitutionGuid(serviceProvider.getInstitutionGuid());
        }, () -> this.services.add(serviceProvider));
        return this;
    }

    public void replaceAtWithDot() {
        if (this.serviceProviderEntityId.contains("@")) {
            this.serviceProviderEntityId = this.serviceProviderEntityId.replaceAll("@", ".");
        }
    }

    public void backwardCompatibleTransformation(ServiceProvider serviceProvider) {
        this.serviceProviderEntityId = serviceProvider.getEntityId();
        this.serviceName = serviceProvider.getName();
        this.serviceNameNl = serviceProvider.getNameNl();
        this.serviceLogoUrl = serviceProvider.getLogoUrl();
        this.serviceHomeUrl = serviceProvider.getHomeUrl();
        this.serviceInstutionGuid = serviceProvider.getInstitutionGuid();
    }

    public String toString() {
        return "EduID{serviceProviderEntityId='" + this.serviceProviderEntityId + "', value='" + this.value + "', createdAt=" + this.createdAt + "}";
    }

    @Transient
    @JsonIgnore
    public EduID copy(String key) {
        EduID eduID = new EduID();
        eduID.value = this.value;
        eduID.serviceProviderEntityId = this.serviceProviderEntityId;
        eduID.serviceName = this.serviceName;
        eduID.serviceNameNl = this.serviceNameNl;
        eduID.serviceLogoUrl = this.serviceLogoUrl;
        eduID.serviceHomeUrl = this.serviceHomeUrl;
        eduID.serviceInstutionGuid = this.serviceInstutionGuid;
        eduID.createdAt = this.createdAt;
        eduID.services = this.services.stream().filter(service -> StringUtils.hasText((String)service.getEntityId()) && key.equals(service.getEntityId()) || key.equals(service.getInstitutionGuid())).collect(Collectors.toList());
        return eduID;
    }

    @Generated
    public EduID() {
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public String getServiceProviderEntityId() {
        return this.serviceProviderEntityId;
    }

    @Generated
    public String getServiceName() {
        return this.serviceName;
    }

    @Generated
    public String getServiceNameNl() {
        return this.serviceNameNl;
    }

    @Generated
    public String getServiceLogoUrl() {
        return this.serviceLogoUrl;
    }

    @Generated
    public String getServiceHomeUrl() {
        return this.serviceHomeUrl;
    }

    @Generated
    public String getServiceInstutionGuid() {
        return this.serviceInstutionGuid;
    }

    @Generated
    public List<ServiceProvider> getServices() {
        return this.services;
    }

    @Generated
    public Date getCreatedAt() {
        return this.createdAt;
    }
}

