/*
 * Decompiled with CFR 0.152.
 */
package myconext.cron;

import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import myconext.mail.MailBox;
import myconext.model.User;
import myconext.model.UserInactivity;
import myconext.repository.UserRepository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class InactivityMail {
    private static final Log LOG = LogFactory.getLog(InactivityMail.class);
    private final MailBox mailBox;
    private final UserRepository userRepository;
    private final boolean mailInactivityMails;
    private final boolean cronJobResponsible;
    private final DateFormat dateFormatUS;
    private final DateFormat dateFormatNL;

    @Autowired
    public InactivityMail(MailBox mailBox, UserRepository userRepository, @Value(value="${cron.node-cron-job-responsible}") boolean cronJobResponsible, @Value(value="${feature.mail_inactivity_mails}") boolean mailInactivityMails) {
        this.mailBox = mailBox;
        this.userRepository = userRepository;
        this.cronJobResponsible = cronJobResponsible;
        this.mailInactivityMails = mailInactivityMails;
        this.dateFormatUS = DateFormat.getDateInstance(1, Locale.of("us"));
        this.dateFormatNL = DateFormat.getDateInstance(1, Locale.of("nl"));
    }

    @Scheduled(cron="${cron.inactivity-users-expression}")
    public void mailInactiveUsers() {
        if (!this.mailInactivityMails || !this.cronJobResponsible) {
            return;
        }
        try {
            Stream.of(UserInactivity.values()).forEach(arg_0 -> this.doMailInactiveUsers(arg_0));
            this.doDeleteInactiveUsers();
        }
        catch (Exception e) {
            LOG.error((Object)"Error in mailInactiveUsers", (Throwable)e);
        }
    }

    private void doMailInactiveUsers(UserInactivity userInactivity) {
        long nowInMillis = System.currentTimeMillis();
        long oneDayInMillis = 86400000L;
        long fiveYearsInMillis = 1825L * oneDayInMillis;
        long lastLoginBefore = nowInMillis - oneDayInMillis * userInactivity.getInactivityDays();
        List users = this.userRepository.findByLastLoginBeforeAndUserInactivity(lastLoginBefore, userInactivity.getPreviousUserInactivity());
        HashMap<String, String> localeVariables = new HashMap<String, String>();
        Date date = new Date(nowInMillis + (fiveYearsInMillis - oneDayInMillis * userInactivity.getInactivityDays()));
        localeVariables.put("inactivity_period_en", userInactivity.getInactivityPeriodEn());
        localeVariables.put("inactivity_period_nl", userInactivity.getInactivityPeriodNl());
        localeVariables.put("deletion_period_en", userInactivity.getDeletionPeriodEn());
        localeVariables.put("deletion_period_nl", userInactivity.getDeletionPeriodNl());
        localeVariables.put("account_delete_date_en", this.dateFormatUS.format(date));
        localeVariables.put("account_delete_date_nl", this.dateFormatNL.format(date));
        users.forEach(user -> {
            this.mailBox.sendUserInactivityMail(user, localeVariables, userInactivity.equals((Object)UserInactivity.YEAR_1_INTERVAL) || userInactivity.equals((Object)UserInactivity.YEAR_3_INTERVAL));
            user.setUserInactivity(userInactivity);
            this.userRepository.save(user);
        });
        LOG.info((Object)String.format("Mailed %s users who has been inactive for %s period in for %s ms", users.size(), userInactivity, System.currentTimeMillis() - nowInMillis));
    }

    private void doDeleteInactiveUsers() {
        long nowInMillis = System.currentTimeMillis();
        long oneDayInMillis = 86400000L;
        long lastLoginBefore = nowInMillis - oneDayInMillis * 5L * 365L;
        List users = this.userRepository.findByLastLoginBeforeAndUserInactivity(lastLoginBefore, UserInactivity.WEEK_1_BEFORE_5_YEARS);
        this.userRepository.deleteAll((Iterable)users);
        LOG.info((Object)String.format("Deleted %s users (%s) who has been inactive for 5 years in for %s ms", users.size(), users.stream().map(User::getEmail).collect(Collectors.joining(", ")), System.currentTimeMillis() - nowInMillis));
    }
}

