/*
 * Decompiled with CFR 0.152.
 */
package myconext.cron;

import java.util.Date;
import java.util.List;
import myconext.mail.MailBox;
import myconext.repository.UserRepository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class NudgeAppMail {
    private static final Log LOG = LogFactory.getLog(NudgeAppMail.class);
    private final MailBox mailBox;
    private final UserRepository userRepository;
    private final boolean nudgeAppMailFeature;
    private final boolean cronJobResponsible;
    private final long nudgeAppMailDaysAfterCreation;

    @Autowired
    public NudgeAppMail(MailBox mailBox, UserRepository userRepository, @Value(value="${cron.node-cron-job-responsible}") boolean cronJobResponsible, @Value(value="${cron.nudge-app-mail-days-after-creation}") long nudgeAppMailDaysAfterCreation, @Value(value="${feature.nudge_app_mail}") boolean nudgeAppMailFeature) {
        this.mailBox = mailBox;
        this.userRepository = userRepository;
        this.cronJobResponsible = cronJobResponsible;
        this.nudgeAppMailDaysAfterCreation = nudgeAppMailDaysAfterCreation;
        this.nudgeAppMailFeature = nudgeAppMailFeature;
    }

    @Scheduled(cron="${cron.nudge-app-mail-expression}")
    public void mailUsersWithoutApp() {
        if (!this.nudgeAppMailFeature || !this.cronJobResponsible) {
            return;
        }
        long start = System.currentTimeMillis();
        try {
            long createdBefore = (new Date().getTime() - this.nudgeAppMailDaysAfterCreation * 24L * 60L * 60L * 1000L) / 1000L;
            List users = this.userRepository.findByNoEduIDApp(Long.valueOf(createdBefore));
            users.forEach(user -> {
                this.mailBox.sendNudgeAppMail(user);
                user.setNudgeAppMailSend(true);
                this.userRepository.save(user);
            });
            LOG.info((Object)String.format("Mailed %s users to nudge the app in %s ms", users.size(), System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            LOG.error((Object)"Error in mailUsersWithInstitutionMail", (Throwable)e);
        }
    }
}

