/*
 * Decompiled with CFR 0.152.
 */
package myconext.manage;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import myconext.manage.Manage;
import myconext.model.IdentityProvider;
import myconext.model.ServiceProvider;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.ClassPathResource;

public class MockManage
implements Manage {
    private final Map<String, ServiceProvider> serviceProviders;
    private final Map<String, IdentityProvider> identityProviders;

    public MockManage(ObjectMapper objectMapper) {
        ArrayList manageServices = new ArrayList();
        Stream.of("saml20_sp", "oidc10_rp").forEach(type -> manageServices.addAll(this.convertMaps(objectMapper, "/manage/" + type + ".json")));
        this.serviceProviders = manageServices.stream().collect(Collectors.toMap(arg_0 -> ((MockManage)this).entityId(arg_0), arg_0 -> ((MockManage)this).serviceProvider(arg_0)));
        List manageIdentityProviders = this.convertMaps(objectMapper, "/manage/saml20_idp.json");
        this.identityProviders = this.mergeByDomainNames(manageIdentityProviders);
    }

    private List<Map<String, Object>> convertMaps(ObjectMapper objectMapper, String type) {
        return (List)objectMapper.readValue(IOUtils.toString((InputStream)new ClassPathResource(type).getInputStream(), (Charset)Charset.defaultCharset()), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Optional<ServiceProvider> findServiceProviderByEntityId(String entityId) {
        return Optional.ofNullable((ServiceProvider)this.serviceProviders.get(entityId));
    }

    public Set<String> getDomainNames() {
        return this.identityProviders.keySet();
    }

    public Optional<IdentityProvider> findIdentityProviderByDomainName(String domainName) {
        return Optional.ofNullable((IdentityProvider)this.identityProviders.get(domainName));
    }

    public Optional<IdentityProvider> findIdentityProviderByBrinCode(String brinCode) {
        return this.identityProviders.values().stream().filter(identityProvider -> brinCode.equals(identityProvider.getInstitutionBrin())).findFirst();
    }

    public Optional<IdentityProvider> findIdentityProviderByInstitutionGUID(String institutionGUID) {
        return this.identityProviders.values().stream().filter(identityProvider -> institutionGUID.equals(identityProvider.getInstitutionGuid())).findFirst();
    }
}

