/*
 * Decompiled with CFR 0.152.
 */
package myconext.mongo;

import com.github.cloudyrock.mongock.driver.mongodb.springdata.v3.SpringDataMongo3Driver;
import com.github.cloudyrock.spring.v5.MongockSpring5;
import io.changock.driver.api.driver.ConnectionDriver;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import myconext.model.EmailsSend;
import myconext.model.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.MongoTransactionManager;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.index.IndexInfo;
import org.springframework.data.mongodb.core.index.IndexOperations;
import org.springframework.data.mongodb.core.index.MongoPersistentEntityIndexResolver;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.query.Collation;
import tiqr.org.model.Authentication;
import tiqr.org.model.Enrollment;
import tiqr.org.model.Registration;

@Configuration
public class MongoMapping {
    private final MongoTemplate mongoTemplate;
    private final MongoConverter mongoConverter;

    @Autowired
    public MongoMapping(MongoTemplate mongoTemplate, MongoConverter mongoConverter) {
        this.mongoTemplate = mongoTemplate;
        this.mongoConverter = mongoConverter;
    }

    @Bean
    public MongoTransactionManager transactionManager() {
        return new MongoTransactionManager(this.mongoTemplate.getMongoDatabaseFactory());
    }

    @Bean
    public MongockSpring5.MongockApplicationRunner mongockApplicationRunner(ApplicationContext springContext, MongoTemplate mongoTemplate) {
        SpringDataMongo3Driver driver = SpringDataMongo3Driver.withDefaultLock((MongoTemplate)mongoTemplate);
        driver.disableTransaction();
        return ((MongockSpring5.Builder)((MongockSpring5.Builder)MongockSpring5.builder().setDriver((ConnectionDriver)driver).addChangeLogsScanPackage("myconext.mongo")).setSpringContext(springContext)).buildApplicationRunner();
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void initIndicesAfterStartup() {
        ((MappingMongoConverter)this.mongoConverter).setMapKeyDotReplacement("@");
        MongoMappingContext mappingContext = (MongoMappingContext)this.mongoConverter.getMappingContext();
        Collection persistentEntities = mappingContext.getPersistentEntities();
        for (MongoPersistentEntity persistentEntity : persistentEntities) {
            Class clazz = persistentEntity.getType();
            if (!clazz.isAnnotationPresent(Document.class)) continue;
            MongoPersistentEntityIndexResolver resolver = new MongoPersistentEntityIndexResolver((MappingContext)mappingContext);
            IndexOperations indexOps = this.mongoTemplate.indexOps(clazz);
            resolver.resolveIndexFor(clazz).forEach(arg_0 -> ((IndexOperations)indexOps).ensureIndex(arg_0));
        }
        List userIndexes = this.mongoTemplate.indexOps(User.class).getIndexInfo().stream().map(IndexInfo::getName).filter(name -> name.contains("email")).collect(Collectors.toList());
        String userEmailUniqueIndexName = "user_email_unique";
        userIndexes.stream().filter(name -> !name.equals(userEmailUniqueIndexName)).forEach(name -> this.mongoTemplate.indexOps(User.class).dropIndex(name));
        if (!userIndexes.contains(userEmailUniqueIndexName)) {
            this.mongoTemplate.indexOps(User.class).ensureIndex((IndexDefinition)new Index("email", Sort.Direction.ASC).named(userEmailUniqueIndexName).collation(Collation.of((Locale)Locale.ENGLISH).strength(2)).unique());
        }
        this.mongoTemplate.indexOps(Enrollment.class).ensureIndex((IndexDefinition)new Index("key", Sort.Direction.ASC));
        this.mongoTemplate.indexOps(Enrollment.class).ensureIndex((IndexDefinition)new Index("enrollmentSecret", Sort.Direction.ASC));
        this.mongoTemplate.indexOps(Authentication.class).ensureIndex((IndexDefinition)new Index("sessionKey", Sort.Direction.ASC));
        IndexOperations registrationsIndex = this.mongoTemplate.indexOps(Registration.class);
        if (registrationsIndex.getIndexInfo().stream().anyMatch(indexInfo -> indexInfo.getName().equals("userid"))) {
            registrationsIndex.dropIndex("userid");
        }
        registrationsIndex.ensureIndex((IndexDefinition)new Index("userId", Sort.Direction.ASC));
        this.mongoTemplate.indexOps(EmailsSend.class).ensureIndex((IndexDefinition)new Index("email", Sort.Direction.ASC).collation(Collation.of((Locale)Locale.ENGLISH).strength(2)));
    }
}

