/*
 * Decompiled with CFR 0.152.
 */
package myconext.cron;

import java.util.List;
import myconext.mail.MailBox;
import myconext.manage.Manage;
import myconext.repository.UserRepository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class InstitutionMailUsage {
    private static final Log LOG = LogFactory.getLog(InstitutionMailUsage.class);
    private final Manage manage;
    private final MailBox mailBox;
    private final UserRepository userRepository;
    private final boolean mailInstitutionMailUsage;
    private final boolean cronJobResponsible;
    private final boolean dryRunEmail;

    @Autowired
    public InstitutionMailUsage(Manage manage, MailBox mailBox, UserRepository userRepository, @Value(value="${cron.node-cron-job-responsible}") boolean cronJobResponsible, @Value(value="${feature.mail_institution_mail_usage}") boolean mailInstitutionMailUsage, @Value(value="${cron.dry-run-email}") boolean dryRunEmail) {
        this.manage = manage;
        this.mailBox = mailBox;
        this.userRepository = userRepository;
        this.cronJobResponsible = cronJobResponsible;
        this.mailInstitutionMailUsage = mailInstitutionMailUsage;
        this.dryRunEmail = dryRunEmail;
    }

    @Scheduled(cron="${cron.mail-institution-mail-usage-expression}")
    public void mailUsersWithInstitutionMail() {
        if (!this.mailInstitutionMailUsage || !this.cronJobResponsible) {
            return;
        }
        long start = System.currentTimeMillis();
        try {
            List<String> queryList = this.manage.getDomainNames().stream().filter(domainName -> !domainName.contains("*") && !domainName.contains("surf")).map(domain -> domain.replace(".", "\\.")).toList();
            String regex = "@" + String.join((CharSequence)"|", queryList) + "$";
            List users = this.userRepository.findByEmailDomain(regex);
            if (!this.dryRunEmail) {
                users.forEach(arg_0 -> ((MailBox)this.mailBox).sendInstitutionMailWarning(arg_0));
            }
            LOG.info((Object)String.format("Mailed %s users who use their institution domain in %s ms, dry-run: %s", users.size(), System.currentTimeMillis() - start, this.dryRunEmail));
        }
        catch (Exception e) {
            LOG.error((Object)"Error in mailUsersWithInstitutionMail", (Throwable)e);
        }
    }
}

