/*
 * Decompiled with CFR 0.152.
 */
package myconext.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import java.beans.Transient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import myconext.model.ProvisionedLinkedAccount;
import myconext.model.UpdateLinkedAccountRequest;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.util.StringUtils;

public class LinkedAccount
implements Serializable,
ProvisionedLinkedAccount {
    private String institutionIdentifier;
    private String schacHomeOrganization;
    private String displayNameEn;
    private String displayNameNl;
    private String logoUrl;
    @Indexed
    private String eduPersonPrincipalName;
    private String subjectId;
    private String givenName;
    private String familyName;
    private List<String> eduPersonAffiliations = new ArrayList();
    private boolean preferred;
    @Schema(type="integer", format="int64", example="1634813554997")
    private Date createdAt;
    @Schema(type="integer", format="int64", example="1634813554997")
    private Date expiresAt;
    private boolean external = false;
    private String institutionGuid;

    public LinkedAccount(String institutionIdentifier, String schacHomeOrganization, String eduPersonPrincipalName, String subjectId, String givenName, String familyName, List<String> eduPersonAffiliations, boolean preferred, Date createdAt, Date expiresAt) {
        this.institutionIdentifier = institutionIdentifier;
        this.schacHomeOrganization = StringUtils.hasText((String)schacHomeOrganization) ? schacHomeOrganization.toLowerCase() : schacHomeOrganization;
        this.eduPersonPrincipalName = eduPersonPrincipalName;
        this.subjectId = subjectId;
        this.givenName = givenName;
        this.familyName = familyName;
        this.eduPersonAffiliations = eduPersonAffiliations;
        this.preferred = preferred;
        this.createdAt = createdAt;
        this.expiresAt = expiresAt;
    }

    @Transient
    @JsonIgnore
    public boolean updateExpiresIn(String institutionIdentifier, String eppn, String subjectId, String givenName, String familyName, List<String> eduPersonAffiliations, Date expiresAt) {
        this.institutionIdentifier = institutionIdentifier;
        this.eduPersonPrincipalName = eppn;
        this.subjectId = subjectId;
        this.givenName = givenName;
        this.familyName = familyName;
        this.eduPersonAffiliations = eduPersonAffiliations;
        this.expiresAt = expiresAt;
        this.createdAt = new Date();
        return true;
    }

    @Transient
    @JsonIgnore
    public boolean areNamesValidated() {
        return StringUtils.hasText((String)this.givenName) && StringUtils.hasText((String)this.familyName);
    }

    @Transient
    @JsonIgnore
    public boolean isMatch(UpdateLinkedAccountRequest linkedAccount) {
        if (StringUtils.hasText((String)this.subjectId) && StringUtils.hasText((String)linkedAccount.getSubjectId())) {
            return this.subjectId.equals(linkedAccount.getSubjectId());
        }
        if (StringUtils.hasText((String)this.eduPersonPrincipalName) && StringUtils.hasText((String)linkedAccount.getEduPersonPrincipalName())) {
            return this.eduPersonPrincipalName.equals(linkedAccount.getEduPersonPrincipalName());
        }
        if (StringUtils.hasText((String)this.schacHomeOrganization) && StringUtils.hasText((String)linkedAccount.getSchacHomeOrganization())) {
            return this.schacHomeOrganization.equals(linkedAccount.getSchacHomeOrganization());
        }
        return false;
    }

    @Generated
    public LinkedAccount() {
    }

    @Generated
    public LinkedAccount(String institutionIdentifier, String schacHomeOrganization, String displayNameEn, String displayNameNl, String logoUrl, String eduPersonPrincipalName, String subjectId, String givenName, String familyName, List<String> eduPersonAffiliations, boolean preferred, Date createdAt, Date expiresAt, boolean external, String institutionGuid) {
        this.institutionIdentifier = institutionIdentifier;
        this.schacHomeOrganization = schacHomeOrganization;
        this.displayNameEn = displayNameEn;
        this.displayNameNl = displayNameNl;
        this.logoUrl = logoUrl;
        this.eduPersonPrincipalName = eduPersonPrincipalName;
        this.subjectId = subjectId;
        this.givenName = givenName;
        this.familyName = familyName;
        this.eduPersonAffiliations = eduPersonAffiliations;
        this.preferred = preferred;
        this.createdAt = createdAt;
        this.expiresAt = expiresAt;
        this.external = external;
        this.institutionGuid = institutionGuid;
    }

    @Generated
    public String getInstitutionIdentifier() {
        return this.institutionIdentifier;
    }

    @Generated
    public String getSchacHomeOrganization() {
        return this.schacHomeOrganization;
    }

    @Generated
    public String getDisplayNameEn() {
        return this.displayNameEn;
    }

    @Generated
    public String getDisplayNameNl() {
        return this.displayNameNl;
    }

    @Generated
    public String getLogoUrl() {
        return this.logoUrl;
    }

    @Generated
    public String getEduPersonPrincipalName() {
        return this.eduPersonPrincipalName;
    }

    @Generated
    public String getSubjectId() {
        return this.subjectId;
    }

    @Generated
    public String getGivenName() {
        return this.givenName;
    }

    @Generated
    public String getFamilyName() {
        return this.familyName;
    }

    @Generated
    public List<String> getEduPersonAffiliations() {
        return this.eduPersonAffiliations;
    }

    @Generated
    public boolean isPreferred() {
        return this.preferred;
    }

    @Generated
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Date getExpiresAt() {
        return this.expiresAt;
    }

    @Generated
    public boolean isExternal() {
        return this.external;
    }

    @Generated
    public String getInstitutionGuid() {
        return this.institutionGuid;
    }

    @Generated
    public void setDisplayNameEn(String displayNameEn) {
        this.displayNameEn = displayNameEn;
    }

    @Generated
    public void setDisplayNameNl(String displayNameNl) {
        this.displayNameNl = displayNameNl;
    }

    @Generated
    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    @Generated
    public void setEduPersonAffiliations(List<String> eduPersonAffiliations) {
        this.eduPersonAffiliations = eduPersonAffiliations;
    }

    @Generated
    public void setPreferred(boolean preferred) {
        this.preferred = preferred;
    }

    @Generated
    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setExpiresAt(Date expiresAt) {
        this.expiresAt = expiresAt;
    }

    @Generated
    public void setInstitutionGuid(String institutionGuid) {
        this.institutionGuid = institutionGuid;
    }
}

