/*
 * Decompiled with CFR 0.152.
 */
package myconext.model;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import myconext.manage.Manage;
import myconext.model.EduID;
import myconext.model.ExternalLinkedAccount;
import myconext.model.IdpScoping;
import myconext.model.LinkedAccount;
import myconext.model.PublicKeyCredentials;
import myconext.model.User;
import myconext.model.Verification;
import myconext.model.VerifyIssuer;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import tiqr.org.model.Registration;
import tiqr.org.model.RegistrationStatus;

public class UserResponse
implements Serializable {
    private final String id;
    private final String email;
    private final String chosenName;
    private final String familyName;
    private final String givenName;
    @Schema(type="integer", format="int64", example="1634813554997")
    private final Date dateOfBirth;
    private final String displayName;
    private final boolean usePassword;
    private final boolean usePublicKey;
    private final boolean forgottenPassword;
    private final List<PublicKeyCredentials> publicKeyCredentials;
    private final List<LinkedAccount> linkedAccounts;
    private final List<ExternalLinkedAccount> externalLinkedAccounts;
    private final String schacHomeOrganization;
    private final String uid;
    private final boolean rememberMe;
    private final long created;
    private final Map<String, EduID> eduIdPerServiceProvider;
    private final List<String> loginOptions;
    private final Map<String, Object> registration = new HashMap();

    public UserResponse(User user, Map<String, EduID> eduIdPerServiceProvider, Optional<Registration> optionalRegistration, boolean rememberMe, Manage manage, List<VerifyIssuer> issuers) {
        this.id = user.getId();
        this.email = user.getEmail();
        this.chosenName = user.getChosenName();
        this.givenName = user.getDerivedGivenName();
        this.familyName = user.getDerivedFamilyName();
        this.dateOfBirth = user.getDerivedDateOfBirth();
        this.displayName = this.givenName + " " + this.familyName;
        this.schacHomeOrganization = user.getSchacHomeOrganization();
        this.uid = user.getUid();
        this.usePassword = StringUtils.hasText((String)user.getPassword());
        this.publicKeyCredentials = user.getPublicKeyCredentials();
        this.linkedAccounts = user.getLinkedAccounts();
        if (!CollectionUtils.isEmpty((Collection)this.linkedAccounts)) {
            this.linkedAccounts.forEach(linkedAccount -> {
                Optional optionalIdentityProvider = manage.findIdentityProviderByDomainName(linkedAccount.getSchacHomeOrganization());
                optionalIdentityProvider.ifPresent(identityProvider -> {
                    linkedAccount.setDisplayNameEn(identityProvider.getName());
                    linkedAccount.setDisplayNameNl(identityProvider.getNameNl());
                    linkedAccount.setInstitutionGuid(identityProvider.getInstitutionGuid());
                    linkedAccount.setLogoUrl(identityProvider.getLogoUrl());
                });
            });
        }
        this.externalLinkedAccounts = user.getExternalLinkedAccounts().stream().filter(externalLinkedAccount -> !externalLinkedAccount.getIdpScoping().equals((Object)IdpScoping.studielink) || !Verification.Ongeverifieerd.equals((Object)externalLinkedAccount.getVerification())).map(externalLinkedAccount -> externalLinkedAccount.logoReference(issuers)).collect(Collectors.toList());
        this.usePublicKey = !CollectionUtils.isEmpty((Collection)this.publicKeyCredentials);
        this.forgottenPassword = user.isForgottenPassword();
        this.rememberMe = rememberMe;
        this.created = user.getCreated();
        if (!CollectionUtils.isEmpty(eduIdPerServiceProvider)) {
            eduIdPerServiceProvider.keySet().removeIf(Objects::isNull);
            eduIdPerServiceProvider.values().removeIf(Objects::isNull);
        }
        this.eduIdPerServiceProvider = eduIdPerServiceProvider;
        this.loginOptions = user.loginOptions();
        optionalRegistration.ifPresent(reg -> {
            if (!RegistrationStatus.FINALIZED.equals((Object)reg.getStatus())) {
                return;
            }
            Map surfSecureId = user.getSurfSecureId();
            boolean phoneVerified = surfSecureId.containsKey("phone-verified");
            this.registration.put("created", reg.getCreated().toEpochMilli());
            this.registration.put("status", reg.getStatus());
            this.registration.put("notificationType", reg.getNotificationType());
            this.registration.put("notificationAddress", reg.getNotificationAddress());
            this.registration.put("phoneVerified", phoneVerified);
            this.registration.put("recoveryCode", surfSecureId.containsKey("recovery-code"));
            if (phoneVerified) {
                String phoneNumber = (String)surfSecureId.get("phone-number");
                this.registration.put("phoneNumber", phoneNumber.substring(phoneNumber.length() - 3));
            }
            this.registration.put("updated", reg.getUpdated().toEpochMilli());
        });
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getChosenName() {
        return this.chosenName;
    }

    @Generated
    public String getFamilyName() {
        return this.familyName;
    }

    @Generated
    public String getGivenName() {
        return this.givenName;
    }

    @Generated
    public Date getDateOfBirth() {
        return this.dateOfBirth;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public boolean isUsePassword() {
        return this.usePassword;
    }

    @Generated
    public boolean isUsePublicKey() {
        return this.usePublicKey;
    }

    @Generated
    public boolean isForgottenPassword() {
        return this.forgottenPassword;
    }

    @Generated
    public List<PublicKeyCredentials> getPublicKeyCredentials() {
        return this.publicKeyCredentials;
    }

    @Generated
    public List<LinkedAccount> getLinkedAccounts() {
        return this.linkedAccounts;
    }

    @Generated
    public List<ExternalLinkedAccount> getExternalLinkedAccounts() {
        return this.externalLinkedAccounts;
    }

    @Generated
    public String getSchacHomeOrganization() {
        return this.schacHomeOrganization;
    }

    @Generated
    public String getUid() {
        return this.uid;
    }

    @Generated
    public boolean isRememberMe() {
        return this.rememberMe;
    }

    @Generated
    public long getCreated() {
        return this.created;
    }

    @Generated
    public Map<String, EduID> getEduIdPerServiceProvider() {
        return this.eduIdPerServiceProvider;
    }

    @Generated
    public List<String> getLoginOptions() {
        return this.loginOptions;
    }

    @Generated
    public Map<String, Object> getRegistration() {
        return this.registration;
    }
}

