/*
 * Decompiled with CFR 0.152.
 */
package myconext.eduid;

import io.swagger.v3.oas.annotations.Hidden;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import myconext.api.HasUserRepository;
import myconext.exceptions.UserNotFoundException;
import myconext.model.EduID;
import myconext.model.User;
import myconext.repository.UserRepository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/myconext/api/eduid"}, produces={"application/json"})
@Hidden
public class APIController
implements HasUserRepository {
    private static final Log LOG = LogFactory.getLog(APIController.class);
    private final UserRepository userRepository;

    public APIController(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    @GetMapping(value={"/eppn"})
    public List<Map<String, String>> eppn(BearerTokenAuthentication authentication, @RequestParam(value="schachome", required=false) String schachome) {
        String clientId = (String)authentication.getTokenAttributes().get("client_id");
        LOG.info((Object)String.format("Endpoint '/eppn/ called by authentication %s", clientId));
        List<Map<String, String>> results = this.getUser(authentication).linkedAccountsSorted().stream().map(linkedAccount -> {
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("eppn", linkedAccount.getEduPersonPrincipalName());
            info.put("schac_home_organization", linkedAccount.getSchacHomeOrganization());
            return info;
        }).filter(info -> !StringUtils.hasText((String)schachome) || schachome.equals(info.get("schac_home_organization"))).collect(Collectors.toList());
        LOG.info((Object)String.format("Endpoint '/eppn/ results %s for authentication %s", results, clientId));
        return results;
    }

    @GetMapping(value={"/eduid"})
    public ResponseEntity<Map<String, String>> eduid(BearerTokenAuthentication authentication) {
        String clientId = (String)authentication.getTokenAttributes().get("client_id");
        LOG.info((Object)String.format("Endpoint '/eduid/ called by authentication %s", clientId));
        Optional optionalUser = this.userRepository.findByEduIDS_serviceProviderEntityId(clientId).or(() -> this.userRepository.findByEduIDS_Services_EntityId(clientId));
        if (optionalUser.isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build();
        }
        User user = (User)optionalUser.get();
        List eduIDs = user.getEduIDS().stream().filter(eduID -> clientId.equals(eduID.getServiceProviderEntityId()) || eduID.getServices().stream().anyMatch(service -> clientId.equals(service.getEntityId()))).map(EduID::getValue).collect(Collectors.toList());
        HashMap results = eduIDs.isEmpty() ? new HashMap() : Collections.singletonMap("eduid", (String)eduIDs.get(0));
        LOG.info((Object)String.format("Endpoint '/eduid/ results %s for authentication %s", results, clientId));
        return ResponseEntity.ok(results);
    }

    @GetMapping(value={"/links"})
    public List<Map<String, String>> links(BearerTokenAuthentication authentication) {
        String clientId = (String)authentication.getTokenAttributes().get("client_id");
        LOG.info((Object)String.format("Endpoint '/links/ called by authentication %s", clientId));
        User user = this.getUser(authentication);
        ArrayList<Map<String, String>> results = new ArrayList<Map<String, String>>(user.linkedAccountsSorted().stream().map(linkedAccount -> {
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("eppn", linkedAccount.getEduPersonPrincipalName());
            info.put("schac_home_organization", linkedAccount.getSchacHomeOrganization());
            if (linkedAccount.areNamesValidated()) {
                info.put("validated_name", String.format("%s %s", linkedAccount.getGivenName(), linkedAccount.getFamilyName()));
            }
            return info;
        }).toList());
        List<Map> externalValidatedNames = user.getExternalLinkedAccounts().stream().filter(acc -> acc.areNamesValidated() && acc.isPreferred()).map(externalLinkedAccount -> Map.of("validated_name", String.format("%s %s", externalLinkedAccount.getGivenName(), externalLinkedAccount.getFamilyName()))).toList();
        results.addAll(externalValidatedNames);
        LOG.info((Object)String.format("Endpoint '/links/ results %s for authentication %s", results, clientId));
        return results;
    }

    private User getUser(BearerTokenAuthentication authentication) {
        User user;
        ArrayList uids = (ArrayList)authentication.getTokenAttributes().get("uids");
        if (CollectionUtils.isEmpty((Collection)uids)) {
            String eduid = (String)authentication.getTokenAttributes().get("eduid");
            LOG.info((Object)("EPPN API call: finding user by eduid: " + eduid));
            Optional optionalUser = this.findUserByEduIDValue(eduid);
            user = (User)optionalUser.orElseThrow(() -> new UserNotFoundException(eduid));
        } else {
            String uid = (String)uids.get(0);
            LOG.info((Object)("EPPN API call: finding user by uid: " + uid));
            user = (User)this.userRepository.findUserByUid(uid).orElseThrow(() -> new UserNotFoundException(uid));
        }
        return user;
    }

    @Generated
    public UserRepository getUserRepository() {
        return this.userRepository;
    }
}

