/*
 * Decompiled with CFR 0.152.
 */
package myconext.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.yubico.webauthn.AssertionRequest;
import com.yubico.webauthn.AssertionResult;
import com.yubico.webauthn.CredentialRepository;
import com.yubico.webauthn.FinishAssertionOptions;
import com.yubico.webauthn.FinishRegistrationOptions;
import com.yubico.webauthn.RegistrationResult;
import com.yubico.webauthn.RelyingParty;
import com.yubico.webauthn.StartAssertionOptions;
import com.yubico.webauthn.StartRegistrationOptions;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.PublicKeyCredential;
import com.yubico.webauthn.data.PublicKeyCredentialCreationOptions;
import com.yubico.webauthn.data.PublicKeyCredentialDescriptor;
import com.yubico.webauthn.data.RelyingPartyIdentity;
import com.yubico.webauthn.data.UserIdentity;
import com.yubico.webauthn.data.exception.Base64UrlException;
import com.yubico.webauthn.exception.AssertionFailedException;
import com.yubico.webauthn.exception.RegistrationFailedException;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import jakarta.validation.Valid;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import myconext.cron.DisposableEmailProviders;
import myconext.crypto.HashGenerator;
import myconext.exceptions.DuplicateUserEmailException;
import myconext.exceptions.ExpiredAuthenticationException;
import myconext.exceptions.ForbiddenException;
import myconext.exceptions.NotAcceptableException;
import myconext.exceptions.UserNotFoundException;
import myconext.log.MDCContext;
import myconext.mail.MailBox;
import myconext.manage.Manage;
import myconext.model.Challenge;
import myconext.model.ChangeEmailHash;
import myconext.model.ControlCode;
import myconext.model.CreateAccount;
import myconext.model.CreateInstitutionEduID;
import myconext.model.DeleteService;
import myconext.model.DeleteServiceTokens;
import myconext.model.ExternalLinkedAccount;
import myconext.model.IdentityProvider;
import myconext.model.IdinIssuers;
import myconext.model.LinkedAccount;
import myconext.model.LoginStatus;
import myconext.model.MagicLinkRequest;
import myconext.model.PasswordResetHash;
import myconext.model.PublicKeyCredentials;
import myconext.model.RemoteProvider;
import myconext.model.SamlAuthenticationRequest;
import myconext.model.StatusResponse;
import myconext.model.Token;
import myconext.model.TokenRepresentation;
import myconext.model.UpdateEmailRequest;
import myconext.model.UpdateLinkedAccountRequest;
import myconext.model.UpdateUserNameRequest;
import myconext.model.UpdateUserSecurityRequest;
import myconext.model.User;
import myconext.model.UserResponse;
import myconext.model.VerifyIssuer;
import myconext.oidcng.OpenIDConnect;
import myconext.repository.AuthenticationRequestRepository;
import myconext.repository.ChallengeRepository;
import myconext.repository.ChangeEmailHashRepository;
import myconext.repository.PasswordResetHashRepository;
import myconext.repository.RegistrationRepository;
import myconext.repository.UserRepository;
import myconext.security.EmailDomainGuard;
import myconext.security.EmailGuessingPrevention;
import myconext.security.ServicesConfiguration;
import myconext.security.UserAuthentication;
import myconext.security.VerificationCodeGenerator;
import myconext.webauthn.UserCredentialRepository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/myconext/api", "/mobile/api"})
@SecurityRequirement(name="openId", scopes={"eduid.nl/mobile"})
@EnableConfigurationProperties(value={ServicesConfiguration.class})
public class UserController
implements UserAuthentication {
    private static final Log LOG = LogFactory.getLog(UserController.class);
    private final UserRepository userRepository;
    private final AuthenticationRequestRepository authenticationRequestRepository;
    private final MailBox mailBox;
    private final Manage manage;
    private final OpenIDConnect openIDConnect;
    private final String magicLinkUrl;
    private final String schacHomeOrganization;
    private final String webAuthnSpRedirectUrl;
    private final String idpBaseUrl;
    private final RelyingParty relyingParty;
    private final UserCredentialRepository userCredentialRepository;
    private final ChallengeRepository challengeRepository;
    private final PasswordResetHashRepository passwordResetHashRepository;
    private final ChangeEmailHashRepository changeEmailHashRepository;
    private final PasswordEncoder passwordEncoder = new BCryptPasswordEncoder(4, new SecureRandom());
    private final EmailGuessingPrevention emailGuessingPreventor;
    private final EmailDomainGuard emailDomainGuard;
    private final DisposableEmailProviders disposableEmailProviders;
    private final String spBaseUrl;
    private final ObjectMapper objectMapper;
    private final RegistrationRepository registrationRepository;
    private final boolean featureDefaultRememberMe;
    private final boolean sendJsExceptions;
    private final ServicesConfiguration servicesConfiguration;
    private final List<VerifyIssuer> issuers;
    private final List<String> unknownIssuers = List.of("CURRNL2A");
    private final boolean serviceDeskActive;

    public UserController(UserRepository userRepository, UserCredentialRepository userCredentialRepository, ChallengeRepository challengeRepository, PasswordResetHashRepository passwordResetHashRepository, ChangeEmailHashRepository changeEmailHashRepository, AuthenticationRequestRepository authenticationRequestRepository, MailBox mailBox, Manage manage, OpenIDConnect openIDConnect, EmailDomainGuard emailDomainGuard, DisposableEmailProviders disposableEmailProviders, RegistrationRepository registrationRepository, @Qualifier(value="jsonMapper") ObjectMapper objectMapper, @Value(value="${email.magic-link-url}") String magicLinkUrl, @Value(value="${schac_home_organization}") String schacHomeOrganization, @Value(value="${email_guessing_sleep_millis}") int emailGuessingSleepMillis, @Value(value="${sp_redirect_url}") String spBaseUrl, @Value(value="${idp_redirect_url}") String idpBaseUrl, @Value(value="${rp_origin}") String rpOrigin, @Value(value="${rp_id}") String rpId, @Value(value="${feature.default_remember_me}") boolean featureDefaultRememberMe, @Value(value="${feature.send_js_exceptions}") boolean sendJsExceptions, @Value(value="${feature.service_desk_active}") boolean serviceDeskActive, @Value(value="${verify.issuers_path}") Resource issuersResource, ServicesConfiguration servicesConfiguration) throws IOException {
        this.userRepository = userRepository;
        this.userCredentialRepository = userCredentialRepository;
        this.challengeRepository = challengeRepository;
        this.passwordResetHashRepository = passwordResetHashRepository;
        this.changeEmailHashRepository = changeEmailHashRepository;
        this.authenticationRequestRepository = authenticationRequestRepository;
        this.mailBox = mailBox;
        this.manage = manage;
        this.openIDConnect = openIDConnect;
        this.emailDomainGuard = emailDomainGuard;
        this.disposableEmailProviders = disposableEmailProviders;
        this.registrationRepository = registrationRepository;
        this.objectMapper = objectMapper;
        this.magicLinkUrl = magicLinkUrl;
        this.schacHomeOrganization = schacHomeOrganization;
        this.idpBaseUrl = idpBaseUrl;
        this.spBaseUrl = spBaseUrl;
        this.webAuthnSpRedirectUrl = String.format("%s/security", spBaseUrl);
        this.servicesConfiguration = servicesConfiguration;
        this.relyingParty = this.relyingParty(rpId, rpOrigin);
        this.emailGuessingPreventor = new EmailGuessingPrevention(emailGuessingSleepMillis);
        this.featureDefaultRememberMe = featureDefaultRememberMe;
        this.sendJsExceptions = sendJsExceptions;
        this.serviceDeskActive = serviceDeskActive;
        List idinIssuers = (List)objectMapper.readValue(issuersResource.getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        this.issuers = ((IdinIssuers)idinIssuers.get(0)).getIssuers().stream().filter(issuer -> !this.unknownIssuers.contains(issuer.getId())).collect(Collectors.toList());
    }

    @Operation(summary="All institutional domains", description="All institutional domains which will generate a warning if a user enters an email at this domain")
    @GetMapping(value={"/idp/email/domain/institutional", "/sp/create-from-institution/domain/institutional"})
    public Set<String> institutionalDomains() {
        return this.manage.getDomainNames();
    }

    @Hidden
    @GetMapping(value={"/idp/email/domain/allowed", "/sp/create-from-institution/domain/allowed"})
    public Set<String> allowedDomains() {
        return this.emailDomainGuard.getAllowedDomains();
    }

    @Hidden
    @GetMapping(value={"/idp/service/name/{id}"})
    public Map<String, String> serviceName(@PathVariable(value="id") String id) {
        if ("42".equals(id)) {
            return Collections.singletonMap("name", "This Beautiful Service");
        }
        SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)this.authenticationRequestRepository.findById((Object)id).orElseThrow(() -> new ExpiredAuthenticationException("Expired samlAuthenticationRequest: " + id));
        return Collections.singletonMap("name", samlAuthenticationRequest.getServiceName());
    }

    @Hidden
    @GetMapping(value={"/idp/me/{hash}"})
    public UserResponse userInfo(@PathVariable(value="hash") String hash) {
        SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)this.authenticationRequestRepository.findByHash(hash).orElseThrow(() -> new ExpiredAuthenticationException("Expired authentication request"));
        User user = (User)this.userRepository.findById((Object)samlAuthenticationRequest.getUserId()).orElseThrow(() -> new ExpiredAuthenticationException("Expired authentication request"));
        return new UserResponse(user, null, Optional.empty(), false, this.manage, this.issuers);
    }

    @Hidden
    @PostMapping(value={"/idp/service/email"})
    public List<String> knownAccount(@RequestBody Map<String, String> email) {
        this.emailGuessingPreventor.potentialUserEmailGuess();
        User user = (User)this.userRepository.findUserByEmail(email.get("email")).orElseThrow(() -> new UserNotFoundException(String.format("User with email %s not found", email.get("email"))));
        return user.loginOptions();
    }

    @Hidden
    @PostMapping(value={"/sp/error"})
    public ResponseEntity<Map<String, Integer>> reportError(@RequestBody Map<String, Object> json, Authentication authentication, HttpServletRequest request) {
        if (!this.sendJsExceptions) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).body(Map.of("status", HttpStatus.NO_CONTENT.value()));
        }
        User user = this.userFromAuthentication(authentication);
        HttpSession session = request.getSession(true);
        Integer errorCount = (Integer)session.getAttribute("error_count");
        if (errorCount != null && errorCount > 9) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNPROCESSABLE_ENTITY).body(Map.of("status", HttpStatus.UNPROCESSABLE_ENTITY.value()));
        }
        session.setAttribute("error_count", (Object)(errorCount == null ? 1 : errorCount + 1));
        this.mailBox.sendErrorMail(json, user);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body(Map.of("status", HttpStatus.CREATED.value()));
    }

    @Hidden
    @GetMapping(value={"/idp/service/hash/{hash}"})
    public Map<String, String> serviceNameByHash(@PathVariable(value="hash") String hash) {
        return Collections.singletonMap("name", ((SamlAuthenticationRequest)this.authenticationRequestRepository.findByHash(hash).orElseThrow(() -> new ExpiredAuthenticationException("Expired authentication request"))).getServiceName());
    }

    @Hidden
    @GetMapping(value={"/idp/service/id/{id}"})
    public Map<String, String> serviceNameById(@PathVariable(value="id") String id) {
        return Collections.singletonMap("name", ((SamlAuthenticationRequest)this.authenticationRequestRepository.findById((Object)id).orElseThrow(() -> new ExpiredAuthenticationException("Expired authentication request"))).getServiceName());
    }

    @Hidden
    @PostMapping(value={"/idp/magic_link_request"})
    public ResponseEntity newMagicLinkRequest(HttpServletRequest request, @Valid @RequestBody MagicLinkRequest magicLinkRequest) {
        SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)this.authenticationRequestRepository.findByIdAndNotExpired(magicLinkRequest.getAuthenticationRequestId()).orElseThrow(() -> new ExpiredAuthenticationException("Expired authentication request"));
        User user = magicLinkRequest.getUser();
        String email = user.getEmail();
        this.verifyEmails(email);
        Optional optionalUser = this.userRepository.findUserByEmail(this.emailGuessingPreventor.sanitizeEmail(email));
        if (optionalUser.isPresent()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body(Collections.singletonMap("status", HttpStatus.CONFLICT.value()));
        }
        String preferredLanguage = LocaleContextHolder.getLocale().getLanguage();
        String requesterEntityId = samlAuthenticationRequest.getRequesterEntityId();
        String schacHomeOrganization = this.emailDomainGuard.schacHomeOrganizationByDomain(this.schacHomeOrganization, email);
        User userToSave = new User(UUID.randomUUID().toString(), email, user.getGivenName(), user.getGivenName(), user.getFamilyName(), schacHomeOrganization, preferredLanguage, requesterEntityId, this.manage);
        userToSave = (User)this.userRepository.save((Object)userToSave);
        return this.doMagicLink(userToSave, samlAuthenticationRequest, false, request);
    }

    @Hidden
    @PutMapping(value={"/idp/magic_link_request"})
    public ResponseEntity magicLinkRequest(HttpServletRequest request, @Valid @RequestBody MagicLinkRequest magicLinkRequest) {
        SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)this.authenticationRequestRepository.findByIdAndNotExpired(magicLinkRequest.getAuthenticationRequestId()).orElseThrow(() -> new ExpiredAuthenticationException("Expired samlAuthenticationRequest: " + magicLinkRequest.getAuthenticationRequestId()));
        User providedUser = magicLinkRequest.getUser();
        String email = providedUser.getEmail();
        this.verifyEmails(email);
        Optional optionalUser = this.findUserStoreLanguage(email);
        if (!optionalUser.isPresent()) {
            return this.return404();
        }
        User user = (User)optionalUser.get();
        String requesterEntityId = samlAuthenticationRequest.getRequesterEntityId();
        MDCContext.logWithContext((User)user, (String)"update", (String)"user", (Log)LOG, (String)("Updating user " + user.getEmail()));
        user.computeEduIdForServiceProviderIfAbsent(requesterEntityId, this.manage);
        this.userRepository.save((Object)user);
        if (magicLinkRequest.isUsePassword()) {
            if (!this.passwordEncoder.matches((CharSequence)providedUser.getPassword(), user.getPassword())) {
                MDCContext.logLoginWithContext((User)user, (String)"password", (boolean)false, (Log)LOG, (String)"Bad attempt to login with password", (HttpServletRequest)request);
                return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body(Collections.singletonMap("status", HttpStatus.FORBIDDEN.value()));
            }
            MDCContext.logLoginWithContext((User)user, (String)"password", (boolean)true, (Log)LOG, (String)"Successfully logged in with password", (HttpServletRequest)request);
            LOG.info((Object)"Successfully logged in with password");
        }
        return this.doMagicLink(user, samlAuthenticationRequest, magicLinkRequest.isUsePassword(), request);
    }

    @Hidden
    @GetMapping(value={"/idp/resend_magic_link_request"})
    public ResponseEntity resendMagicLinkRequest(HttpServletRequest request, @RequestParam(value="id") String authenticationRequestId) {
        SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)this.authenticationRequestRepository.findByIdAndNotExpired(authenticationRequestId).orElseThrow(() -> new ExpiredAuthenticationException("Expired samlAuthenticationRequest: " + authenticationRequestId));
        String userId = samlAuthenticationRequest.getUserId();
        User user = (User)this.userRepository.findById((Object)userId).orElseThrow(() -> new UserNotFoundException(userId));
        if (user.isNewUser()) {
            this.sendAccountVerificationMail(samlAuthenticationRequest, user);
        } else {
            String serviceName = this.manage.getServiceName(request, samlAuthenticationRequest);
            this.mailBox.sendMagicLink(user, samlAuthenticationRequest.getHash(), serviceName);
        }
        return ResponseEntity.ok((Object)true);
    }

    private void sendAccountVerificationMail(SamlAuthenticationRequest samlAuthenticationRequest, User user) {
        LOG.debug((Object)String.format("Sending account verification mail with magic link for new user %s", user.getUsername()));
        this.mailBox.sendAccountVerification(user, samlAuthenticationRequest.getHash());
    }

    @Hidden
    @GetMapping(value={"/idp/security/success"})
    public int successfullyLoggedIn(@RequestParam(value="id") String id) {
        Optional optionalSamlAuthenticationRequest = this.authenticationRequestRepository.findById((Object)id);
        return optionalSamlAuthenticationRequest.map(samlAuthenticationRequest -> samlAuthenticationRequest.getLoginStatus().ordinal()).orElse(LoginStatus.NOT_LOGGED_IN.ordinal());
    }

    @Operation(summary="Institution displaynames", description="Retrieve the displayNames of the Institution by the schac_home value")
    @GetMapping(value={"/sp/institution/names"})
    public ResponseEntity<IdentityProvider> institutionNames(@RequestParam(value="schac_home") String schacHome) {
        return ResponseEntity.ok((Object)this.manage.findIdentityProviderByDomainName(schacHome).orElse(new IdentityProvider(new RemoteProvider(schacHome, schacHome, schacHome, null, null), null, null)));
    }

    @Operation(summary="User details", description="Retrieve the attributes of the current user")
    @GetMapping(value={"/sp/me"})
    public ResponseEntity<UserResponse> me(Authentication authentication) {
        User user = this.userFromAuthentication(authentication);
        return this.userResponseRememberMe(user);
    }

    @Operation(summary="Forget me", description="Delete the long remember-me login for the current user")
    @DeleteMapping(value={"/sp/forget"})
    public ResponseEntity<Long> forgetMe(Authentication authentication) {
        User user = this.userFromAuthentication(authentication);
        Long count = this.authenticationRequestRepository.deleteByUserId(user.getId());
        MDCContext.logWithContext((User)user, (String)"delete", (String)"rememberme", (Log)LOG, (String)"Do not remember user anymore");
        return ResponseEntity.ok((Object)count);
    }

    @Operation(summary="Create eduID account", description="Create an eduID account and sent a verification mail to the user to confirm the ownership of the email. <br/>Link in the validation email is <a href=\"\">https://login.{environment}.eduid.nl/mobile/api/in-app/create-from-mobile-api?h=={{hash}}</a> whichmust be captured by the eduID app webview.<br/>After the account is finalized server-side the user is logged in and the server redirects to <a href=\"\">https://login.{environment}.eduid.nl/client/mobile/created</a><br/>If the URL is not properly intercepted by the eduID app, then the browser app redirects to <a href=\"\">eduid://client/mobile/created?new=true</a>", responses={@ApiResponse(responseCode="201", description="Created. Mail is sent to the user", content={@Content(schema=@Schema(implementation=StatusResponse.class), examples={@ExampleObject(value="{\"status\":201}")})}), @ApiResponse(responseCode="412", description="Forbidden email domain", content={@Content(schema=@Schema(implementation=StatusResponse.class), examples={@ExampleObject(value="{\"status\":412}")})}), @ApiResponse(responseCode="409", description="Email is in use", content={@Content(schema=@Schema(implementation=StatusResponse.class), examples={@ExampleObject(value="{\"status\":409}")})})})
    @PostMapping(value={"/idp/create"})
    public ResponseEntity<StatusResponse> createEduIDAccount(@Valid @RequestBody CreateAccount createAccount, @RequestParam(value="in-app", required=false, defaultValue="false") boolean inAppIndicator) {
        String email = createAccount.getEmail();
        this.verifyEmails(email);
        Optional optionalUser = this.userRepository.findUserByEmail(this.emailGuessingPreventor.sanitizeEmail(email));
        if (optionalUser.isPresent()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)new StatusResponse(HttpStatus.CONFLICT.value()));
        }
        CreateInstitutionEduID institution = new CreateInstitutionEduID(HashGenerator.hash(), email, true);
        User user = new User(UUID.randomUUID().toString(), institution.getEmail(), createAccount.getGivenName(), createAccount.getGivenName(), createAccount.getFamilyName(), this.schacHomeOrganization, "en", createAccount.getRelyingPartClientId(), this.manage);
        user.setCreateFromInstitutionKey(institution.getHash());
        user.validate();
        this.userRepository.save((Object)user);
        String inAppPath = inAppIndicator ? "/in-app" : "";
        String linkUrl = String.format("%s/mobile/api/create-from-mobile-api%s", this.idpBaseUrl, inAppPath);
        this.mailBox.sendAccountVerificationMobileAPI(user, institution.getHash(), linkUrl);
        MDCContext.logWithContext((User)user, (String)"create", (String)"user", (Log)LOG, (String)"Create user in mobile API");
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)new StatusResponse(HttpStatus.CREATED.value()));
    }

    @Operation(summary="Change names", description="Update the givenName, chosenName and / or the familyName of the User")
    @PutMapping(value={"/sp/update"})
    public ResponseEntity<UserResponse> updateUserProfile(Authentication authentication, @Valid @RequestBody UpdateUserNameRequest deltaUser) {
        User user = this.userFromAuthentication(authentication);
        if (StringUtils.hasText((String)deltaUser.getGivenName())) {
            user.setChosenName(deltaUser.getGivenName());
        }
        if (StringUtils.hasText((String)deltaUser.getChosenName())) {
            user.setChosenName(deltaUser.getChosenName());
        }
        if (StringUtils.hasText((String)deltaUser.getGivenName())) {
            user.setGivenName(deltaUser.getGivenName());
        }
        if (StringUtils.hasText((String)deltaUser.getFamilyName())) {
            user.setFamilyName(deltaUser.getFamilyName());
        }
        user.validate();
        this.userRepository.save((Object)user);
        MDCContext.logWithContext((User)user, (String)"update", (String)"name", (Log)LOG, (String)"Update user profile");
        this.authenticationRequestRepository.deleteByUserId(user.getId());
        return this.returnUserResponse(user);
    }

    @Operation(summary="Mark linkedAccount as preferred", description="Mark linkedAccount as preferred")
    @PutMapping(value={"/sp/prefer-linked-account"})
    public ResponseEntity<UserResponse> updateLinkedAccount(Authentication authentication, @Valid @RequestBody UpdateLinkedAccountRequest updateLinkedAccountRequest) {
        User user = this.userFromAuthentication(authentication);
        if (updateLinkedAccountRequest.isExternal()) {
            user.getExternalLinkedAccounts().stream().filter(externalLinkedAccount -> externalLinkedAccount.getIdpScoping().name().equals(updateLinkedAccountRequest.getIdpScoping())).findFirst().ifPresent(externalLinkedAccount -> {
                externalLinkedAccount.setPreferred(true);
                user.getLinkedAccounts().forEach(linkedAccount -> linkedAccount.setPreferred(false));
            });
        } else {
            user.getLinkedAccounts().stream().filter(linkedAccount -> linkedAccount.isMatch(updateLinkedAccountRequest)).findFirst().ifPresent(linkedAccount -> {
                if (linkedAccount.areNamesValidated()) {
                    user.getLinkedAccounts().forEach(otherLinkedAccount -> otherLinkedAccount.setPreferred(false));
                    linkedAccount.setPreferred(true);
                    user.getExternalLinkedAccounts().forEach(account -> account.setPreferred(false));
                }
            });
        }
        this.userRepository.save((Object)user);
        MDCContext.logWithContext((User)user, (String)"update", (String)"name", (Log)LOG, (String)"Update user linked account");
        return this.returnUserResponse(user);
    }

    @Operation(summary="Change email", description="Request to change the email of the user. The link in the validation email is <a href=\"\">https://login.{environment}.eduid.nl/client/mobile/update-email?h=={{hash}}</a>with an unique 'h' query param which must be used in 'mobile/api/sp/confirm-email' to confirm the update.<br/>If the URL is not properly intercepted by the eduID app, then the browser app redirects to <a href=\"\">eduid://client/mobile/confirm-email?h={{hash}}</a>")
    @PutMapping(value={"/sp/email"})
    public ResponseEntity<UserResponse> updateEmail(Authentication authentication, @Valid @RequestBody UpdateEmailRequest updateEmailRequest, @RequestParam(value="force", required=false, defaultValue="false") boolean force) {
        User user = this.userFromAuthentication(authentication);
        List passwordResetHashes = this.passwordResetHashRepository.findByUserId(user.getId());
        if (!CollectionUtils.isEmpty((Collection)passwordResetHashes)) {
            if (force) {
                this.passwordResetHashRepository.deleteAll((Iterable)passwordResetHashes);
            } else {
                throw new NotAcceptableException("Update email not allowed. Outstanding password reset for: " + user.getEmail());
            }
        }
        this.changeEmailHashRepository.deleteByUserId(user.getId());
        String hashValue = HashGenerator.hash();
        String newEmail = updateEmailRequest.getEmail();
        Optional optionalUser = this.userRepository.findUserByEmail(this.emailGuessingPreventor.sanitizeEmail(newEmail));
        if (optionalUser.isPresent()) {
            throw new DuplicateUserEmailException("There already exists a user with email " + newEmail);
        }
        this.changeEmailHashRepository.save((Object)new ChangeEmailHash(user, newEmail, hashValue));
        MDCContext.logWithContext((User)user, (String)"update", (String)"update-email", (Log)LOG, (String)"Send update email mail");
        this.mailBox.sendUpdateEmail(user, newEmail, hashValue, this.isMobileRequest(authentication));
        this.authenticationRequestRepository.deleteByUserId(user.getId());
        return this.returnUserResponse(user);
    }

    @Operation(summary="Confirm email change", description="Confirm the user has clicked on the link in the email sent after requesting to change the users email<br/>A confirmation email is sent to notify the user of the security change with a link to the security settings <a href=\"\">https://login.{environment}.eduid.nl/client/mobile/security</a>. <br/>If this URL is not properly intercepted by the eduID app, then the browser app redirects to <a href=\"\">eduid://client/mobile/security</a>")
    @GetMapping(value={"/sp/confirm-email"})
    public ResponseEntity<UserResponse> confirmUpdateEmail(Authentication authentication, @Parameter(description="The hash obtained from the query parameter 'h' in the URL sent to the user in the update-email") @RequestParam(value="h") String hash) {
        User user = this.userFromAuthentication(authentication);
        String oldEmail = user.getEmail();
        ChangeEmailHash changeEmailHash = (ChangeEmailHash)this.changeEmailHashRepository.findByHashAndUserId(hash, user.getId()).orElseThrow(() -> new ForbiddenException("wrong_hash"));
        user.setEmail(changeEmailHash.getNewEmail());
        this.userRepository.save((Object)user);
        this.authenticationRequestRepository.deleteByUserId(user.getId());
        this.mailBox.sendUpdateConfirmationEmail(user, oldEmail, user.getEmail(), this.isMobileRequest(authentication));
        return this.returnUserResponse(user);
    }

    @GetMapping(value={"/sp/outstanding-email-links"})
    @Operation(summary="Get all outstanding change-emails-requests", description="Get all outstanding change-emails-requests for the logged in user")
    public ResponseEntity<Boolean> outstandingEmailLinks(Authentication authentication) {
        User user = this.userFromAuthentication(authentication);
        List emailHashes = this.changeEmailHashRepository.findByUserId(user.getId());
        return ResponseEntity.ok((Object)(!emailHashes.isEmpty() ? 1 : 0));
    }

    @Operation(summary="Validate password hash", description="Check if a password change hash is valid and not expired")
    @GetMapping(value={"/sp/password-reset-hash-valid"})
    public ResponseEntity<Boolean> resetPasswordHashValid(Authentication authentication, @RequestParam(value="hash") String hash) {
        User user = this.userFromAuthentication(authentication);
        Optional optionalPasswordResetHash = this.passwordResetHashRepository.findByHashAndUserId(hash, user.getId());
        boolean expired = optionalPasswordResetHash.isEmpty() || ((PasswordResetHash)optionalPasswordResetHash.get()).isExpired();
        return ResponseEntity.ok((Object)(!expired ? 1 : 0));
    }

    @Operation(summary="Update password", description="Update or delete the user's password using the hash from the 'h' query param in the validation email. If 'newPassword' is null / empty than the password is removed.")
    @PutMapping(value={"/sp/update-password"})
    public ResponseEntity<UserResponse> updateUserPassword(Authentication authentication, @RequestBody UpdateUserSecurityRequest updateUserRequest) {
        User user = this.userFromAuthentication(authentication);
        boolean existingPassword = StringUtils.hasText((String)user.getPassword());
        String newPassword = updateUserRequest.getNewPassword();
        boolean deletePassword = !StringUtils.hasText((String)newPassword);
        PasswordResetHash passwordResetHash = (PasswordResetHash)this.passwordResetHashRepository.findByHashAndUserId(updateUserRequest.getHash(), user.getId()).orElseThrow(() -> new ForbiddenException("wrong_hash"));
        if (passwordResetHash.isExpired()) {
            throw new ForbiddenException("wrong_hash");
        }
        if (deletePassword) {
            user.deletePassword();
        } else {
            user.encryptPassword(newPassword, this.passwordEncoder);
        }
        user.setForgottenPassword(false);
        this.userRepository.save((Object)user);
        this.passwordResetHashRepository.deleteByUserId(user.getId());
        String action = deletePassword ? "delete" : (existingPassword ? "update" : "add");
        MDCContext.logWithContext((User)user, (String)action, (String)"password", (Log)LOG, (String)(action + " password"));
        this.authenticationRequestRepository.deleteByUserId(user.getId());
        return this.returnUserResponse(user);
    }

    @PutMapping(value={"/sp/reset-password-link"})
    @Operation(summary="Reset password link", description="Sent the user a mail with a link for the user to change his / hers password. <br/>Link in the validation email is <a href=\"\">https://login.{environment}.eduid.nl/client/mobile/reset-password?h=={{hash}}</a> if the user already had a password, otherwise <a href=\"\">https://login.{environment}.eduid.nl/client/mobile/add-password?h=={{hash}}</a><br/>If the URL is not properly intercepted by the eduID app, then the browser app redirects to <a href=\"\">eduid://client/mobile/reset-password?h={{hash}}</a>")
    public ResponseEntity<UserResponse> resetPasswordLink(Authentication authentication) {
        User user = this.userFromAuthentication(authentication);
        List changeEmailHashes = this.changeEmailHashRepository.findByUserId(user.getId());
        this.changeEmailHashRepository.deleteAll((Iterable)changeEmailHashes);
        user.setForgottenPassword(true);
        this.userRepository.save((Object)user);
        String hashValue = HashGenerator.hash();
        this.passwordResetHashRepository.save((Object)new PasswordResetHash(user, hashValue));
        MDCContext.logWithContext((User)user, (String)"update", (String)"reset-password", (Log)LOG, (String)"Send password reset mail");
        if (StringUtils.hasText((String)user.getPassword())) {
            this.mailBox.sendResetPassword(user, hashValue, this.isMobileRequest(authentication));
        } else {
            this.mailBox.sendAddPassword(user, hashValue, this.isMobileRequest(authentication));
        }
        this.authenticationRequestRepository.deleteByUserId(user.getId());
        return this.returnUserResponse(user);
    }

    @PutMapping(value={"/sp/institution"})
    @Operation(summary="Remove linked account", description="Remove linked account for a logged in user")
    public ResponseEntity<UserResponse> removeUserLinkedAccounts(Authentication authentication, @RequestBody UpdateLinkedAccountRequest updateLinkedAccountRequest) {
        User user = this.userFromAuthentication(authentication);
        if (updateLinkedAccountRequest.isExternal()) {
            user.getExternalLinkedAccounts().clear();
            user.setDateOfBirth(null);
        } else {
            user.getLinkedAccounts().removeIf(linkedAccount -> linkedAccount.isMatch(updateLinkedAccountRequest));
        }
        user.reconcileLinkedAccounts();
        this.userRepository.save((Object)user);
        MDCContext.logWithContext((User)user, (String)"delete", (String)"linked_account", (Log)LOG, (String)("Deleted linked account " + updateLinkedAccountRequest.getEduPersonPrincipalName()));
        return this.userResponseRememberMe(user);
    }

    @PostMapping(value={"/sp/credential"})
    @Hidden
    public ResponseEntity updatePublicKeyCredential(Authentication authentication, @RequestBody Map<String, String> credential) {
        User user = this.userFromAuthentication(authentication);
        String identifier = credential.get("identifier");
        Optional<PublicKeyCredentials> publicKeyCredentials = user.getPublicKeyCredentials().stream().filter(key -> key.getIdentifier().equals(identifier)).findFirst();
        if (!publicKeyCredentials.isPresent()) {
            return this.return404();
        }
        PublicKeyCredentials credentials = publicKeyCredentials.get();
        credentials.setName(credential.get("name"));
        this.userRepository.save((Object)user);
        MDCContext.logWithContext((User)user, (String)"update", (String)"webauthn_key", (Log)LOG, (String)("Updated publicKeyCredential " + credential.get("name")));
        return this.userResponseRememberMe(user);
    }

    @PutMapping(value={"/sp/credential"})
    @Hidden
    public ResponseEntity removePublicKeyCredential(Authentication authentication, @RequestBody Map<String, String> credential) {
        User user = this.userFromAuthentication(authentication);
        String identifier = credential.get("identifier");
        List publicKeyCredentials = user.getPublicKeyCredentials().stream().filter(key -> !key.getIdentifier().equals(identifier)).collect(Collectors.toList());
        user.setPublicKeyCredentials(publicKeyCredentials);
        this.userRepository.save((Object)user);
        MDCContext.logWithContext((User)user, (String)"delete", (String)"webauthn_key", (Log)LOG, (String)("Deleted publicKeyCredential " + credential.get("name")));
        return this.userResponseRememberMe(user);
    }

    @Operation(summary="Remove user service", description="Remove user service by the eduID value")
    @PutMapping(value={"/sp/service"})
    public ResponseEntity<UserResponse> removeUserService(Authentication authentication, @Valid @RequestBody DeleteService deleteService) {
        User user = this.userFromAuthentication(authentication);
        String entityId = deleteService.getServiceProviderEntityId();
        user.getEduIDS().forEach(eduID -> eduID.getServices().removeIf(service -> entityId.equals(service.getEntityId()) || entityId.equals(service.getInstitutionGuid())));
        List newEduIDs = user.getEduIDS().stream().filter(eduID -> !eduID.getServices().isEmpty()).collect(Collectors.toList());
        user.setEduIDS(newEduIDs);
        this.userRepository.save((Object)user);
        MDCContext.logWithContext((User)user, (String)"delete", (String)"eppn", (Log)LOG, (String)("Deleted eduID " + entityId));
        return this.doRemoveTokens(deleteService.getTokens(), user);
    }

    @PutMapping(value={"/sp/tokens"})
    @Operation(summary="Remove user tokens", description="Remove user token for a service")
    public ResponseEntity<UserResponse> removeTokens(Authentication authentication, @RequestBody DeleteServiceTokens serviceAndTokens) {
        User user = this.userFromAuthentication(authentication);
        MDCContext.logWithContext((User)user, (String)"delete", (String)"tokens", (Log)LOG, (String)("Deleted tokens " + String.valueOf(serviceAndTokens.getTokens())));
        return this.doRemoveTokens(serviceAndTokens.getTokens(), user);
    }

    @GetMapping(value={"/sp/testWebAuthnUrl"})
    @Hidden
    public ResponseEntity<Map<String, String>> testWebAuthnUrl(Authentication authentication) throws UnsupportedEncodingException {
        User user = this.userFromAuthentication(authentication);
        SamlAuthenticationRequest samlAuthenticationRequest = new SamlAuthenticationRequest(true);
        samlAuthenticationRequest = (SamlAuthenticationRequest)this.authenticationRequestRepository.save((Object)samlAuthenticationRequest);
        String email = URLEncoder.encode(user.getEmail(), Charset.defaultCharset().name());
        String loginUrl = String.format("%s/webauthnTest/%s?name=Test-webAuthn&email=%s&testWebAuthn=true", this.idpBaseUrl, samlAuthenticationRequest.getId(), email);
        return ResponseEntity.status((int)200).body(Collections.singletonMap("url", loginUrl));
    }

    private ResponseEntity<UserResponse> doRemoveTokens(List<TokenRepresentation> tokens, User user) {
        if (!CollectionUtils.isEmpty(tokens)) {
            this.openIDConnect.deleteTokens(tokens, user);
        }
        return this.userResponseRememberMe(user);
    }

    @GetMapping(value={"/sp/tokens"})
    @Operation(summary="Get all OpenID Connect tokens", description="Get all OpenID Connect tokens for the logged in user", responses={@ApiResponse(responseCode="200", description="User tokens", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Token.class)), examples={@ExampleObject(value="[{\"expiresIn\":\"2023-03-08T08:59:17.458+00:00\",\"createdAt\":\"2022-12-08T08:59:17.458+00:00\",\"clientId\":\"student.mobility.rp.localhost\",\"clientName\":\"Student Mobility RP localhost\",\"audiences\":[\"student-mobility-home-institution-mock\",\"For localhost student mobility testing\",\"Resource Server for the Playground Client Test2\"],\"id\":\"6391a7651f7c1b41403f066f\",\"scopes\":[{\"name\":\"https://utrecht/api\",\"titles\":{},\"descriptions\":{\"en\":\"Retrieve personal information at Utrecht University \",\"nl\":\"Ophalen persoonsinformatie bij Utrecht Universiteit\"}}]")})})})
    public ResponseEntity<List<Token>> tokens(Authentication authentication) {
        User user = this.userFromAuthentication(authentication);
        List tokens = this.openIDConnect.tokens(user);
        return ResponseEntity.ok((Object)tokens);
    }

    private ResponseEntity<UserResponse> returnUserResponse(User user) {
        Optional optionalRegistration = this.registrationRepository.findRegistrationByUserId(user.getId());
        UserResponse userResponse = new UserResponse(user, user.convertEduIdPerServiceProvider(this.servicesConfiguration), optionalRegistration, false, this.manage, this.issuers);
        return ResponseEntity.status((int)201).body((Object)userResponse);
    }

    private ResponseEntity<UserResponse> userResponseRememberMe(User user) {
        List samlAuthenticationRequests = this.authenticationRequestRepository.findByUserIdAndRememberMe(user.getId(), true);
        Optional optionalRegistration = this.registrationRepository.findRegistrationByUserId(user.getId());
        if (user.reconcileLinkedAccounts()) {
            this.userRepository.save((Object)user);
        }
        UserResponse userResponse = new UserResponse(user, user.convertEduIdPerServiceProvider(this.servicesConfiguration), optionalRegistration, !samlAuthenticationRequests.isEmpty(), this.manage, this.issuers);
        return ResponseEntity.ok((Object)userResponse);
    }

    @GetMapping(value={"sp/security/webauthn"})
    @Hidden
    public ResponseEntity spStartWebAuthFlow(Authentication authentication) {
        User user = this.userFromAuthentication(authentication);
        String webAuthnIdentifier = HashGenerator.hash();
        user.setWebAuthnIdentifier(webAuthnIdentifier);
        this.userRepository.save((Object)user);
        return ResponseEntity.status((int)200).body(Collections.singletonMap("token", webAuthnIdentifier));
    }

    @PostMapping(value={"idp/security/webauthn/registration"})
    @Hidden
    public ResponseEntity idpWebAuthnRegistration(@RequestBody Map<String, String> body) throws Base64UrlException {
        String token = body.get("token");
        Optional optionalUser = this.userRepository.findUserByWebAuthnIdentifier(token);
        if (!optionalUser.isPresent()) {
            return this.return404();
        }
        User user = (User)optionalUser.get();
        if (!StringUtils.hasText((String)user.getUserHandle())) {
            user.setUserHandle(HashGenerator.hash());
            this.userRepository.save((Object)user);
        }
        PublicKeyCredentialCreationOptions request = this.publicKeyCredentialCreationOptions(this.relyingParty, user);
        String challenge = request.getChallenge().getBase64Url();
        this.challengeRepository.save((Object)new Challenge(token, challenge));
        return ResponseEntity.status((int)200).body((Object)request);
    }

    @PutMapping(value={"idp/security/webauthn/registration"})
    @Hidden
    public ResponseEntity idpWebAuthn(@RequestBody Map<String, Object> body) {
        try {
            return this.doIdpWebAuthn(body);
        }
        catch (Exception e) {
            return ResponseEntity.status((int)201).body(Collections.singletonMap("location", this.webAuthnSpRedirectUrl));
        }
    }

    private ResponseEntity doIdpWebAuthn(Map<String, Object> body) throws IOException, Base64UrlException, RegistrationFailedException, NoSuchFieldException, IllegalAccessException {
        String token = (String)body.get("token");
        String name = (String)body.get("name");
        Optional optionalUser = this.userRepository.findUserByWebAuthnIdentifier(token);
        if (!optionalUser.isPresent()) {
            return this.return404();
        }
        String credentials = (String)body.get("credentials");
        PublicKeyCredential pkc = PublicKeyCredential.parseRegistrationResponseJson((String)credentials);
        User user = (User)optionalUser.get();
        user.setWebAuthnIdentifier(null);
        PublicKeyCredentialCreationOptions request = this.publicKeyCredentialCreationOptions(this.relyingParty, user);
        Challenge challenge = (Challenge)this.challengeRepository.findByToken(token).orElseThrow(() -> new ForbiddenException("Invalid token: " + token));
        UserController.restoreChallenge((Object)request, (ByteArray)ByteArray.fromBase64Url((String)challenge.getChallenge()));
        this.challengeRepository.delete((Object)challenge);
        RegistrationResult result = this.relyingParty.finishRegistration(FinishRegistrationOptions.builder().request(request).response(pkc).build());
        PublicKeyCredentialDescriptor keyId = result.getKeyId();
        ByteArray publicKeyCose = result.getPublicKeyCose();
        user.addPublicKeyCredential(keyId, publicKeyCose, name);
        this.userRepository.save((Object)user);
        MDCContext.logWithContext((User)user, (String)"add", (String)"webauthn_key", (Log)LOG, (String)("Created publicKeyCredential " + name));
        return ResponseEntity.status((int)201).body(Collections.singletonMap("location", this.webAuthnSpRedirectUrl));
    }

    @PostMapping(value={"idp/security/webauthn/authentication"})
    @Hidden
    public ResponseEntity idpWebAuthnStartAuthentication(@RequestBody Map<String, String> body) {
        String email = body.get("email");
        this.verifyEmails(email);
        Optional optionalUser = this.userRepository.findUserByEmail(this.emailGuessingPreventor.sanitizeEmail(email));
        if (!optionalUser.isPresent()) {
            return this.return404();
        }
        User user = (User)optionalUser.get();
        AssertionRequest request = this.relyingParty.startAssertion(StartAssertionOptions.builder().username(Optional.of(user.getEmail())).build());
        String authenticationRequestId = body.get("authenticationRequestId");
        String challenge = request.getPublicKeyCredentialRequestOptions().getChallenge().getBase64Url();
        this.challengeRepository.findByToken(authenticationRequestId).ifPresent(existingChallenge -> this.challengeRepository.delete(existingChallenge));
        this.challengeRepository.save((Object)new Challenge(authenticationRequestId, challenge, user.getEmail()));
        return ResponseEntity.status((int)200).body((Object)request);
    }

    @PutMapping(value={"idp/security/webauthn/authentication"})
    @Hidden
    public ResponseEntity idpWebAuthnTryAuthentication(HttpServletRequest request, @RequestBody Map<String, Object> body) throws Base64UrlException, IOException, AssertionFailedException, NoSuchFieldException, IllegalAccessException {
        String authenticationRequestId = (String)body.get("authenticationRequestId");
        SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)this.authenticationRequestRepository.findByIdAndNotExpired(authenticationRequestId).orElseThrow(() -> new ExpiredAuthenticationException("Expired SamlAuthenticationRequest"));
        PublicKeyCredential pkc = PublicKeyCredential.parseAssertionResponseJson((String)((String)body.get("credentials")));
        Challenge challenge = (Challenge)this.challengeRepository.findByToken(authenticationRequestId).orElseThrow(() -> new ForbiddenException("Challenge not found"));
        AssertionRequest assertionRequest = this.relyingParty.startAssertion(StartAssertionOptions.builder().username(Optional.of(challenge.getEmail())).build());
        UserController.restoreChallenge((Object)assertionRequest.getPublicKeyCredentialRequestOptions(), (ByteArray)ByteArray.fromBase64Url((String)challenge.getChallenge()));
        AssertionResult result = this.relyingParty.finishAssertion(FinishAssertionOptions.builder().request(assertionRequest).response(pkc).build());
        if (!result.isSuccess()) {
            if (samlAuthenticationRequest.isTestInstance()) {
                String credentialId = this.credentialId(body);
                String url = String.format("%s/credential?id=%s&success=false", this.spBaseUrl, credentialId);
                return ResponseEntity.status((int)201).body(Collections.singletonMap("url", url));
            }
            throw new ForbiddenException("Unsuccessfull SAML authentication ");
        }
        this.challengeRepository.delete((Object)challenge);
        Optional optionalUser = this.findUserStoreLanguage(challenge.getEmail());
        if (!optionalUser.isPresent()) {
            return this.return404();
        }
        User user = (User)optionalUser.get();
        MDCContext.logLoginWithContext((User)user, (String)"webauthn", (boolean)true, (Log)LOG, (String)"Successfully logged in with webauthn", (HttpServletRequest)request);
        if (samlAuthenticationRequest.isTestInstance()) {
            String credentialId = this.credentialId(body);
            String url = String.format("%s/credential?id=%s&success=true", this.spBaseUrl, credentialId);
            return ResponseEntity.status((int)201).body(Collections.singletonMap("url", url));
        }
        return this.doMagicLink(user, samlAuthenticationRequest, true, request);
    }

    private String credentialId(Map<String, Object> body) {
        Map credential = (Map)this.objectMapper.readValue((String)body.get("credentials"), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        return (String)credential.get("id");
    }

    private PublicKeyCredentialCreationOptions publicKeyCredentialCreationOptions(RelyingParty relyingParty, User user) throws Base64UrlException {
        return relyingParty.startRegistration(StartRegistrationOptions.builder().user(UserIdentity.builder().name(user.getEmail()).displayName(String.format("%s %s", user.getGivenName(), user.getFamilyName())).id(ByteArray.fromBase64Url((String)user.getUserHandle())).build()).build());
    }

    private RelyingParty relyingParty(String rpId, String rpOrigin) {
        RelyingPartyIdentity rpIdentity = RelyingPartyIdentity.builder().id(rpId).name("eduID").build();
        return RelyingParty.builder().identity(rpIdentity).credentialRepository((CredentialRepository)this.userCredentialRepository).origins(Collections.singleton(rpOrigin)).build();
    }

    protected static void restoreChallenge(Object challengeContainer, ByteArray challenge) throws NoSuchFieldException, IllegalAccessException {
        Field challengeField = challengeContainer.getClass().getDeclaredField("challenge");
        challengeField.setAccessible(true);
        challengeField.set(challengeContainer, challenge);
    }

    @GetMapping(value={"/sp/personal"})
    @Operation(summary="Get personal data", description="Get personal data for download", responses={@ApiResponse(responseCode="200", description="User tokens", content={@Content(schema=@Schema(implementation=User.class))})})
    public ResponseEntity<String> personal(Authentication authentication) throws JsonProcessingException {
        User user = this.userFromAuthentication(authentication);
        ObjectWriter objectWriter = this.objectMapper.writerWithDefaultPrettyPrinter();
        String userString = this.objectMapper.writeValueAsString((Object)user);
        Map map = (Map)this.objectMapper.readValue(userString, Map.class);
        map.remove("password");
        map.remove("surfSecureId");
        return ResponseEntity.ok().contentType(MediaType.APPLICATION_JSON).body((Object)objectWriter.writeValueAsString((Object)map));
    }

    @GetMapping(value={"/sp/logout"})
    @Operation(summary="Logout", description="Logout the current logged in user")
    public ResponseEntity<StatusResponse> logout(HttpServletRequest request, Authentication authentication) {
        User user = this.userFromAuthentication(authentication);
        MDCContext.logWithContext((User)user, (String)"logout", (String)"user", (Log)LOG, (String)"Logout");
        return this.doLogout(request);
    }

    @DeleteMapping(value={"/sp/delete"})
    @Operation(summary="Delete", description="Delete the current logged in user")
    public ResponseEntity<StatusResponse> deleteUser(Authentication authentication, HttpServletRequest request) {
        User user = this.userFromAuthentication(authentication);
        this.userRepository.delete((Object)user);
        MDCContext.logWithContext((User)user, (String)"delete", (String)"account", (Log)LOG, (String)"Delete account");
        return this.doLogout(request);
    }

    @Operation(summary="Create verification control code password link", description="Create a verification control code which users can use to prove their identity at the Service Desk. The\ncode is also send by email to the user. The required field are firstName,  lastName and dayOfBirth.\nThere are no input validations, if the user's dayOfBirth can not be parsed, then this is solved in\nthe approval proces in the Serivce Desk\n")
    @PostMapping(value={"sp/control-code"})
    public ResponseEntity<ControlCode> createUserControlCode(Authentication authentication, @RequestBody ControlCode controlCode) {
        User user = this.userFromAuthentication(authentication);
        if (!this.serviceDeskActive) {
            throw new ForbiddenException("ServiceDesk is not active. Foul play by " + user.getEmail());
        }
        Instant nowInstant = new Date().toInstant();
        List<LinkedAccount> linkedAccounts = user.getLinkedAccounts().stream().filter(linkedAccount -> linkedAccount.getExpiresAt().toInstant().isAfter(nowInstant)).toList();
        user.setLinkedAccounts(linkedAccounts);
        List<ExternalLinkedAccount> externalLinkedAccounts = user.getExternalLinkedAccounts().stream().filter(linkedAccount -> linkedAccount.getExpiresAt().toInstant().isAfter(nowInstant)).toList();
        user.setExternalLinkedAccounts(externalLinkedAccounts);
        if (!user.getExternalLinkedAccounts().isEmpty() || !user.getLinkedAccounts().isEmpty()) {
            throw new ForbiddenException("User has already linked-accounts: " + user.getEmail());
        }
        String code = VerificationCodeGenerator.generateControlCode();
        while (this.userRepository.findByControlCode_Code(code).isPresent()) {
            code = VerificationCodeGenerator.generateControlCode();
        }
        controlCode.setCode(code);
        controlCode.setCreatedAt(System.currentTimeMillis());
        LOG.info((Object)String.format("User %s updated with controlCode %s", user.getEmail(), controlCode));
        user.setControlCode(controlCode);
        this.userRepository.save((Object)user);
        this.mailBox.sendServiceDeskControlCode(user, controlCode);
        return ResponseEntity.ok((Object)controlCode);
    }

    @Operation(summary="Delete existing verification control code", description="Delete an existing verification control code for a user\n")
    @DeleteMapping(value={"sp/control-code"})
    public ResponseEntity<UserResponse> deleteUserControlCode(Authentication authentication) {
        User user = this.userFromAuthentication(authentication);
        user.setControlCode(null);
        this.userRepository.save((Object)user);
        LOG.info((Object)String.format("User %s deleted controlCode", user.getEmail()));
        return this.userResponseRememberMe(user);
    }

    private ResponseEntity<StatusResponse> doLogout(HttpServletRequest request) {
        HttpSession session = request.getSession();
        session.invalidate();
        SecurityContextHolder.getContext().setAuthentication(null);
        SecurityContextHolder.clearContext();
        return ResponseEntity.ok((Object)new StatusResponse(HttpStatus.OK.value()));
    }

    private ResponseEntity doMagicLink(User user, SamlAuthenticationRequest samlAuthenticationRequest, boolean passwordOrWebAuthnFlow, HttpServletRequest request) {
        samlAuthenticationRequest.setHash(HashGenerator.hash());
        samlAuthenticationRequest.setUserId(user.getId());
        samlAuthenticationRequest.setPasswordOrWebAuthnFlow(passwordOrWebAuthnFlow);
        if (this.featureDefaultRememberMe) {
            samlAuthenticationRequest.setRememberMe(true);
            samlAuthenticationRequest.setRememberMeValue(UUID.randomUUID().toString());
        }
        this.authenticationRequestRepository.save((Object)samlAuthenticationRequest);
        String serviceName = this.manage.getServiceName(request, samlAuthenticationRequest);
        if (passwordOrWebAuthnFlow) {
            LOG.debug((Object)String.format("Returning passwordOrWebAuthnFlow magic link for existing user %s", user.getUsername()));
            return ResponseEntity.status((int)201).body(Collections.singletonMap("url", this.magicLinkUrl + "?h=" + samlAuthenticationRequest.getHash()));
        }
        if (user.isNewUser()) {
            this.sendAccountVerificationMail(samlAuthenticationRequest, user);
        } else {
            LOG.debug((Object)"Sending magic link email for existing user");
            this.mailBox.sendMagicLink(user, samlAuthenticationRequest.getHash(), serviceName);
        }
        return ResponseEntity.status((int)201).body(Collections.singletonMap("result", "ok"));
    }

    private Optional<User> findUserStoreLanguage(String email) {
        Optional optionalUser = this.userRepository.findUserByEmail(this.emailGuessingPreventor.sanitizeEmail(email));
        optionalUser.ifPresent(user -> {
            String preferredLanguage = user.getPreferredLanguage();
            String language = LocaleContextHolder.getLocale().getLanguage();
            if (!StringUtils.hasText((String)preferredLanguage) || !preferredLanguage.equals(language)) {
                user.setPreferredLanguage(language);
                this.userRepository.save(user);
            }
        });
        return optionalUser;
    }

    private void verifyEmails(String email) {
        this.emailDomainGuard.enforceIsAllowed(email);
        this.emailGuessingPreventor.potentialUserEmailGuess();
        this.disposableEmailProviders.verifyDisposableEmailProviders(email);
    }

    private ResponseEntity return404() {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body(Collections.singletonMap("status", HttpStatus.NOT_FOUND.value()));
    }

    @Generated
    public UserRepository getUserRepository() {
        return this.userRepository;
    }

    @Generated
    public Manage getManage() {
        return this.manage;
    }
}

