/*
 * Decompiled with CFR 0.152.
 */
package myconext.manage;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import myconext.model.IdentityProvider;
import myconext.model.RemoteProvider;
import myconext.model.SamlAuthenticationRequest;
import myconext.model.ServiceProvider;
import myconext.security.CookieResolver;
import org.springframework.util.StringUtils;

public interface Manage {
    public Optional<ServiceProvider> findServiceProviderByEntityId(String var1);

    public Set<String> getDomainNames();

    public Optional<IdentityProvider> findIdentityProviderByDomainName(String var1);

    public Optional<IdentityProvider> findIdentityProviderByBrinCode(String var1);

    public Optional<IdentityProvider> findIdentityProviderByInstitutionGUID(String var1);

    default public String getServiceName(HttpServletRequest request, SamlAuthenticationRequest samlAuthenticationRequest) {
        String lang = CookieResolver.cookieByName((HttpServletRequest)request, (String)"lang").map(Cookie::getValue).orElse("en");
        String requesterEntityId = samlAuthenticationRequest.getRequesterEntityId();
        Optional optionalServiceProvider = this.findServiceProviderByEntityId(requesterEntityId);
        return optionalServiceProvider.map(serviceProvider -> lang.equals("en") ? serviceProvider.getName() : serviceProvider.getNameNl()).orElse(requesterEntityId);
    }

    default public Map<String, IdentityProvider> mergeByDomainNames(List<Map<String, Object>> manageIdentityProviders) {
        return ((Map)manageIdentityProviders.stream().reduce(new HashMap(), (acc, map) -> {
            Map providerMap = this.identityProvider(map);
            acc.putAll(providerMap);
            return acc;
        })).entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> (IdentityProvider)e.getValue()));
    }

    default public String entityId(Map<String, Object> map) {
        Map data = (Map)map.get("data");
        return (String)data.get("entityid");
    }

    default public ServiceProvider serviceProvider(Map<String, Object> map) {
        RemoteProvider remoteProvider = this.remoteProvider(map);
        return new ServiceProvider(remoteProvider, (String)this.metaDataFields(map).get("coin:application_url"));
    }

    default public Map<String, String> metaDataFields(Map<String, Object> map) {
        Map data = (Map)map.get("data");
        return (Map)data.get("metaDataFields");
    }

    default public RemoteProvider remoteProvider(Map<String, Object> map) {
        Map data = (Map)map.get("data");
        String entityId = (String)data.get("entityid");
        Map metaDataFields = (Map)data.get("metaDataFields");
        String nameEn = (String)metaDataFields.get("name:en");
        String nameNl = (String)metaDataFields.get("name:nl");
        return new RemoteProvider(entityId, StringUtils.hasText((String)nameEn) ? nameEn : (StringUtils.hasText((String)nameNl) ? nameNl : entityId), StringUtils.hasText((String)nameNl) ? nameNl : (StringUtils.hasText((String)nameEn) ? nameEn : entityId), (String)metaDataFields.get("coin:institution_guid"), (String)metaDataFields.get("logo:0:url"));
    }

    default public Map<String, IdentityProvider> identityProvider(Map<String, Object> map) {
        RemoteProvider remoteProvider = this.remoteProvider(map);
        Map metaDataFields = this.metaDataFields(map);
        IdentityProvider identityProvider = new IdentityProvider(remoteProvider, (String)metaDataFields.get("coin:institution_brin"), (String)metaDataFields.get("coin:institution_brin_schac_home"));
        HashMap<String, IdentityProvider> results = new HashMap<String, IdentityProvider>();
        IntStream.range(0, 10).forEach(i -> {
            String scope = (String)metaDataFields.get(String.format("shibmd:scope:%s:allowed", i));
            if (StringUtils.hasText((String)scope)) {
                results.put(scope, identityProvider);
            }
        });
        return results;
    }
}

