/*
 * Decompiled with CFR 0.152.
 */
package myconext.manage;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import myconext.manage.Manage;
import myconext.model.IdentityProvider;
import myconext.model.ServiceProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RemoteManage
implements Manage {
    private static final Log LOG = LogFactory.getLog(RemoteManage.class);
    private final RestTemplate restTemplate = new RestTemplate();
    private final String manageBaseUrl;
    private Map<String, ServiceProvider> serviceProviders = new HashMap();
    private Map<String, IdentityProvider> identityProviders = new HashMap();
    private final HttpHeaders headers = new HttpHeaders();
    private final Map<String, Object> spRequestAttributes = new HashMap();
    private final Map<String, Object> idpRequestAttributes = new HashMap();
    private final ParameterizedTypeReference<List<Map<String, Object>>> typeReference = new /* Unavailable Anonymous Inner Class!! */;

    public RemoteManage(String userName, String password, String baseUrl) {
        this.restTemplate.getInterceptors().add(new BasicAuthenticationInterceptor(userName, password));
        this.manageBaseUrl = baseUrl;
        this.headers.add("Content-Type", "application/json");
        this.spRequestAttributes.put("REQUESTED_ATTRIBUTES", Arrays.asList("metaDataFields.coin:application_url", "metaDataFields.logo:0:url", "metaDataFields.coin:institution_guid"));
        this.idpRequestAttributes.put("REQUESTED_ATTRIBUTES", Arrays.asList("metaDataFields.coin:institution_brin", "metaDataFields.logo:0:url", "metaDataFields.coin:institution_guid", "metaDataFields.coin:institution_brin_schac_home", "metaDataFields.shibmd:scope:0:allowed", "metaDataFields.shibmd:scope:1:allowed", "metaDataFields.shibmd:scope:2:allowed", "metaDataFields.shibmd:scope:3:allowed", "metaDataFields.shibmd:scope:4:allowed", "metaDataFields.shibmd:scope:5:allowed", "metaDataFields.shibmd:scope:6:allowed", "metaDataFields.shibmd:scope:7:allowed", "metaDataFields.shibmd:scope:8:allowed", "metaDataFields.shibmd:scope:9:allowed"));
    }

    @Scheduled(initialDelayString="${cron.manage-initial-delay-milliseconds}", fixedRateString="${cron.manage-fixed-rate-milliseconds}")
    public void refresh() {
        long start = System.currentTimeMillis();
        LOG.info((Object)("Starting to refresh metadata from " + this.manageBaseUrl));
        this.doRefreshServiceProviders(Optional.empty());
        this.doRefreshIdentityProviders();
        LOG.info((Object)String.format("Refreshed %s services and %s scoped IdP's in %s ms", this.serviceProviders.size(), this.identityProviders.size(), System.currentTimeMillis() - start));
    }

    private void doRefreshIdentityProviders() {
        try {
            HashMap requestBody = new HashMap(this.idpRequestAttributes);
            HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)this.headers);
            List manageIdentityProviders = (List)this.restTemplate.exchange(this.manageBaseUrl + "/manage/api/internal/search/saml20_idp", HttpMethod.POST, requestEntity, this.typeReference, new Object[0]).getBody();
            this.identityProviders = this.mergeByDomainNames(manageIdentityProviders);
        }
        catch (Throwable t) {
            LOG.error((Object)("Error in refreshing metadata from " + this.manageBaseUrl), t);
        }
    }

    private void doRefreshServiceProviders(Optional<String> optionalEntityId) {
        try {
            HashMap requestBody = new HashMap(this.spRequestAttributes);
            optionalEntityId.ifPresent(s -> requestBody.put("entityid", s));
            HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)this.headers);
            Map newServiceProviders = this.exchangeAndParse(requestEntity, "saml20_sp");
            Map relyingParties = this.exchangeAndParse(requestEntity, "oidc10_rp");
            newServiceProviders.putAll(relyingParties);
            if (optionalEntityId.isPresent()) {
                this.serviceProviders.putAll(newServiceProviders);
            } else {
                this.serviceProviders = newServiceProviders;
            }
        }
        catch (Throwable t) {
            LOG.error((Object)("Error in refreshing metadata from " + this.manageBaseUrl), t);
        }
    }

    private Map<String, ServiceProvider> exchangeAndParse(HttpEntity<Map<String, Object>> requestEntity, String entityType) {
        return ((List)this.restTemplate.exchange(this.manageBaseUrl + "/manage/api/internal/search/" + entityType, HttpMethod.POST, requestEntity, this.typeReference, new Object[0]).getBody()).stream().collect(Collectors.toMap(arg_0 -> ((RemoteManage)this).entityId(arg_0), arg_0 -> ((RemoteManage)this).serviceProvider(arg_0)));
    }

    public Optional<ServiceProvider> findServiceProviderByEntityId(String entityId) {
        Optional<ServiceProvider> optionalServiceProvider;
        if (this.serviceProviders.isEmpty()) {
            LOG.info((Object)"Refreshing metadata as the current collection is empty");
            this.doRefreshServiceProviders(Optional.empty());
        }
        if ((optionalServiceProvider = Optional.ofNullable((ServiceProvider)this.serviceProviders.get(entityId))).isEmpty()) {
            LOG.info((Object)("Refreshing metadata because entityID " + entityId + " not in present collection"));
            this.doRefreshServiceProviders(Optional.of(entityId));
            return Optional.ofNullable((ServiceProvider)this.serviceProviders.get(entityId));
        }
        return optionalServiceProvider;
    }

    public Set<String> getDomainNames() {
        if (this.identityProviders.isEmpty()) {
            LOG.info((Object)"Refreshing metadata as the current collection is empty");
            this.doRefreshIdentityProviders();
        }
        return this.identityProviders.keySet();
    }

    public Optional<IdentityProvider> findIdentityProviderByDomainName(String domainName) {
        if (this.identityProviders.isEmpty()) {
            LOG.info((Object)"Refreshing metadata as the current collection is empty");
            this.doRefreshIdentityProviders();
        }
        return Optional.ofNullable((IdentityProvider)this.identityProviders.get(domainName));
    }

    public Optional<IdentityProvider> findIdentityProviderByBrinCode(String brinCode) {
        return this.searchIdentityProvider("metaDataFields.coin:institution_brin", brinCode);
    }

    public Optional<IdentityProvider> findIdentityProviderByInstitutionGUID(String institutionGUID) {
        return this.searchIdentityProvider("metaDataFields.coin:institution_guid", institutionGUID);
    }

    private Optional<IdentityProvider> searchIdentityProvider(String metaDataField, String metaDataValue) {
        Map<String, List<String>> requestBody = Map.of(metaDataField, metaDataValue, "REQUESTED_ATTRIBUTES", Arrays.asList("metaDataFields.coin:institution_brin", "metaDataFields.logo:0:url", "metaDataFields.coin:institution_guid", "metaDataFields.coin:institution_brin_schac_home", "metaDataFields.shibmd:scope:0:allowed"));
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)this.headers);
        return ((List)this.restTemplate.exchange(this.manageBaseUrl + "/manage/api/internal/search/saml20_idp", HttpMethod.POST, requestEntity, this.typeReference, new Object[0]).getBody()).stream().map(m -> new IdentityProvider(this.remoteProvider(m), (String)this.metaDataFields(m).get("coin:institution_brin"), (String)this.metaDataFields(m).get("coin:institution_brin_schac_home"))).findFirst();
    }
}

