/*
 * Decompiled with CFR 0.152.
 */
package myconext.api;

import io.swagger.v3.oas.annotations.Operation;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.Date;
import lombok.Generated;
import myconext.exceptions.ForbiddenException;
import myconext.exceptions.RemoteException;
import myconext.exceptions.UserNotFoundException;
import myconext.model.ControlCode;
import myconext.model.ExternalLinkedAccount;
import myconext.model.ExternalUser;
import myconext.model.StatusResponse;
import myconext.model.User;
import myconext.repository.ExternalUserRepository;
import myconext.repository.UserRepository;
import myconext.verify.AttributeMapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/myconext/api/servicedesk"})
public class ServiceDeskController {
    private static final Log LOG = LogFactory.getLog(ServiceDeskController.class);
    private final UserRepository userRepository;
    private final ExternalUserRepository externalUserRepository;
    private final AttributeMapper attributeMapper;

    public ServiceDeskController(UserRepository userRepository, ExternalUserRepository externalUserRepository, AttributeMapper attributeMapper) {
        this.userRepository = userRepository;
        this.externalUserRepository = externalUserRepository;
        this.attributeMapper = attributeMapper;
    }

    @GetMapping(value={"/me"})
    public ResponseEntity<ExternalUser> me(Authentication authentication) {
        String userId = ((ExternalUser)authentication.getPrincipal()).getId();
        ExternalUser user = (ExternalUser)this.externalUserRepository.findById((Object)userId).orElseThrow(() -> new UserNotFoundException(userId));
        return ResponseEntity.ok((Object)user);
    }

    @GetMapping(value={"/logout"})
    @Operation(summary="Logout", description="Logout the current logged in user")
    public ResponseEntity<StatusResponse> logout(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
        SecurityContextHolder.getContext().setAuthentication(null);
        SecurityContextHolder.clearContext();
        return ResponseEntity.ok((Object)new StatusResponse(HttpStatus.OK.value()));
    }

    @GetMapping(value={"/user/{code}"})
    public ResponseEntity<ControlCode> getUserControlCode(@PathVariable(value="code") String code) {
        LOG.debug((Object)("Fetching user with controlCode: " + code));
        User user = (User)this.userRepository.findByControlCode_Code(code).orElseThrow(() -> new UserNotFoundException(String.format("No user found with controlCode %s", code)));
        ControlCode controlCode = user.getControlCode();
        controlCode.setUserUid(user.getUid());
        return ResponseEntity.ok((Object)controlCode);
    }

    @GetMapping(value={"/validate"})
    public ResponseEntity<Boolean> validateDate(@RequestParam(value="dayOfBirth") String dayOfBirth) {
        LOG.debug((Object)("Validate date: " + dayOfBirth));
        Date date = AttributeMapper.parseDate((String)dayOfBirth);
        return ResponseEntity.ok((Object)(date != null ? 1 : 0));
    }

    @PutMapping(value={"/approve"})
    public ResponseEntity<ExternalLinkedAccount> convertUserControlCode(Authentication authentication, @RequestBody ControlCode controlCode) {
        try {
            return this.doConvertUserControlCode(authentication, controlCode);
        }
        catch (RuntimeException e) {
            ResponseStatus annotation = (ResponseStatus)AnnotationUtils.getAnnotation(e.getClass(), ResponseStatus.class);
            HttpStatus status = annotation != null ? annotation.value() : HttpStatus.BAD_REQUEST;
            throw new RemoteException(status, e.getMessage(), (Throwable)e);
        }
    }

    private ResponseEntity<ExternalLinkedAccount> doConvertUserControlCode(Authentication authentication, ControlCode controlCode) throws RuntimeException {
        String code = controlCode.getCode();
        User user = (User)this.userRepository.findByControlCode_Code(code).orElseThrow(() -> new UserNotFoundException(String.format("No user found with controlCode %s", code)));
        if (!user.getExternalLinkedAccounts().isEmpty() || !user.getLinkedAccounts().isEmpty()) {
            throw new ForbiddenException("User has already linked-accounts: " + user.getEmail());
        }
        if (!user.getUid().equals(controlCode.getUserUid())) {
            throw new ForbiddenException("User UID's do not match");
        }
        String userUid = ((ExternalUser)authentication.getPrincipal()).getUid();
        ExternalUser serviceDeskMember = (ExternalUser)this.externalUserRepository.findUserByUid(userUid).orElseThrow(() -> new UserNotFoundException(userUid));
        LOG.info((Object)String.format("Adding external linked account for service desk for user %s by user %s", user.getEmail(), serviceDeskMember.getEmail()));
        ExternalLinkedAccount externalLinkedAccount = this.attributeMapper.createFromControlCode(controlCode);
        user.getExternalLinkedAccounts().add(externalLinkedAccount);
        user.setControlCode(null);
        this.userRepository.save((Object)user);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)externalLinkedAccount);
    }

    @Generated
    public UserRepository getUserRepository() {
        return this.userRepository;
    }
}

