/*
 * Decompiled with CFR 0.152.
 */
package myconext.repository;

import com.mongodb.client.AggregateIterable;
import java.util.List;
import myconext.model.IdpScoping;
import org.bson.Document;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class MetricsRepository {
    private final MongoTemplate mongoTemplate;

    public MetricsRepository(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    public Integer countTotalLinkedAccounts() {
        return this.doInCollection("users", List.of("{ \"$unwind\": \"$linkedAccounts\" }", "{ \"$count\": \"totalLinkedAccounts\" }"), "totalLinkedAccounts");
    }

    public Integer countTotalExternalLinkedAccountsByType(IdpScoping idpScoping) {
        return this.doInCollection("users", List.of("{ \"$unwind\": \"$externalLinkedAccounts\" }", "{ \"$match\": { \"externalLinkedAccounts.idpScoping\": \"" + idpScoping.name() + "\" } },", "{ \"$count\": \"countExternalLinkedAccounts\" }"), "countExternalLinkedAccounts");
    }

    public Integer countTotalRegisteredApps() {
        return this.doInCollection("users", List.of("{ \"$unwind\": \"$eduIDS\" }", "{ \"$unwind\": \"$eduIDS.services\" }", "{ \"$group\": { \"_id\": \"$eduIDS.services.entityId\" } },", "{ \"$count\": \"countTotalRegisteredApps\" }"), "countTotalRegisteredApps");
    }

    private Integer doInCollection(String collectionName, List<String> pipeLines, String resultKeyWord) {
        return (Integer)this.mongoTemplate.execute(collectionName, collection -> {
            List<Document> documents = pipeLines.stream().map(Document::parse).toList();
            AggregateIterable result = collection.aggregate(documents);
            Document doc = (Document)result.first();
            return doc != null ? doc.getInteger((Object)resultKeyWord) : 0;
        });
    }
}

