/*
 * Decompiled with CFR 0.152.
 */
package myconext.mail;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import myconext.mail.MailBox;
import myconext.repository.EmailsSendRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.mail.MailProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.mail.javamail.JavaMailSender;

@Configuration
@EnableConfigurationProperties(value={MailProperties.class})
public class MailConfiguration {
    @Value(value="${email.from_deprovisioning}")
    private String emailFromDeprovisioning;
    @Value(value="${email.from_code}")
    private String emailFromCode;
    @Value(value="${email.from_app_nudge}")
    private String emailFromAppNudge;
    @Value(value="${email.from_new_device}")
    private String emailFromNewDevice;
    @Value(value="${email.error}")
    private String errorEmail;
    @Value(value="${email.my-surfconext-url}")
    private String mySURFconextURL;
    @Value(value="${email.idp-surfconext-url}")
    private String loginSURFconextURL;
    @Value(value="${email.mail-templates-directory}")
    private Resource mailTemplatesDirectory;
    @Value(value="${email_spam_threshold_seconds}")
    private long emailSpamThresholdSeconds;
    @Autowired
    private JavaMailSender mailSender;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private EmailsSendRepository emailsSendRepository;

    @Bean
    public MailBox mailSenderProd() throws IOException {
        return new MailBox(this.mailSender, this.emailFromDeprovisioning, this.emailFromCode, this.emailFromAppNudge, this.emailFromNewDevice, this.errorEmail, this.mySURFconextURL, this.loginSURFconextURL, this.objectMapper, this.mailTemplatesDirectory, this.emailsSendRepository, this.emailSpamThresholdSeconds);
    }
}

