/*
 * Decompiled with CFR 0.152.
 */
package myconext.security;

import javax.servlet.Filter;
import myconext.config.BeanConfig;
import org.springframework.context.ApplicationContext;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.saml.provider.SamlServerConfiguration;
import org.springframework.security.saml.provider.identity.config.SamlIdentityProviderSecurityDsl;
import org.springframework.security.web.context.SecurityContextPersistenceFilter;

public class GuestIdentityProviderDsl
extends SamlIdentityProviderSecurityDsl {
    private final BeanConfig beanConfig;

    GuestIdentityProviderDsl(BeanConfig beanConfig) {
        this.beanConfig = beanConfig;
    }

    public void configure(HttpSecurity http) throws Exception {
        super.configure(http);
        ApplicationContext context = (ApplicationContext)http.getSharedObject(ApplicationContext.class);
        SamlServerConfiguration serverConfig = (SamlServerConfiguration)context.getBean("idpSamlServerConfiguration", SamlServerConfiguration.class);
        Filter samlConfigurationFilter = this.beanConfig.samlConfigurationFilter(serverConfig);
        Filter metadataFilter = this.beanConfig.idpMetadataFilter();
        Filter idpAuthnRequestFilter = this.beanConfig.idpAuthnRequestFilter();
        http.addFilterAfter(samlConfigurationFilter, SecurityContextPersistenceFilter.class).addFilterAfter(metadataFilter, samlConfigurationFilter.getClass()).addFilterAfter(idpAuthnRequestFilter, metadataFilter.getClass());
    }
}

