/*
 * Decompiled with CFR 0.152.
 */
package playground.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.util.OrderedJSONObject;
import com.nimbusds.openid.connect.sdk.ClaimsRequest;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;
import playground.api.URLSupport;

@RestController
@RequestMapping(produces={"application/json;charset=UTF-8"})
public class Oidc
implements URLSupport {
    static TypeReference<Map<String, Object>> mapTypeReference = new /* Unavailable Anonymous Inner Class!! */;
    static ParameterizedTypeReference<Map<String, Object>> mapResponseType = new /* Unavailable Anonymous Inner Class!! */;
    @Value(value="${oidc.discovery_endpoint}")
    private Resource discoveryEndpoint;
    @Value(value="${oidc.client_id}")
    private String clientId;
    @Value(value="${oidc.secret}")
    private String secret;
    @Value(value="${oidc.redirect_uri}")
    private String redirectUri;
    @Autowired
    private ObjectMapper objectMapper;
    private RestTemplate restTemplate = new RestTemplate();

    @GetMapping(value={"/discovery"})
    public Map<String, Object> discovery() throws IOException {
        return (Map)this.objectMapper.readValue(this.discoveryEndpoint.getInputStream(), mapTypeReference);
    }

    @PostMapping(value={"/authorization_code", "/implicit"})
    public Map<String, String> authorize(@RequestBody Map<String, Object> body) throws URISyntaxException {
        List requestedClaims;
        HashMap<String, String> parameters = new HashMap<String, String>();
        ResponseType responseType = new ResponseType(((String)body.get("response_type")).split(" "));
        parameters.put("response_type", responseType.toString());
        List scopes = (List)body.get("scope");
        if (!CollectionUtils.isEmpty((Collection)scopes)) {
            parameters.put("scope", String.join((CharSequence)" ", scopes));
        }
        if (!responseType.impliesCodeFlow()) {
            parameters.put("response_mode", (String)body.getOrDefault("response_mode", "fragment"));
        }
        if (!CollectionUtils.isEmpty((Collection)(requestedClaims = (List)body.get("claims")))) {
            parameters.put("claims", this.claims(requestedClaims));
        }
        parameters.put("client_id", (String)body.getOrDefault("client_id", this.clientId));
        parameters.put("redirect_uri", this.redirectUri);
        parameters.put("nonce", (String)body.get("nonce"));
        parameters.put("state", (String)body.get("state"));
        parameters.put("code_challenge", (String)body.get("code_challenge"));
        parameters.put("code_challenge_method", (String)body.get("code_challenge_method"));
        parameters.put("acr_values", (String)body.get("acr_values"));
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)((String)body.get("authorization_endpoint")));
        parameters.forEach((key, value) -> {
            if (StringUtils.hasText((String)value)) {
                builder.queryParam(key, new Object[]{this.encode(value)});
            }
        });
        return Collections.singletonMap("url", builder.build().toString());
    }

    @PostMapping(value={"/token"})
    public Map<String, Object> token(@RequestBody Map<String, Object> body) throws URISyntaxException {
        body.put("redirect_uri", this.redirectUri);
        return this.doToken(body, "authorization_code");
    }

    @PostMapping(value={"/client_credentials"})
    public Map<String, Object> clientCredentials(@RequestBody Map<String, Object> body) throws URISyntaxException {
        return this.doToken(body, "client_credentials");
    }

    @PostMapping(value={"/refresh_token"})
    public Map<String, Object> refreshToken(@RequestBody Map<String, Object> body) throws URISyntaxException {
        return this.doToken(body, "refresh_token");
    }

    @PostMapping(value={"/introspect"})
    public Map<String, Object> introspect(@RequestBody Map<String, Object> body) throws URISyntaxException {
        return this.doPost(body, Collections.singletonMap("token", (String)body.get("token")), (String)body.get("introspect_endpoint"));
    }

    @PostMapping(value={"/userinfo"})
    public Map<String, Object> userinfo(@RequestBody Map<String, Object> body) throws URISyntaxException {
        return this.doPost(body, Collections.singletonMap("token", (String)body.get("token")), (String)body.get("userinfo_endpoint"));
    }

    @GetMapping(value={"/proxy"})
    public Map proxy(@RequestParam(value="uri") String uri) {
        return (Map)this.restTemplate.getForEntity(uri, Map.class, new Object[0]).getBody();
    }

    @GetMapping(value={"/decode_jwt"})
    public String decodeJwtToken(@RequestParam(value="jwt") String jwt) throws ParseException {
        SignedJWT signedJWT = SignedJWT.parse((String)jwt);
        OrderedJSONObject result = new OrderedJSONObject();
        result.put((Object)"header", (Object)signedJWT.getHeader().toJSONObject());
        result.put((Object)"payload", (Object)signedJWT.getJWTClaimsSet().toJSONObject());
        return result.toJSONString();
    }

    private Map<String, Object> doToken(Map<String, Object> body, String grantType) throws URISyntaxException {
        List scopes;
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("grant_type", grantType);
        if (body.containsKey("scope") && !CollectionUtils.isEmpty((Collection)(scopes = (List)body.get("scope")))) {
            requestBody.put("scope", String.join((CharSequence)" ", (List)body.get("scope")));
        }
        return this.doPost(body, requestBody, (String)body.get("token_endpoint"));
    }

    private Map<String, Object> doPost(Map<String, Object> body, Map<String, String> requestBody, String endpoint) throws URISyntaxException {
        String clientIdToUse = (String)body.getOrDefault("client_id", this.clientId);
        String secretToUse = (String)body.getOrDefault("client_secret", this.secret);
        RequestEntity.BodyBuilder builder = ((RequestEntity.BodyBuilder)RequestEntity.post((URI)new URI(endpoint)).accept(new MediaType[]{MediaType.APPLICATION_JSON, MediaType.APPLICATION_JSON_UTF8})).contentType(MediaType.APPLICATION_FORM_URLENCODED);
        String authMethod = (String)body.getOrDefault("token_endpoint_auth_method", "client_secret_basic");
        if (authMethod.equals("client_secret_post")) {
            builder.header("Authorization", new String[]{new String(Base64.getEncoder().encode(String.format("%s:%s", clientIdToUse, secretToUse).getBytes()))});
        } else {
            requestBody.put("client_id", clientIdToUse);
            requestBody.put("client_secret", secretToUse);
        }
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        requestBody.forEach((k, v) -> form.set(k, v));
        return (Map)this.restTemplate.exchange(builder.body((Object)form), mapResponseType).getBody();
    }

    private String claims(List<String> requestedClaims) {
        ClaimsRequest claimsRequest = new ClaimsRequest();
        requestedClaims.forEach(arg_0 -> ((ClaimsRequest)claimsRequest).addIDTokenClaim(arg_0));
        return claimsRequest.toString();
    }
}

