/*
 * Decompiled with CFR 0.152.
 */
package playground.web;

import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;

@RestController
public class ErrorController
implements org.springframework.boot.web.servlet.error.ErrorController {
    private static final Log LOG = LogFactory.getLog(ErrorController.class);
    private ErrorAttributes errorAttributes;

    @Autowired
    public ErrorController(ErrorAttributes errorAttributes) {
        this.errorAttributes = errorAttributes;
    }

    public String getErrorPath() {
        return "/error";
    }

    @RequestMapping(value={"/error"})
    public ResponseEntity error(HttpServletRequest request) throws UnsupportedEncodingException, URISyntaxException {
        HttpStatus statusCode;
        ServletWebRequest webRequest = new ServletWebRequest(request);
        Map result = this.errorAttributes.getErrorAttributes((WebRequest)webRequest, false);
        LOG.error((Object)("Error has occurred: " + result));
        Throwable error = this.errorAttributes.getError((WebRequest)webRequest);
        boolean status = result.containsKey("status") && !result.get("status").equals(999);
        HttpStatus httpStatus = statusCode = status ? HttpStatus.resolve((int)((Integer)result.get("status"))) : HttpStatus.BAD_REQUEST;
        if (error != null) {
            LOG.error((Object)"Exception in /error: ", error);
            result.put("details", error.getMessage());
            ResponseStatus annotation = (ResponseStatus)AnnotationUtils.getAnnotation(error.getClass(), ResponseStatus.class);
            statusCode = annotation != null ? annotation.value() : statusCode;
        }
        HttpHeaders headers = new HttpHeaders();
        return new ResponseEntity((Object)result, (MultiValueMap)headers, statusCode);
    }
}

