/*
 * Decompiled with CFR 0.152.
 */
package playground.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.pkce.CodeChallenge;
import com.nimbusds.oauth2.sdk.pkce.CodeChallengeMethod;
import com.nimbusds.oauth2.sdk.pkce.CodeVerifier;
import com.nimbusds.oauth2.sdk.util.OrderedJSONObject;
import com.nimbusds.openid.connect.sdk.ClaimsRequest;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;
import playground.api.URLSupport;

@RestController
@RequestMapping(produces={"application/json;charset=UTF-8"})
public class Oidc
implements URLSupport {
    static TypeReference<Map<String, Object>> mapTypeReference = new /* Unavailable Anonymous Inner Class!! */;
    static ParameterizedTypeReference<LinkedHashMap<String, Object>> mapResponseType = new /* Unavailable Anonymous Inner Class!! */;
    private Pattern uuidPattern = Pattern.compile("([a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}){1}");
    @Value(value="${oidc.discovery_endpoint}")
    private Resource discoveryEndpoint;
    @Value(value="${oidc.client_id}")
    private String clientId;
    @Value(value="${oidc.secret}")
    private String secret;
    @Value(value="${oidc.resource_server_id}")
    private String resourceServerId;
    @Value(value="${oidc.resource_server_secret}")
    private String resourceServerSecret;
    @Value(value="${oidc.redirect_uri}")
    private String redirectUri;
    @Value(value="${oidc.redirect_uri_form_post}")
    private String redirectUriFormPost;
    @Value(value="${oidc.client_redirect_uri}")
    private String clientRedirectUri;
    @Autowired
    private ObjectMapper objectMapper;
    private RestTemplate restTemplate = new RestTemplate();
    private String rsaKeyId = "play_key_id";
    private RSAKey rsaKey;

    public Oidc() throws NoSuchProviderException, NoSuchAlgorithmException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.rsaKey = this.generateRsaKey();
    }

    @GetMapping(value={"/discovery"})
    public Map<String, Object> discovery() throws IOException {
        return (Map)this.objectMapper.readValue(this.discoveryEndpoint.getInputStream(), mapTypeReference);
    }

    @PostMapping(value={"/code_challenge"})
    public Map<String, Object> codeChallenge(@RequestBody Map<String, Object> body) {
        this.sanitizeMap(body);
        CodeChallengeMethod method = CodeChallengeMethod.parse((String)((String)body.getOrDefault("codeChallengeMethod", CodeChallengeMethod.S256.getValue())));
        CodeVerifier codeVerifier = new CodeVerifier();
        CodeChallenge codeChallenge = CodeChallenge.compute((CodeChallengeMethod)method, (CodeVerifier)new CodeVerifier((String)body.getOrDefault("codeVerifier", codeVerifier.getValue())));
        body.put("codeChallenge", codeChallenge.getValue());
        body.put("codeVerifier", codeVerifier.getValue());
        body.put("codeChallengeMethod", method.getValue());
        return body;
    }

    @PostMapping(value={"/redirect"}, consumes={"application/x-www-form-urlencoded"})
    public void redirectFormPost(@RequestParam MultiValueMap<String, String> form, HttpServletResponse response) throws IOException {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)this.clientRedirectUri);
        form.forEach((key, value) -> {
            if (!CollectionUtils.isEmpty((Collection)value)) {
                builder.queryParam(key, new Object[]{this.encode((String)value.get(0))});
            }
        });
        response.sendRedirect(builder.build().toUriString());
    }

    @PostMapping(value={"/authorization_code", "/implicit"})
    public Map<String, String> authorize(@RequestBody Map<String, Object> body) throws URISyntaxException, JOSEException {
        List requestedClaims;
        this.sanitizeMap(body);
        HashMap<String, String> parameters = new HashMap<String, String>();
        ResponseType responseType = new ResponseType(((String)body.get("response_type")).split(" "));
        parameters.put("response_type", responseType.toString());
        List scopes = (List)body.get("scope");
        if (!CollectionUtils.isEmpty((Collection)scopes)) {
            parameters.put("scope", String.join((CharSequence)" ", scopes));
        }
        String responseMode = (String)body.getOrDefault("response_mode", "fragment");
        if (!responseType.impliesCodeFlow()) {
            parameters.put("response_mode", responseMode);
        }
        if (!CollectionUtils.isEmpty((Collection)(requestedClaims = (List)body.get("claims")))) {
            parameters.put("claims", this.claims(requestedClaims));
        }
        parameters.put("client_id", (String)body.getOrDefault("client_id", this.clientId));
        if (!responseType.impliesCodeFlow() && responseMode.equals("form_post")) {
            parameters.put("redirect_uri", this.redirectUriFormPost);
        } else {
            parameters.put("redirect_uri", this.redirectUri);
        }
        if (((Boolean)body.getOrDefault("forceAuthentication", false)).booleanValue()) {
            parameters.put("prompt", "login");
        }
        parameters.put("nonce", (String)body.get("nonce"));
        parameters.put("state", (String)body.get("state"));
        if (((Boolean)body.getOrDefault("pkce", false)).booleanValue()) {
            parameters.put("code_challenge", (String)body.get("code_challenge"));
            parameters.put("code_challenge_method", (String)body.get("code_challenge_method"));
        }
        parameters.put("acr_values", (String)body.get("acr_values"));
        if (((Boolean)body.getOrDefault("signedJWT", false)).booleanValue()) {
            parameters.put("request", this.signedJWT(parameters).serialize());
            List<String> toRemove = Arrays.asList("response_mode", "claims", "prompt", "state", "code_challenge", "code_challenge_method", "acr_values");
            parameters.keySet().removeIf(key -> toRemove.contains(key));
        }
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)((String)body.get("authorization_endpoint")));
        parameters.forEach((key, value) -> {
            if (StringUtils.hasText((String)value)) {
                builder.queryParam(key, new Object[]{this.encode(value)});
            }
        });
        return Collections.singletonMap("url", builder.build().toUriString());
    }

    @PostMapping(value={"/token"})
    public Map<String, Object> token(@RequestBody Map<String, Object> body) throws URISyntaxException {
        body.put("redirect_uri", this.redirectUri);
        return this.doToken(body, "authorization_code");
    }

    @PostMapping(value={"/client_credentials"})
    public Map<String, Object> clientCredentials(@RequestBody Map<String, Object> body) throws URISyntaxException {
        return this.doToken(body, "client_credentials");
    }

    @PostMapping(value={"/refresh_token"})
    public Map<String, Object> refreshToken(@RequestBody Map<String, Object> body) throws URISyntaxException {
        return this.doToken(body, "refresh_token");
    }

    @PostMapping(value={"/introspect"})
    public Map<String, Object> introspect(@RequestBody Map<String, Object> body) throws URISyntaxException {
        body.put("client_id", "resource-server-playground-client");
        body.put("client_secret", this.secret);
        return this.doPost(body, Collections.singletonMap("token", (String)body.get("token")), (String)body.get("introspect_endpoint"));
    }

    @PostMapping(value={"/userinfo"})
    public Map<String, Object> userinfo(@RequestBody Map<String, Object> body) throws URISyntaxException {
        String endpoint = (String)body.get("userinfo_endpoint");
        String token = (String)body.get("token");
        RequestEntity.BodyBuilder builder = (RequestEntity.BodyBuilder)((RequestEntity.BodyBuilder)RequestEntity.post((URI)new URI(endpoint)).accept(new MediaType[]{MediaType.APPLICATION_JSON, MediaType.APPLICATION_JSON_UTF8})).contentType(MediaType.APPLICATION_FORM_URLENCODED).header("Authorization", new String[]{"Bearer " + token});
        Map<String, String> requestBody = Collections.singletonMap("access_token", token);
        return this.callPostEndpoint(requestBody, (String)body.get("userinfo_endpoint"), builder);
    }

    @GetMapping(value={"/proxy"})
    public Map proxy(@RequestParam(value="uri") String uri, @RequestParam(value="access_token") String access_token) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", "bearer " + access_token);
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        return (Map)this.restTemplate.exchange(uri, HttpMethod.GET, requestEntity, Map.class, new Object[0]).getBody();
    }

    @GetMapping(value={"/decode_jwt"})
    public String decodeJwtToken(@RequestParam(value="jwt") String jwt) throws ParseException {
        if (this.uuidPattern.matcher(jwt).matches()) {
            return jwt;
        }
        SignedJWT signedJWT = SignedJWT.parse((String)jwt);
        OrderedJSONObject result = new OrderedJSONObject();
        result.put((Object)"header", (Object)signedJWT.getHeader().toJSONObject());
        result.put((Object)"payload", (Object)signedJWT.getJWTClaimsSet().toJSONObject());
        return result.toJSONString();
    }

    @GetMapping(value={"/certs"}, produces={"application/json;charset=UTF-8"})
    public String publishClientJwk() throws NoSuchProviderException, NoSuchAlgorithmException {
        return new JWKSet((JWK)this.rsaKey.toPublicJWK()).toJSONObject().toString();
    }

    private Map<String, Object> doToken(Map<String, Object> body, String grantType) throws URISyntaxException {
        List scopes;
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("grant_type", grantType);
        if (body.containsKey("code")) {
            requestBody.put("code", (String)body.get("code"));
        }
        if (body.containsKey("scope") && !CollectionUtils.isEmpty((Collection)(scopes = (List)body.get("scope")))) {
            requestBody.put("scope", String.join((CharSequence)" ", (List)body.get("scope")));
        }
        if (((Boolean)body.getOrDefault("pkce", false)).booleanValue()) {
            requestBody.put("code_verifier", (String)body.get("code_verifier"));
        }
        return this.doPost(body, requestBody, (String)body.get("token_endpoint"));
    }

    private Map<String, Object> doPost(Map<String, Object> body, Map<String, String> requestBody, String endpoint) throws URISyntaxException {
        this.sanitizeMap(body);
        String clientIdToUse = (String)body.get("client_id");
        clientIdToUse = StringUtils.hasText((String)clientIdToUse) ? clientIdToUse : this.clientId;
        String secretToUse = (String)body.get("client_secret");
        secretToUse = StringUtils.hasText((String)secretToUse) ? secretToUse : this.secret;
        RequestEntity.BodyBuilder builder = ((RequestEntity.BodyBuilder)RequestEntity.post((URI)new URI(endpoint)).accept(new MediaType[]{MediaType.APPLICATION_JSON, MediaType.APPLICATION_JSON_UTF8})).contentType(MediaType.APPLICATION_FORM_URLENCODED);
        String authMethod = (String)body.getOrDefault("token_endpoint_auth_method", "client_secret_basic");
        boolean codeVerifier = requestBody.containsKey("code_verifier");
        if (!codeVerifier) {
            if (authMethod.equals("client_secret_basic")) {
                builder.header("Authorization", new String[]{"Basic " + new String(Base64.getEncoder().encode((clientIdToUse + ":" + secretToUse).getBytes()))});
            } else {
                requestBody.put("client_id", clientIdToUse);
                requestBody.put("client_secret", secretToUse);
            }
        } else {
            requestBody.put("client_id", clientIdToUse);
        }
        return this.callPostEndpoint(requestBody, endpoint, builder);
    }

    private Map<String, Object> callPostEndpoint(Map<String, String> requestBody, String endpoint, RequestEntity.BodyBuilder builder) {
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        requestBody.forEach((k, v) -> form.set(k, v));
        RequestEntity requestEntity = builder.body((Object)form);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("result", this.restTemplate.exchange(requestEntity, mapResponseType).getBody());
        result.put("request_body", this.anonymizeInformation(requestBody));
        result.put("request_url", endpoint);
        result.put("request_headers", this.anonymizeInformation(requestEntity.getHeaders().toSingleValueMap()));
        return result;
    }

    private void sanitizeMap(Map<String, Object> body) {
        body.values().removeIf(val -> {
            if (val == null) {
                return true;
            }
            if (val instanceof List) {
                return CollectionUtils.isEmpty((Collection)((List)val));
            }
            if (val instanceof String) {
                return StringUtils.isEmpty((Object)((String)val));
            }
            return false;
        });
    }

    private Map<String, String> anonymizeInformation(Map<String, String> headers) {
        HashMap<String, String> result = new HashMap<String, String>(headers);
        List<String> sensitiveHeaders = Arrays.asList("client_id", "client_secret", "Authorization");
        sensitiveHeaders.forEach(header -> result.replace((String)header, "XXX"));
        return result;
    }

    private String claims(List<String> requestedClaims) {
        ClaimsRequest claimsRequest = new ClaimsRequest();
        requestedClaims.forEach(arg_0 -> ((ClaimsRequest)claimsRequest).addIDTokenClaim(arg_0));
        return claimsRequest.toString();
    }

    private RSAKey generateRsaKey() throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", "BC");
        kpg.initialize(2048);
        KeyPair keyPair = kpg.generateKeyPair();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        return new RSAKey.Builder(publicKey).privateKey(privateKey).algorithm((Algorithm)JWSAlgorithm.RS256).keyID(this.rsaKeyId).build();
    }

    private SignedJWT signedJWT(Map<String, String> form) throws JOSEException {
        Instant now = Instant.now();
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder().audience("audience").expirationTime(Date.from(now.plus(3600L, ChronoUnit.SECONDS))).jwtID(UUID.randomUUID().toString()).issuer(this.clientId).issueTime(Date.from(now)).subject(this.clientId).notBeforeTime(new Date(System.currentTimeMillis()));
        form.forEach((arg_0, arg_1) -> ((JWTClaimsSet.Builder)builder).claim(arg_0, arg_1));
        JWTClaimsSet claimsSet = builder.build();
        JWSHeader header = new JWSHeader.Builder(JWSAlgorithm.RS256).type(JOSEObjectType.JWT).keyID(this.rsaKeyId).build();
        SignedJWT signedJWT = new SignedJWT(header, claimsSet);
        RSASSASigner jswsSigner = new RSASSASigner(this.rsaKey.toPrivateKey());
        signedJWT.sign((JWSSigner)jswsSigner);
        return signedJWT;
    }
}

