/*
 * Decompiled with CFR 0.152.
 */
package playground.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.ResponseMode;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.pkce.CodeChallenge;
import com.nimbusds.oauth2.sdk.pkce.CodeChallengeMethod;
import com.nimbusds.oauth2.sdk.pkce.CodeVerifier;
import com.nimbusds.oauth2.sdk.util.OrderedJSONObject;
import com.nimbusds.openid.connect.sdk.ClaimsRequest;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;
import playground.api.URLSupport;

@RestController
@RequestMapping(produces={"application/json;charset=UTF-8"})
public class Oidc
implements URLSupport {
    static TypeReference<Map<String, Object>> mapTypeReference = new /* Unavailable Anonymous Inner Class!! */;
    private static ParameterizedTypeReference<LinkedHashMap<String, Object>> mapResponseType = new /* Unavailable Anonymous Inner Class!! */;
    private static final Log LOG = LogFactory.getLog(Oidc.class);
    private Pattern uuidPattern = Pattern.compile("([a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}){1}");
    private String clientId;
    private String secret;
    private String resourceServerId;
    private String resourceServerSecret;
    private String redirectUri;
    private String redirectUriFormPost;
    private String clientRedirectUri;
    private ObjectMapper objectMapper;
    private Resource discoveryEndpoint;
    private RestTemplate restTemplate = new RestTemplate();
    private String rsaKeyId = "play_key_id";
    private RSAKey rsaKey;
    private Map<String, Object> wellKnownConfiguration;

    @Autowired
    public Oidc(@Value(value="${oidc.discovery_endpoint}") Resource discoveryEndpoint, @Value(value="${oidc.client_id}") String clientId, @Value(value="${oidc.secret}") String secret, @Value(value="${oidc.resource_server_id}") String resourceServerId, @Value(value="${oidc.resource_server_secret}") String resourceServerSecret, @Value(value="${oidc.redirect_uri}") String redirectUri, @Value(value="${oidc.redirect_uri_form_post}") String redirectUriFormPost, @Value(value="${oidc.client_redirect_uri}") String clientRedirectUri, ObjectMapper objectMapper) throws NoSuchProviderException, NoSuchAlgorithmException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.clientId = clientId;
        this.secret = secret;
        this.resourceServerId = resourceServerId;
        this.resourceServerSecret = resourceServerSecret;
        this.redirectUri = redirectUri;
        this.redirectUriFormPost = redirectUriFormPost;
        this.clientRedirectUri = clientRedirectUri;
        this.objectMapper = objectMapper;
        this.discoveryEndpoint = discoveryEndpoint;
        this.rsaKey = this.generateRsaKey();
    }

    private Map<String, Object> readWellKnownConfiguration() {
        if (CollectionUtils.isEmpty((Map)this.wellKnownConfiguration)) {
            try {
                this.wellKnownConfiguration = (Map)this.objectMapper.readValue(this.discoveryEndpoint.getInputStream(), mapTypeReference);
            }
            catch (IOException e) {
                LOG.error((Object)("Error reading well known configuration at " + this.discoveryEndpoint.getDescription()), (Throwable)e);
                return Collections.EMPTY_MAP;
            }
        }
        return this.wellKnownConfiguration;
    }

    @GetMapping(value={"/discovery"})
    public Map<String, Object> discovery() throws IOException {
        return this.readWellKnownConfiguration();
    }

    @PostMapping(value={"/code_challenge"})
    public Map<String, Object> codeChallenge(@RequestBody Map<String, Object> body) {
        this.sanitizeMap(body);
        CodeChallengeMethod method = CodeChallengeMethod.parse((String)((String)body.getOrDefault("codeChallengeMethod", CodeChallengeMethod.S256.getValue())));
        CodeVerifier codeVerifier = new CodeVerifier();
        CodeChallenge codeChallenge = CodeChallenge.compute((CodeChallengeMethod)method, (CodeVerifier)new CodeVerifier((String)body.getOrDefault("codeVerifier", codeVerifier.getValue())));
        body.put("codeChallenge", codeChallenge.getValue());
        body.put("codeVerifier", codeVerifier.getValue());
        body.put("codeChallengeMethod", method.getValue());
        return body;
    }

    @PostMapping(value={"/authorization_code", "/implicit"})
    public Map<String, String> authorize(@RequestBody Map<String, Object> body) throws JOSEException {
        this.sanitizeMap(body);
        HashMap<String, String> parameters = new HashMap<String, String>();
        ResponseType responseType = new ResponseType(((String)body.get("response_type")).split(" "));
        parameters.put("response_type", responseType.toString());
        List scopes = (List)body.get("scope");
        if (!CollectionUtils.isEmpty((Collection)scopes)) {
            parameters.put("scope", String.join((CharSequence)" ", scopes));
        }
        String responseMode = (String)body.getOrDefault("response_mode", responseType.impliesCodeFlow() ? ResponseMode.QUERY.getValue() : ResponseMode.FRAGMENT.getValue());
        parameters.put("response_mode", responseMode);
        List requestedClaims = (List)body.get("claims");
        if (!CollectionUtils.isEmpty((Collection)requestedClaims)) {
            parameters.put("claims", this.claims(requestedClaims));
        }
        parameters.put("client_id", (String)body.getOrDefault("client_id", this.clientId));
        parameters.put("redirect_uri", this.determineRedirectUri(responseMode));
        if (((Boolean)body.getOrDefault("forceAuthentication", false)).booleanValue()) {
            parameters.put("prompt", "login");
        }
        parameters.put("nonce", (String)body.get("nonce"));
        parameters.put("state", (String)body.get("state"));
        if (((Boolean)body.getOrDefault("pkce", false)).booleanValue()) {
            parameters.put("code_challenge", (String)body.get("code_challenge"));
            parameters.put("code_challenge_method", (String)body.get("code_challenge_method"));
        }
        parameters.put("login_hint", (String)body.get("login_hint"));
        parameters.put("acr_values", (String)body.get("acr_values"));
        if (((Boolean)body.getOrDefault("signedJWT", false)).booleanValue()) {
            parameters.put("request", this.signedJWT(parameters).serialize());
            List<String> toRemove = Arrays.asList("response_mode", "claims", "prompt", "state", "code_challenge", "code_challenge_method", "acr_values");
            parameters.keySet().removeIf(toRemove::contains);
        }
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)((String)this.readWellKnownConfiguration().get("authorization_endpoint")));
        parameters.forEach((key, value) -> {
            if (StringUtils.hasText((String)value)) {
                builder.queryParam(key, new Object[]{this.encode(value)});
            }
        });
        return Collections.singletonMap("url", builder.build().toUriString());
    }

    private String determineRedirectUri(String responseMode) {
        return responseMode.equals(ResponseMode.FORM_POST.getValue()) ? this.redirectUriFormPost : this.redirectUri;
    }

    @PostMapping(value={"/token"})
    public Map<String, Object> token(@RequestBody Map<String, Object> body) throws URISyntaxException {
        String responseTypeParam = (String)body.getOrDefault("response_type", ResponseType.getDefault().toString());
        ResponseType responseType = new ResponseType(responseTypeParam.split(" "));
        String responseMode = (String)body.getOrDefault("response_mode", responseType.impliesCodeFlow() ? ResponseMode.QUERY.getValue() : ResponseMode.FRAGMENT.getValue());
        body.put("redirect_uri", this.determineRedirectUri(responseMode));
        return this.doToken(body, "authorization_code");
    }

    @PostMapping(value={"/client_credentials"})
    public Map<String, Object> clientCredentials(@RequestBody Map<String, Object> body) throws URISyntaxException {
        return this.doToken(body, "client_credentials");
    }

    @PostMapping(value={"/refresh_token"})
    public Map<String, Object> refreshToken(@RequestBody Map<String, Object> body) throws URISyntaxException {
        return this.doToken(body, "refresh_token");
    }

    @PostMapping(value={"/introspect"})
    public Map<String, Object> introspect(@RequestBody Map<String, Object> body) throws URISyntaxException {
        body.put("client_id", this.resourceServerId);
        body.put("client_secret", this.resourceServerSecret);
        return this.doPost(body, Collections.singletonMap("token", (String)body.get("token")), (String)this.readWellKnownConfiguration().get("introspect_endpoint"));
    }

    @PostMapping(value={"/userinfo"})
    public Map<String, Object> userinfo(@RequestBody Map<String, Object> body) throws URISyntaxException {
        String endpoint = (String)this.readWellKnownConfiguration().get("userinfo_endpoint");
        String token = (String)body.get("token");
        RequestEntity.BodyBuilder builder = (RequestEntity.BodyBuilder)((RequestEntity.BodyBuilder)RequestEntity.post((URI)new URI(endpoint)).accept(new MediaType[]{MediaType.APPLICATION_JSON, MediaType.APPLICATION_JSON_UTF8})).contentType(MediaType.APPLICATION_FORM_URLENCODED).header("Authorization", new String[]{"Bearer " + token});
        Map<String, String> requestBody = Collections.singletonMap("access_token", token);
        return this.callPostEndpoint(requestBody, (String)this.readWellKnownConfiguration().get("userinfo_endpoint"), builder);
    }

    @GetMapping(value={"/decode_jwt"})
    public String decodeJwtToken(@RequestParam(value="jwt") String jwt) throws ParseException {
        if (this.uuidPattern.matcher(jwt).matches()) {
            return jwt;
        }
        SignedJWT signedJWT = SignedJWT.parse((String)jwt);
        OrderedJSONObject result = new OrderedJSONObject();
        result.put((Object)"header", (Object)this.sortMap(signedJWT.getHeader().toJSONObject().entrySet()));
        result.put((Object)"payload", (Object)this.sortMap(signedJWT.getJWTClaimsSet().toJSONObject().entrySet()));
        return result.toJSONString();
    }

    @PostMapping(value={"/apicall"})
    public Object apiCall(@RequestBody Map<String, String> body) throws URISyntaxException {
        String apiUrl = body.get("apiUrl");
        String accessToken = body.get("accessToken");
        RequestEntity requestEntity = RequestEntity.get((URI)new URI(apiUrl)).accept(new MediaType[]{MediaType.APPLICATION_JSON, MediaType.APPLICATION_JSON_UTF8}).header("Authorization", new String[]{"Bearer " + accessToken}).build();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("result", this.restTemplate.exchange(requestEntity, Object.class).getBody());
        result.put("request_url", apiUrl);
        result.put("request_headers", requestEntity.getHeaders().toSingleValueMap());
        return result;
    }

    private <K, V> Map<K, V> sortMap(Set<Map.Entry<K, V>> entrySet) {
        return entrySet.stream().sorted(Comparator.comparing(e -> e.getKey().toString())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e2, LinkedHashMap::new));
    }

    @GetMapping(value={"/certs"}, produces={"application/json;charset=UTF-8"})
    public String publishClientJwk() throws NoSuchProviderException, NoSuchAlgorithmException {
        return new JWKSet((JWK)this.rsaKey.toPublicJWK()).toJSONObject().toString();
    }

    @PostMapping(value={"/redirect"}, consumes={"application/x-www-form-urlencoded"})
    public void redirectFormPost(@RequestParam MultiValueMap<String, String> form, HttpServletResponse response) throws IOException {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)this.clientRedirectUri);
        form.forEach((key, value) -> {
            if (!CollectionUtils.isEmpty((Collection)value)) {
                builder.queryParam(key, new Object[]{this.encode((String)value.get(0))});
            }
        });
        response.sendRedirect(builder.build().toUriString());
    }

    private Map<String, Object> doToken(Map<String, Object> body, String grantType) throws URISyntaxException {
        List scopes;
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("grant_type", grantType);
        Arrays.asList("code", "redirect_uri", "refresh_token").forEach(k -> {
            if (body.containsKey(k)) {
                requestBody.put((String)k, (String)body.get(k));
            }
        });
        if (body.containsKey("scope") && !CollectionUtils.isEmpty((Collection)(scopes = (List)body.get("scope")))) {
            requestBody.put("scope", String.join((CharSequence)" ", (List)body.get("scope")));
        }
        if (((Boolean)body.getOrDefault("pkce", false)).booleanValue()) {
            requestBody.put("code_verifier", (String)body.get("code_verifier"));
        }
        return this.doPost(body, requestBody, (String)this.readWellKnownConfiguration().get("token_endpoint"));
    }

    private Map<String, Object> doPost(Map<String, Object> body, Map<String, String> requestBody, String endpoint) throws URISyntaxException {
        this.sanitizeMap(body);
        String clientIdToUse = (String)body.get("client_id");
        clientIdToUse = StringUtils.hasText((String)clientIdToUse) ? clientIdToUse : this.clientId;
        String secretToUse = (String)body.get("client_secret");
        secretToUse = StringUtils.hasText((String)secretToUse) ? secretToUse : this.secret;
        RequestEntity.BodyBuilder builder = ((RequestEntity.BodyBuilder)RequestEntity.post((URI)new URI(endpoint)).accept(new MediaType[]{MediaType.APPLICATION_JSON, MediaType.APPLICATION_JSON_UTF8})).contentType(MediaType.APPLICATION_FORM_URLENCODED);
        String authMethod = (String)body.getOrDefault("token_endpoint_auth_method", "client_secret_basic");
        boolean omitAuthentication = (Boolean)body.getOrDefault("omitAuthentication", false);
        if (!omitAuthentication) {
            if (authMethod.equals("client_secret_basic")) {
                String headerValueEncoded = this.encode(clientIdToUse) + ":" + this.encode(secretToUse);
                builder.header("Authorization", new String[]{"Basic " + new String(Base64.getEncoder().encode(headerValueEncoded.getBytes()))});
            } else {
                requestBody.put("client_id", clientIdToUse);
                requestBody.put("client_secret", secretToUse);
            }
        } else {
            requestBody.put("client_id", clientIdToUse);
        }
        return this.callPostEndpoint(requestBody, endpoint, builder);
    }

    private Map<String, Object> callPostEndpoint(Map<String, String> requestBody, String endpoint, RequestEntity.BodyBuilder builder) {
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        requestBody.forEach((arg_0, arg_1) -> ((LinkedMultiValueMap)form).set(arg_0, arg_1));
        RequestEntity requestEntity = builder.body((Object)form);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("result", this.restTemplate.exchange(requestEntity, mapResponseType).getBody());
        result.put("request_body", this.anonymizeInformation(requestBody));
        result.put("request_url", endpoint);
        result.put("request_headers", this.anonymizeInformation(requestEntity.getHeaders().toSingleValueMap()));
        return result;
    }

    private void sanitizeMap(Map<String, Object> body) {
        body.values().removeIf(val -> {
            if (val == null) {
                return true;
            }
            if (val instanceof List) {
                return CollectionUtils.isEmpty((Collection)((List)val));
            }
            if (val instanceof String) {
                return StringUtils.isEmpty((Object)val);
            }
            return false;
        });
    }

    private Map<String, String> anonymizeInformation(Map<String, String> headers) {
        HashMap<String, String> result = new HashMap<String, String>(headers);
        List<String> sensitiveHeaders = Arrays.asList("client_id", "client_secret", "Authorization");
        sensitiveHeaders.forEach(header -> result.replace((String)header, "XXX"));
        return result;
    }

    private String claims(List<String> requestedClaims) {
        ClaimsRequest claimsRequest = new ClaimsRequest();
        requestedClaims.forEach(arg_0 -> ((ClaimsRequest)claimsRequest).addIDTokenClaim(arg_0));
        return claimsRequest.toString();
    }

    private RSAKey generateRsaKey() throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", "BC");
        kpg.initialize(2048);
        KeyPair keyPair = kpg.generateKeyPair();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        return new RSAKey.Builder(publicKey).privateKey(privateKey).algorithm((Algorithm)JWSAlgorithm.RS256).keyID(this.rsaKeyId).build();
    }

    private SignedJWT signedJWT(Map<String, String> form) throws JOSEException {
        Instant now = Instant.now();
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder().audience("audience").expirationTime(Date.from(now.plus(3600L, ChronoUnit.SECONDS))).jwtID(UUID.randomUUID().toString()).issuer(this.clientId).issueTime(Date.from(now)).subject(this.clientId).notBeforeTime(new Date(System.currentTimeMillis()));
        form.forEach((arg_0, arg_1) -> ((JWTClaimsSet.Builder)builder).claim(arg_0, arg_1));
        JWTClaimsSet claimsSet = builder.build();
        JWSHeader header = new JWSHeader.Builder(JWSAlgorithm.RS256).type(JOSEObjectType.JWT).keyID(this.rsaKeyId).build();
        SignedJWT signedJWT = new SignedJWT(header, claimsSet);
        RSASSASigner jswsSigner = new RSASSASigner(this.rsaKey.toPrivateKey());
        signedJWT.sign((JWSSigner)jswsSigner);
        return signedJWT;
    }
}

