/*
 * Decompiled with CFR 0.152.
 */
package playground.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;

@RestController
public class ErrorController
implements org.springframework.boot.web.servlet.error.ErrorController {
    private static final Log LOG = LogFactory.getLog(ErrorController.class);
    private ErrorAttributes errorAttributes;
    private ObjectMapper objectMapper;

    public ErrorController(ErrorAttributes errorAttributes, ObjectMapper objectMapper) {
        this.errorAttributes = errorAttributes;
        this.objectMapper = objectMapper;
    }

    public String getErrorPath() {
        return "/error";
    }

    @RequestMapping(value={"/error"})
    public ResponseEntity<Map> error(HttpServletRequest request) throws IOException {
        HttpStatus statusCode;
        ServletWebRequest webRequest = new ServletWebRequest(request);
        Map result = this.errorAttributes.getErrorAttributes((WebRequest)webRequest, false);
        LOG.error((Object)("Error has occurred: " + result));
        Throwable error = this.errorAttributes.getError((WebRequest)webRequest);
        boolean hasValidStatus = result.containsKey("status") && !result.get("status").equals(999);
        HttpStatus httpStatus = statusCode = hasValidStatus ? HttpStatus.resolve((int)((Integer)result.get("status"))) : HttpStatus.BAD_REQUEST;
        if (error != null) {
            LOG.error((Object)"Exception in /error: ", error);
            result.put("details", error.getMessage());
            if (error instanceof HttpServerErrorException) {
                Map map = (Map)this.objectMapper.readValue(((HttpServerErrorException)error).getResponseBodyAsByteArray(), Map.class);
                if (map.containsKey("status")) {
                    statusCode = HttpStatus.resolve((int)((Integer)map.get("status")));
                }
                return new ResponseEntity((Object)map, statusCode);
            }
        }
        return new ResponseEntity((Object)result, statusCode);
    }
}

