/*
 * Decompiled with CFR 0.152.
 */
package playground.web;

import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RedirectController {
    private final String contextPath;

    public RedirectController(@Value(value="${server.servlet.context-path}") String contextPath) {
        this.contextPath = contextPath;
    }

    @GetMapping(value={"/actuator/health"})
    public ResponseEntity health() throws URISyntaxException {
        URI location = new URI(String.format("%s/internal/health", this.contextPath));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.PERMANENT_REDIRECT).location(location)).build();
    }

    @GetMapping(value={"/actuator/info"})
    public ResponseEntity info() throws URISyntaxException {
        URI location = new URI(String.format("%s/internal/info", this.contextPath));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.PERMANENT_REDIRECT).location(location)).build();
    }
}

