/*
 * Decompiled with CFR 0.152.
 */
package oidc.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.JOSEException;
import java.io.IOException;
import java.text.ParseException;
import javax.servlet.Filter;
import oidc.config.AppConfig;
import oidc.repository.UserRepository;
import oidc.secure.TokenGenerator;
import oidc.user.SamlProvisioningAuthenticationManager;
import oidc.web.ConfigurableSamlAuthenticationRequestFilter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.saml.SamlRequestMatcher;
import org.springframework.security.saml.provider.SamlServerConfiguration;
import org.springframework.security.saml.provider.provisioning.SamlProviderProvisioning;
import org.springframework.security.saml.provider.service.authentication.SamlAuthenticationResponseFilter;
import org.springframework.security.saml.provider.service.config.SamlServiceProviderServerBeanConfiguration;

@Configuration
public class BeanConfig
extends SamlServiceProviderServerBeanConfiguration {
    private AppConfig appConfiguration;
    private UserRepository userRepository;
    private ObjectMapper objectMapper;
    private String issuer;
    private String secureSecret;
    private Resource jwksKeyStorePath;

    public BeanConfig(AppConfig config, UserRepository userRepository, ObjectMapper objectMapper, @Value(value="${jwks_key_store_path}") Resource jwksKeyStorePath, @Value(value="${spring.security.saml2.service-provider.entity-id}") String issuer, @Value(value="${secure_secret}") String secureSecret) {
        this.appConfiguration = config;
        this.userRepository = userRepository;
        this.objectMapper = objectMapper;
        this.jwksKeyStorePath = jwksKeyStorePath;
        this.issuer = issuer;
        this.secureSecret = secureSecret;
    }

    protected SamlServerConfiguration getDefaultHostSamlServerConfiguration() {
        return this.appConfiguration;
    }

    @Bean
    public Filter spSelectIdentityProviderFilter() {
        return (request, response, chain) -> chain.doFilter(request, response);
    }

    @Bean
    public Filter spAuthenticationRequestFilter() {
        SamlProviderProvisioning provisioning = this.getSamlProvisioning();
        SamlRequestMatcher requestMatcher = new SamlRequestMatcher(provisioning, "authorize", false);
        return new ConfigurableSamlAuthenticationRequestFilter(provisioning, requestMatcher);
    }

    @Bean
    public SamlProvisioningAuthenticationManager samlProvisioningAuthenticationManager() throws IOException {
        return new SamlProvisioningAuthenticationManager(this.userRepository, this.objectMapper);
    }

    @Bean
    public TokenGenerator tokenGenerator() throws ParseException, JOSEException, IOException {
        return new TokenGenerator(this.jwksKeyStorePath, this.issuer, this.secureSecret);
    }

    @Bean
    public Filter spAuthenticationResponseFilter() {
        SamlAuthenticationResponseFilter filter = (SamlAuthenticationResponseFilter)SamlAuthenticationResponseFilter.class.cast(super.spAuthenticationResponseFilter());
        try {
            filter.setAuthenticationManager((AuthenticationManager)this.samlProvisioningAuthenticationManager());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return filter;
    }
}

