/*
 * Decompiled with CFR 0.152.
 */
package oidc.endpoints;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseMode;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.pkce.CodeChallenge;
import com.nimbusds.oauth2.sdk.pkce.CodeChallengeMethod;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import oidc.endpoints.OidcEndpoint;
import oidc.exceptions.InvalidScopeException;
import oidc.exceptions.RedirectMismatchException;
import oidc.model.AuthorizationCode;
import oidc.model.OpenIDClient;
import oidc.model.User;
import oidc.repository.AccessTokenRepository;
import oidc.repository.AuthorizationCodeRepository;
import oidc.repository.OpenIDClientRepository;
import oidc.repository.RefreshTokenRepository;
import oidc.repository.UserRepository;
import oidc.secure.TokenGenerator;
import oidc.user.OidcSamlAuthentication;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.web.util.UriComponentsBuilder;

@Controller
public class AuthorizationEndpoint
implements OidcEndpoint {
    private static final Log LOG = LogFactory.getLog(AuthorizationEndpoint.class);
    private TokenGenerator tokenGenerator;
    private AuthorizationCodeRepository authorizationCodeRepository;
    private UserRepository userRepository;
    private AccessTokenRepository accessTokenRepository;
    private RefreshTokenRepository refreshTokenRepository;
    private OpenIDClientRepository openIDClientRepository;
    private List<String> forFreeOpenIDScopes = Arrays.asList("profile", "email", "address", "phone");

    @Autowired
    public AuthorizationEndpoint(AuthorizationCodeRepository authorizationCodeRepository, AccessTokenRepository accessTokenRepository, UserRepository userRepository, RefreshTokenRepository refreshTokenRepository, OpenIDClientRepository openIDClientRepository, TokenGenerator tokenGenerator) {
        this.authorizationCodeRepository = authorizationCodeRepository;
        this.accessTokenRepository = accessTokenRepository;
        this.userRepository = userRepository;
        this.refreshTokenRepository = refreshTokenRepository;
        this.openIDClientRepository = openIDClientRepository;
        this.tokenGenerator = tokenGenerator;
    }

    @GetMapping(value={"/oidc/authorize"})
    public ModelAndView authorize(@RequestParam MultiValueMap<String, String> parameters, Authentication authentication) throws ParseException, JOSEException, UnsupportedEncodingException {
        boolean isOpenIdClient;
        LOG.info((Object)String.format("doAuthorize %s %s", authentication.getDetails(), parameters));
        OidcSamlAuthentication samlAuthentication = (OidcSamlAuthentication)authentication;
        AuthorizationRequest authenticationRequest = AuthorizationRequest.parse(parameters);
        Scope scope = authenticationRequest.getScope();
        boolean bl = isOpenIdClient = scope != null && this.isOpenIDRequest(scope.toStringList());
        if (isOpenIdClient) {
            authenticationRequest = AuthenticationRequest.parse(parameters);
        }
        State state = authenticationRequest.getState();
        OpenIDClient client = this.openIDClientRepository.findByClientId(authenticationRequest.getClientID().getValue());
        String redirectionURI = authenticationRequest.getRedirectionURI().toString();
        redirectionURI = URLDecoder.decode(redirectionURI, Charset.defaultCharset().toString());
        this.validateRedirectionURI(redirectionURI, client);
        List scopes = scope != null ? scope.toStringList() : Collections.emptyList();
        this.validateScopes(scopes, client);
        User user = samlAuthentication.getUser();
        ResponseType responseType = authenticationRequest.getResponseType();
        if (responseType.impliesCodeFlow()) {
            String code = this.tokenGenerator.generateAuthorizationCode();
            AuthorizationCode authorizationCode = this.constructAuthorizationCode(authenticationRequest, client, user, code);
            this.authorizationCodeRepository.insert((Object)authorizationCode);
            return new ModelAndView((View)new RedirectView(this.authorizationRedirect(redirectionURI, state, code)));
        }
        if (responseType.impliesImplicitFlow()) {
            ResponseMode responseMode;
            Map body = this.authorizationEndpointResponse(user, client, authenticationRequest, scopes, responseType);
            if (state != null) {
                body.put("state", state);
            }
            if ((responseMode = authenticationRequest.impliedResponseMode()).equals((Object)ResponseMode.FORM_POST)) {
                body.put("redirect_uri", redirectionURI);
                LOG.info((Object)String.format("Returning implicit flow %s %s", ResponseMode.FORM_POST, redirectionURI));
                return new ModelAndView("form_post", body);
            }
            if (responseMode.equals((Object)ResponseMode.QUERY)) {
                UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)redirectionURI);
                body.forEach((x$0, xva$1) -> builder.queryParam(x$0, new Object[]{xva$1}));
                LOG.info((Object)String.format("Returning implicit flow %s %s", ResponseMode.QUERY, redirectionURI));
                return new ModelAndView((View)new RedirectView(builder.toUriString()));
            }
            if (responseMode.equals((Object)ResponseMode.FRAGMENT)) {
                UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)redirectionURI);
                String fragment = body.entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining("&"));
                builder.fragment(fragment);
                LOG.info((Object)String.format("Returning implicit flow %s %s", ResponseMode.FRAGMENT, redirectionURI));
                return new ModelAndView((View)new RedirectView(builder.toUriString()));
            }
            throw new IllegalArgumentException("Response mode " + responseMode + " not supported");
        }
        if (responseType.impliesHybridFlow()) {
            // empty if block
        }
        throw new IllegalArgumentException("Not yet implemented response_type: " + responseType.toString());
    }

    private AuthorizationCode constructAuthorizationCode(AuthorizationRequest authorizationRequest, OpenIDClient client, User user, String code) {
        String redirectionURI = authorizationRequest.getRedirectionURI().toString();
        List scopes = authorizationRequest.getScope().toStringList();
        CodeChallenge codeChallenge = authorizationRequest.getCodeChallenge();
        String codeChallengeValue = codeChallenge != null ? codeChallenge.getValue() : null;
        CodeChallengeMethod codeChallengeMethod = authorizationRequest.getCodeChallengeMethod();
        String codeChallengeMethodValue = codeChallengeMethod != null ? codeChallengeMethod.getValue() : (codeChallengeValue != null ? CodeChallengeMethod.getDefault().getValue() : null);
        List idTokenClaims = this.getClaims(authorizationRequest);
        return new AuthorizationCode(code, user.getSub(), client.getClientId(), scopes, redirectionURI, codeChallengeValue, codeChallengeMethodValue, idTokenClaims);
    }

    private void validateRedirectionURI(String redirectionURI, OpenIDClient client) {
        if (!client.getRedirectUrls().contains(redirectionURI)) {
            throw new RedirectMismatchException(String.format("Client %s with registered redirect URI's %s requested authorization with redirectURI %s", client.getClientId(), client.getRedirectUrls(), redirectionURI));
        }
    }

    private String authorizationRedirect(String redirectionURI, State state, String code) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)redirectionURI).queryParam("code", new Object[]{code});
        if (state != null && StringUtils.hasText((String)state.getValue())) {
            builder.queryParam("state", new Object[]{state.getValue()});
        }
        String result = builder.toUriString();
        LOG.info((Object)("Returning authorizationRedirect: " + result));
        return result;
    }

    private void validateScopes(List<String> requestedScopes, OpenIDClient client) {
        List scopes = client.getScopes();
        scopes.addAll(this.forFreeOpenIDScopes);
        if (!scopes.containsAll(requestedScopes)) {
            List missingScopes = requestedScopes.stream().filter(s -> !scopes.contains(s)).collect(Collectors.toList());
            throw new InvalidScopeException(String.format("Scope(s) %s are not allowed for %s. Allowed scopes: %s", missingScopes, client.getClientId(), client.getScopes()));
        }
    }

    public TokenGenerator getTokenGenerator() {
        return this.tokenGenerator;
    }

    public AccessTokenRepository getAccessTokenRepository() {
        return this.accessTokenRepository;
    }

    public RefreshTokenRepository getRefreshTokenRepository() {
        return this.refreshTokenRepository;
    }
}

