/*
 * Decompiled with CFR 0.152.
 */
package oidc.endpoints;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.RSAKey;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import net.minidev.json.JSONObject;
import oidc.secure.TokenGenerator;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class JwkKeysEndpoint {
    private TokenGenerator tokenGenerator;
    private Map<String, Object> wellKnownConfiguration;

    public JwkKeysEndpoint(TokenGenerator tokenGenerator, ObjectMapper objectMapper, @Value(value="${spring.security.saml2.service-provider.base-path}") String basePath, @Value(value="${spring.security.saml2.service-provider.entity-id}") String issuer) throws IOException {
        this.tokenGenerator = tokenGenerator;
        String json = IOUtils.toString((InputStream)new ClassPathResource("openid-configuration.json").getInputStream(), (Charset)Charset.defaultCharset());
        json = json.replaceAll("@@base_url@@", basePath).replaceAll("@@issuer@@", issuer);
        this.wellKnownConfiguration = (Map)objectMapper.readValue(json, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    @GetMapping(value={"/oidc/generate-jwks-keystore"})
    public Map<String, List<JSONObject>> generate() throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", "BC");
        kpg.initialize(2048);
        KeyPair keyPair = kpg.generateKeyPair();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        RSAKey build = new RSAKey.Builder(publicKey).privateKey(privateKey).algorithm(new Algorithm("RS256")).keyID("oidc").build();
        return Collections.singletonMap("keys", Collections.singletonList(build.toJSONObject()));
    }

    @GetMapping(value={"oidc/generate-secret-key"})
    public Map<String, String> generateSymmetricSecretKey() throws NoSuchAlgorithmException {
        KeyGenerator aes = KeyGenerator.getInstance("AES");
        aes.init(512);
        SecretKey secretKey = aes.generateKey();
        return Collections.singletonMap("key", Base64.getEncoder().encodeToString(secretKey.getEncoded()));
    }

    @GetMapping(value={"/oidc/certs"}, produces={"application/json;charset=UTF-8"})
    public String publishClientJwk() {
        Map allPublicKeys = this.tokenGenerator.getAllPublicKeys();
        JWKSet jwkSet = new JWKSet(new ArrayList(allPublicKeys.values()));
        return jwkSet.toString();
    }

    @GetMapping(value={"oidc/.well-known/openid-configuration"})
    public Map<String, Object> wellKnownConfiguration() {
        return this.wellKnownConfiguration;
    }
}

