/*
 * Decompiled with CFR 0.152.
 */
package oidc.endpoints;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.ClaimsRequest;
import com.nimbusds.openid.connect.sdk.claims.AccessTokenHash;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import oidc.model.AccessToken;
import oidc.model.OpenIDClient;
import oidc.model.RefreshToken;
import oidc.model.User;
import oidc.repository.AccessTokenRepository;
import oidc.repository.RefreshTokenRepository;
import oidc.secure.TokenGenerator;

public interface OidcEndpoint {
    default public Map<String, Object> tokenEndpointResponse(Optional<User> user, OpenIDClient client, List<String> scopes, List<String> idTokenClaims) throws JOSEException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String accessTokenValue = this.getTokenGenerator().generateAccessToken();
        String sub = user.map(u -> u.getSub()).orElse(client.getClientId());
        this.getAccessTokenRepository().insert((Object)new AccessToken(accessTokenValue, sub, client.getClientId(), scopes, this.accessTokenValidity(client)));
        map.put("access_token", accessTokenValue);
        if (client.getGrants().contains(GrantType.REFRESH_TOKEN.getValue())) {
            String refreshTokenValue = this.getTokenGenerator().generateRefreshToken();
            this.getRefreshTokenRepository().insert((Object)new RefreshToken(refreshTokenValue, sub, client.getClientId(), scopes, this.refreshTokenValidity(client), accessTokenValue));
            map.put("refresh_token", refreshTokenValue);
        }
        if (this.isOpenIDRequest(scopes)) {
            map.put("id_token", this.getTokenGenerator().generateIDTokenForTokenEndpoint(user, client.getClientId(), idTokenClaims));
        }
        this.addSharedProperties(map, client);
        return map;
    }

    default public Map<String, Object> authorizationEndpointResponse(User user, OpenIDClient client, AuthorizationRequest authorizationRequest, List<String> scopes, ResponseType responseType) throws JOSEException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String value = this.getTokenGenerator().generateAccessToken();
        if (AccessTokenHash.isRequiredInIDTokenClaims((ResponseType)responseType) || !this.isOpenIDRequest(authorizationRequest)) {
            this.getAccessTokenRepository().insert((Object)new AccessToken(value, user.getSub(), client.getClientId(), scopes, this.accessTokenValidity(client)));
            map.put("access_token", value);
        }
        if (this.isOpenIDRequest(authorizationRequest)) {
            AuthenticationRequest authenticationRequest = (AuthenticationRequest)authorizationRequest;
            List claims = this.getClaims(authorizationRequest);
            String idToken = this.getTokenGenerator().generateIDTokenForAuthorizationEndpoint(user, client.getClientId(), authenticationRequest.getNonce(), responseType, value, claims);
            map.put("id_token", idToken);
        }
        this.addSharedProperties(map, client);
        return map;
    }

    default public boolean isOpenIDRequest(AuthorizationRequest authorizationRequest) {
        return authorizationRequest instanceof AuthenticationRequest;
    }

    default public boolean isOpenIDRequest(List<String> scopes) {
        return scopes.contains("openid");
    }

    default public List<String> getClaims(AuthorizationRequest authorizationRequest) {
        AuthenticationRequest authenticationRequest;
        ClaimsRequest claimsRequest;
        ArrayList<String> idTokenClaims = new ArrayList<String>();
        if (this.isOpenIDRequest(authorizationRequest) && (claimsRequest = (authenticationRequest = (AuthenticationRequest)authorizationRequest).getClaims()) != null) {
            idTokenClaims.addAll(claimsRequest.getIDTokenClaims().stream().map(entry -> entry.getClaimName()).collect(Collectors.toList()));
        }
        return idTokenClaims;
    }

    default public void addSharedProperties(Map<String, Object> map, OpenIDClient client) {
        map.put("token_type", "Bearer");
        map.put("expires_in", client.getAccessTokenValidity());
    }

    default public Date accessTokenValidity(OpenIDClient client) {
        return this.tokenValidity(client.getAccessTokenValidity());
    }

    default public Date refreshTokenValidity(OpenIDClient client) {
        return this.tokenValidity(client.getRefreshTokenValidity());
    }

    default public Date tokenValidity(int validity) {
        LocalDateTime ldt = LocalDateTime.now().plusSeconds(validity);
        return Date.from(ldt.atZone(ZoneId.systemDefault()).toInstant());
    }

    public TokenGenerator getTokenGenerator();

    public AccessTokenRepository getAccessTokenRepository();

    public RefreshTokenRepository getRefreshTokenRepository();
}

