/*
 * Decompiled with CFR 0.152.
 */
package oidc.endpoints;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ClientCredentialsGrant;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.PlainClientSecret;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.ServletUtils;
import com.nimbusds.oauth2.sdk.pkce.CodeChallenge;
import com.nimbusds.oauth2.sdk.pkce.CodeChallengeMethod;
import com.nimbusds.oauth2.sdk.pkce.CodeVerifier;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import oidc.endpoints.OidcEndpoint;
import oidc.endpoints.SecureEndpoint;
import oidc.exceptions.ClientAuthenticationNotSupported;
import oidc.exceptions.CodeVerifierMissingException;
import oidc.exceptions.InvalidGrantException;
import oidc.exceptions.RedirectMismatchException;
import oidc.model.AuthorizationCode;
import oidc.model.OpenIDClient;
import oidc.model.RefreshToken;
import oidc.model.User;
import oidc.repository.AccessTokenRepository;
import oidc.repository.AuthorizationCodeRepository;
import oidc.repository.OpenIDClientRepository;
import oidc.repository.RefreshTokenRepository;
import oidc.repository.UserRepository;
import oidc.secure.TokenGenerator;
import org.apache.http.entity.ContentType;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class TokenEndpoint
extends SecureEndpoint
implements OidcEndpoint {
    private AuthorizationCodeRepository authorizationCodeRepository;
    private AccessTokenRepository accessTokenRepository;
    private RefreshTokenRepository refreshTokenRepository;
    private UserRepository userRepository;
    private OpenIDClientRepository openIDClientRepository;
    private TokenGenerator tokenGenerator;

    public TokenEndpoint(OpenIDClientRepository openIDClientRepository, AuthorizationCodeRepository authorizationCodeRepository, AccessTokenRepository accessTokenRepository, RefreshTokenRepository refreshTokenRepository, UserRepository userRepository, TokenGenerator tokenGenerator) {
        this.openIDClientRepository = openIDClientRepository;
        this.authorizationCodeRepository = authorizationCodeRepository;
        this.accessTokenRepository = accessTokenRepository;
        this.refreshTokenRepository = refreshTokenRepository;
        this.userRepository = userRepository;
        this.tokenGenerator = tokenGenerator;
    }

    @PostMapping(value={"oidc/token"}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity token(HttpServletRequest request) throws IOException, ParseException, JOSEException {
        HTTPRequest httpRequest = ServletUtils.createHTTPRequest((HttpServletRequest)request);
        TokenRequest tokenRequest = TokenRequest.parse((HTTPRequest)httpRequest);
        ClientAuthentication clientAuthentication = tokenRequest.getClientAuthentication();
        if (clientAuthentication != null && !(clientAuthentication instanceof PlainClientSecret)) {
            throw new ClientAuthenticationNotSupported(String.format("Unsupported '%s' findByClientId authentication in token endpoint", clientAuthentication.getClass()));
        }
        AuthorizationGrant authorizationGrant = tokenRequest.getAuthorizationGrant();
        if (clientAuthentication == null && authorizationGrant instanceof AuthorizationCodeGrant && ((AuthorizationCodeGrant)authorizationGrant).getCodeVerifier() == null) {
            throw new CodeVerifierMissingException("code_verifier required without client authentication");
        }
        String clientId = clientAuthentication != null ? clientAuthentication.getClientID().getValue() : tokenRequest.getClientID().getValue();
        OpenIDClient client = this.openIDClientRepository.findByClientId(clientId);
        if (clientAuthentication == null && !client.isPublicClient()) {
            throw new BadCredentialsException("Non-public client requires authentication");
        }
        if (clientAuthentication != null && !this.secretsMatch((PlainClientSecret)PlainClientSecret.class.cast(clientAuthentication), client)) {
            throw new BadCredentialsException("Invalid user / secret");
        }
        if (!client.getGrants().contains(authorizationGrant.getType().getValue())) {
            throw new InvalidGrantException("Invalid grant");
        }
        if (authorizationGrant instanceof AuthorizationCodeGrant) {
            return this.handleAuthorizationCodeGrant((AuthorizationCodeGrant)authorizationGrant, client);
        }
        if (authorizationGrant instanceof ClientCredentialsGrant) {
            return this.handleClientCredentialsGrant(client);
        }
        if (authorizationGrant instanceof RefreshTokenGrant) {
            return this.handleRefreshCodeGrant((RefreshTokenGrant)authorizationGrant, client);
        }
        throw new IllegalArgumentException("Not supported - yet - authorizationGrant " + authorizationGrant);
    }

    public TokenGenerator getTokenGenerator() {
        return this.tokenGenerator;
    }

    public AccessTokenRepository getAccessTokenRepository() {
        return this.accessTokenRepository;
    }

    public RefreshTokenRepository getRefreshTokenRepository() {
        return this.refreshTokenRepository;
    }

    private ResponseEntity handleAuthorizationCodeGrant(AuthorizationCodeGrant authorizationCodeGrant, OpenIDClient client) throws JOSEException {
        String code = authorizationCodeGrant.getAuthorizationCode().getValue();
        AuthorizationCode authorizationCode = this.authorizationCodeRepository.findByCode(code);
        if (!authorizationCode.getClientId().equals(client.getClientId())) {
            throw new BadCredentialsException("Client is not authorized for the authorization code");
        }
        if (authorizationCodeGrant.getRedirectionURI() != null && !authorizationCodeGrant.getRedirectionURI().toString().equals(authorizationCode.getRedirectUri())) {
            throw new RedirectMismatchException("Redirects do not match");
        }
        CodeVerifier codeVerifier = authorizationCodeGrant.getCodeVerifier();
        if (codeVerifier != null) {
            if (authorizationCode.getCodeChallenge() == null) {
                throw new CodeVerifierMissingException("code_verifier present, but no code_challenge in the authorization_code");
            }
            CodeChallenge computed = CodeChallenge.compute((CodeChallengeMethod)CodeChallengeMethod.parse((String)authorizationCode.getCodeChallengeMethod()), (CodeVerifier)new CodeVerifier(authorizationCode.getCodeChallenge()));
            if (!codeVerifier.getValue().equals(computed.getValue())) {
                throw new CodeVerifierMissingException("code_verifier does not match code_challenge");
            }
        }
        this.authorizationCodeRepository.delete((Object)authorizationCode);
        User user = this.userRepository.findUserBySub(authorizationCode.getSub());
        Map body = this.tokenEndpointResponse(Optional.of(user), client, authorizationCode.getScopes(), authorizationCode.getIdTokenClaims());
        return new ResponseEntity((Object)body, (MultiValueMap)this.getResponseHeaders(), HttpStatus.OK);
    }

    private ResponseEntity handleRefreshCodeGrant(RefreshTokenGrant refreshTokenGrant, OpenIDClient client) throws JOSEException {
        String refreshTokenValue = refreshTokenGrant.getRefreshToken().getValue();
        RefreshToken refreshToken = this.refreshTokenRepository.findByValue(refreshTokenValue);
        if (!refreshToken.getClientId().equals(client.getClientId())) {
            throw new BadCredentialsException("Client is not authorized for the refresh token");
        }
        this.refreshTokenRepository.delete((Object)refreshToken);
        Optional accessToken = this.accessTokenRepository.findOptionalAccessTokenByValue(refreshToken.getAccessTokenValue());
        accessToken.ifPresent(token -> this.accessTokenRepository.delete(token));
        User user = this.userRepository.findUserBySub(refreshToken.getSub());
        Map body = this.tokenEndpointResponse(Optional.of(user), client, refreshToken.getScopes(), Collections.emptyList());
        return new ResponseEntity((Object)body, (MultiValueMap)this.getResponseHeaders(), HttpStatus.OK);
    }

    private ResponseEntity handleClientCredentialsGrant(OpenIDClient client) throws JOSEException {
        Map body = this.tokenEndpointResponse(Optional.empty(), client, client.getScopes(), Collections.emptyList());
        return new ResponseEntity((Object)body, (MultiValueMap)this.getResponseHeaders(), HttpStatus.OK);
    }

    private HttpHeaders getResponseHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Cache-Control", "no-store");
        headers.set("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
        headers.set("Pragma", "no-cache");
        return headers;
    }
}

