/*
 * Decompiled with CFR 0.152.
 */
package oidc.endpoints;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.ServletUtils;
import com.nimbusds.openid.connect.sdk.UserInfoRequest;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oidc.exceptions.UnauthorizedException;
import oidc.model.AccessToken;
import oidc.model.User;
import oidc.repository.AccessTokenRepository;
import oidc.repository.UserRepository;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserInfoEndpoint {
    private AccessTokenRepository accessTokenRepository;
    private UserRepository userRepository;

    public UserInfoEndpoint(AccessTokenRepository accessTokenRepository, UserRepository userRepository) {
        this.accessTokenRepository = accessTokenRepository;
        this.userRepository = userRepository;
    }

    @GetMapping(value={"oidc/userinfo"})
    public Map<String, Object> getUserInfo(HttpServletRequest request) throws IOException, ParseException {
        return this.userInfo(request);
    }

    @PostMapping(value={"oidc/userinfo"}, consumes={"application/x-www-form-urlencoded"})
    public Map<String, Object> postUserInfo(HttpServletRequest request) throws ParseException, IOException {
        return this.userInfo(request);
    }

    private Map<String, Object> userInfo(HttpServletRequest request) throws ParseException, IOException {
        HTTPRequest httpRequest = ServletUtils.createHTTPRequest((HttpServletRequest)request);
        UserInfoRequest userInfoRequest = UserInfoRequest.parse((HTTPRequest)httpRequest);
        AccessToken accessToken = this.accessTokenRepository.findByValue(userInfoRequest.getAccessToken().getValue());
        if (accessToken.isExpired()) {
            throw new UnauthorizedException("Access token expired");
        }
        User user = this.userRepository.findUserBySub(accessToken.getSub());
        Map attributes = user.getAttributes();
        attributes.put("updated_at", user.getUpdatedAt());
        return attributes;
    }
}

