/*
 * Decompiled with CFR 0.152.
 */
package oidc.model;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="access_tokens")
public class AccessToken {
    @Id
    private String id;
    private String value;
    private String sub;
    private String clientId;
    private List<String> scopes;
    private Date expiresIn;

    public AccessToken(String value, String sub, String clientId, List<String> scopes, Date expiresIn) {
        this.value = value;
        this.sub = sub;
        this.clientId = clientId;
        this.scopes = scopes;
        this.expiresIn = expiresIn != null ? expiresIn : Date.from(LocalDateTime.now().plusSeconds(3600L).atZone(ZoneId.systemDefault()).toInstant());
    }

    @Transient
    public boolean isExpired() {
        return this.expiresIn.before(new Date());
    }

    public AccessToken() {
    }

    public String getId() {
        return this.id;
    }

    public String getValue() {
        return this.value;
    }

    public String getSub() {
        return this.sub;
    }

    public String getClientId() {
        return this.clientId;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public Date getExpiresIn() {
        return this.expiresIn;
    }
}

