/*
 * Decompiled with CFR 0.152.
 */
package oidc.model;

import java.util.List;
import java.util.Map;
import oidc.manage.ServiceProviderTranslation;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="clients")
public class OpenIDClient {
    @Id
    private String id;
    private String clientId;
    private String name;
    private String secret;
    private List<String> redirectUrls;
    private List<String> scopes;
    private List<String> grants;
    private boolean resourceServer;
    private boolean publicClient;
    private int accessTokenValidity;
    private int refreshTokenValidity;

    public OpenIDClient(Map<String, Object> root) {
        Map data = (Map)root.get("data");
        this.clientId = ServiceProviderTranslation.translateServiceProviderEntityId((String)((String)String.class.cast(data.get("entityid"))));
        Map metaDataFields = (Map)data.get("metaDataFields");
        this.name = (String)String.class.cast(metaDataFields.get("name:en"));
        this.secret = (String)String.class.cast(metaDataFields.get("secret"));
        this.redirectUrls = (List)List.class.cast(metaDataFields.get("redirectUrls"));
        this.scopes = (List)List.class.cast(metaDataFields.getOrDefault("scopes", "oidc"));
        this.grants = (List)List.class.cast(metaDataFields.getOrDefault("grants", "authorization_code"));
        this.resourceServer = this.parseBoolean(metaDataFields.get("isResourceServer"));
        this.publicClient = this.parseBoolean(metaDataFields.get("isPublicClient"));
        this.accessTokenValidity = (Integer)Integer.class.cast(metaDataFields.getOrDefault("accessTokenValidity", 3600));
        this.refreshTokenValidity = (Integer)Integer.class.cast(metaDataFields.getOrDefault("refreshTokenValidity", 3600));
    }

    @Transient
    private boolean parseBoolean(Object val) {
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof String) {
            return "1".equals(val);
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getName() {
        return this.name;
    }

    public String getSecret() {
        return this.secret;
    }

    public List<String> getRedirectUrls() {
        return this.redirectUrls;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public List<String> getGrants() {
        return this.grants;
    }

    public boolean isResourceServer() {
        return this.resourceServer;
    }

    public boolean isPublicClient() {
        return this.publicClient;
    }

    public int getAccessTokenValidity() {
        return this.accessTokenValidity;
    }

    public int getRefreshTokenValidity() {
        return this.refreshTokenValidity;
    }

    public OpenIDClient() {
    }
}

