/*
 * Decompiled with CFR 0.152.
 */
package oidc.mongo;

import com.github.mongobee.Mongobee;
import com.github.mongobee.changeset.ChangeLog;
import com.github.mongobee.changeset.ChangeSet;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import oidc.model.AccessToken;
import oidc.model.AuthorizationCode;
import oidc.model.OpenIDClient;
import oidc.model.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.MongoTransactionManager;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.index.IndexOperations;

@Configuration
@ChangeLog
public class MongobeeConfiguration {
    @Autowired
    private MongoTemplate mongoTemplate;
    @Value(value="${mongodb_db}")
    private String databaseName;
    @Value(value="${spring.data.mongodb.uri}")
    private String mongobdUri;

    @Bean
    public MongoTransactionManager transactionManager() {
        return new MongoTransactionManager(this.mongoTemplate.getMongoDbFactory());
    }

    @Bean
    public Mongobee mongobee(@Value(value="${spring.data.mongodb.uri}") String mongobdUri) throws Exception {
        Mongobee mongobee = new Mongobee(new MongoClient(new MongoClientURI(mongobdUri)));
        return mongobee.setChangeLogsScanPackage("oidc.mongo").setDbName(this.databaseName).setMongoTemplate(this.mongoTemplate);
    }

    @ChangeSet(order="001", id="createIndexes", author="Okke Harsta")
    public void createCollections(MongoTemplate mongoTemplate) {
        HashMap<Class, List> indexInfo = new HashMap<Class, List>();
        indexInfo.put(AccessToken.class, Arrays.asList("value"));
        indexInfo.put(AuthorizationCode.class, Arrays.asList("code"));
        indexInfo.put(User.class, Arrays.asList("sub"));
        indexInfo.put(OpenIDClient.class, Arrays.asList("clientId"));
        indexInfo.forEach((collection, fields) -> {
            if (!mongoTemplate.collectionExists(collection)) {
                mongoTemplate.createCollection(collection);
            }
            fields.forEach(field -> {
                IndexOperations indexOperations = mongoTemplate.indexOps(collection);
                indexOperations.ensureIndex((IndexDefinition)new Index(field, Sort.Direction.ASC).named(String.format("%s_unique", field)).unique());
            });
        });
    }
}

