/*
 * Decompiled with CFR 0.152.
 */
package oidc.web;

import java.io.IOException;
import java.util.Collections;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oidc.manage.ServiceProviderTranslation;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.saml.SamlRequestMatcher;
import org.springframework.security.saml.provider.provisioning.SamlProviderProvisioning;
import org.springframework.security.saml.provider.service.SamlAuthenticationRequestFilter;
import org.springframework.security.saml.provider.service.ServiceProviderService;
import org.springframework.security.saml.saml2.authentication.AuthenticationRequest;
import org.springframework.security.saml.saml2.authentication.Scoping;
import org.springframework.security.saml.saml2.metadata.IdentityProviderMetadata;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.StringUtils;

public class ConfigurableSamlAuthenticationRequestFilter
extends SamlAuthenticationRequestFilter {
    private RequestCache requestCache = new HttpSessionRequestCache();

    public ConfigurableSamlAuthenticationRequestFilter(SamlProviderProvisioning<ServiceProviderService> provisioning, SamlRequestMatcher samlRequestMatcher) {
        super(provisioning, (RequestMatcher)samlRequestMatcher);
    }

    protected String getRelayState(ServiceProviderService provider, HttpServletRequest request) {
        return request.getParameter("client_id");
    }

    protected AuthenticationRequest enhanceAuthenticationRequest(ServiceProviderService provider, HttpServletRequest request, AuthenticationRequest authenticationRequest) {
        String clientId = this.getRelayState(provider, request);
        if (StringUtils.hasText((String)clientId)) {
            String entityId = ServiceProviderTranslation.translateClientId((String)clientId);
            authenticationRequest.setScoping(new Scoping(null, Collections.singletonList(entityId), Integer.valueOf(1)));
        }
        return authenticationRequest;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (this.getRequestMatcher().matches(request) && (authentication == null || !authentication.isAuthenticated())) {
            ServiceProviderService provider = (ServiceProviderService)this.getProvisioning().getHostedProvider();
            IdentityProviderMetadata idp = (IdentityProviderMetadata)provider.getRemoteProviders().get(0);
            AuthenticationRequest authenticationRequest = provider.authenticationRequest(idp);
            authenticationRequest = this.enhanceAuthenticationRequest(provider, request, authenticationRequest);
            this.requestCache.saveRequest(request, response);
            this.sendAuthenticationRequest(provider, request, response, authenticationRequest, authenticationRequest.getDestination());
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }
}

