/*
 * Decompiled with CFR 0.152.
 */
package oidc.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.servlet.Filter;
import oidc.config.AppConfig;
import oidc.repository.SequenceRepository;
import oidc.repository.SigningKeyRepository;
import oidc.repository.UserRepository;
import oidc.secure.LoggingStrictHttpFirewall;
import oidc.user.SamlProvisioningAuthenticationManager;
import oidc.web.ConfigurableSamlAuthenticationRequestFilter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.saml.SamlRequestMatcher;
import org.springframework.security.saml.provider.SamlServerConfiguration;
import org.springframework.security.saml.provider.provisioning.SamlProviderProvisioning;
import org.springframework.security.saml.provider.service.authentication.SamlAuthenticationResponseFilter;
import org.springframework.security.saml.provider.service.config.SamlServiceProviderServerBeanConfiguration;
import org.springframework.security.web.firewall.StrictHttpFirewall;

@Configuration
@EnableScheduling
public class BeanConfig
extends SamlServiceProviderServerBeanConfiguration {
    private Environment environment;
    private AppConfig appConfiguration;
    private UserRepository userRepository;
    private SigningKeyRepository signingKeyRepository;
    private SequenceRepository sequenceRepository;
    private ObjectMapper objectMapper;
    private String issuer;
    private Resource jwksKeyStorePath;
    private Resource secretKeySetPath;
    private String associatedData;

    public BeanConfig(AppConfig config, UserRepository userRepository, SigningKeyRepository signingKeyRepository, SequenceRepository sequenceRepository, ObjectMapper objectMapper, Environment environment, @Value(value="${secret_key_set_path}") Resource secretKeySetPath, @Value(value="${associated_data}") String associatedData, @Value(value="${spring.security.saml2.service-provider.entity-id}") String issuer, @Value(value="${cron.node-cron-job-responsible}") boolean cronJobResponsible) {
        this.appConfiguration = config;
        this.userRepository = userRepository;
        this.signingKeyRepository = signingKeyRepository;
        this.sequenceRepository = sequenceRepository;
        this.objectMapper = objectMapper;
        this.secretKeySetPath = secretKeySetPath;
        this.associatedData = associatedData;
        this.issuer = issuer;
        this.environment = environment;
    }

    protected SamlServerConfiguration getDefaultHostSamlServerConfiguration() {
        return this.appConfiguration;
    }

    @Bean
    public Filter spSelectIdentityProviderFilter() {
        return (request, response, chain) -> chain.doFilter(request, response);
    }

    @Bean
    public Filter spAuthenticationRequestFilter() {
        SamlProviderProvisioning provisioning = this.getSamlProvisioning();
        SamlRequestMatcher requestMatcher = new SamlRequestMatcher(provisioning, "authorize", false);
        return new ConfigurableSamlAuthenticationRequestFilter(provisioning, requestMatcher);
    }

    @Bean
    public SamlProvisioningAuthenticationManager samlProvisioningAuthenticationManager() throws IOException {
        return new SamlProvisioningAuthenticationManager(this.userRepository, this.objectMapper);
    }

    @Bean
    public StrictHttpFirewall strictHttpFirewall() {
        return new LoggingStrictHttpFirewall();
    }

    @Bean
    public Filter spAuthenticationResponseFilter() {
        SamlAuthenticationResponseFilter filter = (SamlAuthenticationResponseFilter)super.spAuthenticationResponseFilter();
        try {
            filter.setAuthenticationManager((AuthenticationManager)this.samlProvisioningAuthenticationManager());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return filter;
    }
}

