/*
 * Decompiled with CFR 0.152.
 */
package oidc.endpoints;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseMode;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import oidc.endpoints.OidcEndpoint;
import oidc.exceptions.InvalidScopeException;
import oidc.exceptions.RedirectMismatchException;
import oidc.model.AccessToken;
import oidc.model.AuthorizationCode;
import oidc.model.OpenIDClient;
import oidc.model.User;
import oidc.repository.AccessTokenRepository;
import oidc.repository.AuthorizationCodeRepository;
import oidc.repository.OpenIDClientRepository;
import oidc.repository.RefreshTokenRepository;
import oidc.repository.UserRepository;
import oidc.secure.TokenGenerator;
import oidc.user.OidcSamlAuthentication;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.web.util.UriComponentsBuilder;

@Controller
public class AuthorizationEndpoint
implements OidcEndpoint {
    private static final Log LOG = LogFactory.getLog(AuthorizationEndpoint.class);
    private TokenGenerator tokenGenerator;
    private AuthorizationCodeRepository authorizationCodeRepository;
    private AccessTokenRepository accessTokenRepository;
    private UserRepository userRepository;
    private RefreshTokenRepository refreshTokenRepository;
    private OpenIDClientRepository openIDClientRepository;
    private List<String> forFreeOpenIDScopes = Arrays.asList("profile", "email", "address", "phone");

    @Autowired
    public AuthorizationEndpoint(AuthorizationCodeRepository authorizationCodeRepository, AccessTokenRepository accessTokenRepository, RefreshTokenRepository refreshTokenRepository, UserRepository userRepository, OpenIDClientRepository openIDClientRepository, TokenGenerator tokenGenerator) {
        this.authorizationCodeRepository = authorizationCodeRepository;
        this.accessTokenRepository = accessTokenRepository;
        this.refreshTokenRepository = refreshTokenRepository;
        this.userRepository = userRepository;
        this.openIDClientRepository = openIDClientRepository;
        this.tokenGenerator = tokenGenerator;
    }

    @GetMapping(value={"/oidc/authorize"})
    public ModelAndView authorize(@RequestParam MultiValueMap<String, String> parameters, Authentication authentication) throws ParseException, JOSEException, UnsupportedEncodingException, NoSuchProviderException, NoSuchAlgorithmException {
        boolean isOpenIdClient;
        LOG.info((Object)String.format("doAuthorize %s %s", authentication.getDetails(), parameters));
        this.logout();
        OidcSamlAuthentication samlAuthentication = (OidcSamlAuthentication)authentication;
        AuthorizationRequest authenticationRequest = AuthorizationRequest.parse(parameters);
        Scope scope = authenticationRequest.getScope();
        boolean bl = isOpenIdClient = scope != null && this.isOpenIDRequest(scope.toStringList());
        if (isOpenIdClient) {
            authenticationRequest = AuthenticationRequest.parse(parameters);
        }
        State state = authenticationRequest.getState();
        OpenIDClient client = this.openIDClientRepository.findByClientId(authenticationRequest.getClientID().getValue());
        String redirectionURI = authenticationRequest.getRedirectionURI().toString();
        redirectionURI = URLDecoder.decode(redirectionURI, "UTF-8");
        this.validateRedirectionURI(redirectionURI, client);
        List scopes = scope != null ? scope.toStringList() : Collections.emptyList();
        this.validateScopes(scopes, client);
        User user = samlAuthentication.getUser();
        ResponseType responseType = authenticationRequest.getResponseType();
        if (responseType.impliesCodeFlow()) {
            AuthorizationCode authorizationCode = this.createAndSaveAuthorizationCode(authenticationRequest, client, user);
            return new ModelAndView((View)new RedirectView(this.authorizationRedirect(redirectionURI, state, authorizationCode.getCode())));
        }
        if (responseType.impliesImplicitFlow() || responseType.impliesHybridFlow()) {
            if (responseType.impliesImplicitFlow()) {
                this.userRepository.delete((Object)user);
            }
            Map body = this.authorizationEndpointResponse(user, client, authenticationRequest, scopes, responseType, state);
            ResponseMode responseMode = authenticationRequest.impliedResponseMode();
            if (responseMode.equals((Object)ResponseMode.FORM_POST)) {
                body.put("redirect_uri", redirectionURI);
                LOG.info((Object)String.format("Returning implicit flow %s %s", ResponseMode.FORM_POST, redirectionURI));
                return new ModelAndView("form_post", body);
            }
            if (responseMode.equals((Object)ResponseMode.QUERY)) {
                UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)redirectionURI);
                body.forEach((x$0, xva$1) -> builder.queryParam(x$0, new Object[]{xva$1}));
                LOG.info((Object)String.format("Returning implicit flow %s %s", ResponseMode.QUERY, redirectionURI));
                return new ModelAndView((View)new RedirectView(builder.toUriString()));
            }
            if (responseMode.equals((Object)ResponseMode.FRAGMENT)) {
                UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)redirectionURI);
                String fragment = body.entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining("&"));
                builder.fragment(fragment);
                LOG.info((Object)String.format("Returning implicit flow %s %s", ResponseMode.FRAGMENT, redirectionURI));
                return new ModelAndView((View)new RedirectView(builder.toUriString()));
            }
            throw new IllegalArgumentException("Response mode " + responseMode + " not supported");
        }
        throw new IllegalArgumentException("Not yet implemented response_type: " + responseType.toString());
    }

    private Map<String, Object> authorizationEndpointResponse(User user, OpenIDClient client, AuthorizationRequest authorizationRequest, List<String> scopes, ResponseType responseType, State state) throws JOSEException, NoSuchProviderException, NoSuchAlgorithmException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String value = this.tokenGenerator.generateAccessTokenWithEmbeddedUserInfo(user, client, scopes);
        if (responseType.contains("token") || !this.isOpenIDRequest(authorizationRequest)) {
            this.getAccessTokenRepository().insert((Object)new AccessToken(value, user.getSub(), client.getClientId(), scopes, this.tokenGenerator.getCurrentSigningKeyId(), this.accessTokenValidity(client), false));
            result.put("access_token", value);
        }
        if (responseType.contains("code")) {
            AuthorizationCode authorizationCode = this.createAndSaveAuthorizationCode(authorizationRequest, client, user);
            result.put("code", authorizationCode.getCode());
        }
        if (responseType.contains("id_token")) {
            AuthenticationRequest authenticationRequest = (AuthenticationRequest)authorizationRequest;
            List claims = this.getClaims(authorizationRequest);
            String idToken = this.getTokenGenerator().generateIDTokenForAuthorizationEndpoint(user, client, authenticationRequest.getNonce(), responseType, value, claims, Optional.ofNullable((String)result.get("code")), state);
            result.put("id_token", idToken);
        }
        if (state != null) {
            result.put("state", state);
        }
        this.addSharedProperties(result, client);
        return result;
    }

    private AuthorizationCode createAndSaveAuthorizationCode(AuthorizationRequest authenticationRequest, OpenIDClient client, User user) {
        AuthorizationCode authorizationCode = this.constructAuthorizationCode(authenticationRequest, client, user);
        this.authorizationCodeRepository.insert((Object)authorizationCode);
        return authorizationCode;
    }

    private void validateRedirectionURI(String redirectionURI, OpenIDClient client) {
        if (!client.getRedirectUrls().contains(redirectionURI)) {
            throw new RedirectMismatchException(String.format("Client %s with registered redirect URI's %s requested authorization with redirectURI %s", client.getClientId(), client.getRedirectUrls(), redirectionURI));
        }
    }

    private String authorizationRedirect(String redirectionURI, State state, String code) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)redirectionURI).queryParam("code", new Object[]{code});
        if (state != null && StringUtils.hasText((String)state.getValue())) {
            builder.queryParam("state", new Object[]{state.getValue()});
        }
        String result = builder.toUriString();
        LOG.info((Object)("Returning authorizationRedirect: " + result));
        return result;
    }

    private void validateScopes(List<String> requestedScopes, OpenIDClient client) {
        List scopes = client.getScopes();
        scopes.addAll(this.forFreeOpenIDScopes);
        if (!scopes.containsAll(requestedScopes)) {
            List missingScopes = requestedScopes.stream().filter(s -> !scopes.contains(s)).collect(Collectors.toList());
            throw new InvalidScopeException(String.format("Scope(s) %s are not allowed for %s. Allowed scopes: %s", missingScopes, client.getClientId(), client.getScopes()));
        }
    }

    public TokenGenerator getTokenGenerator() {
        return this.tokenGenerator;
    }

    public AccessTokenRepository getAccessTokenRepository() {
        return this.accessTokenRepository;
    }

    public RefreshTokenRepository getRefreshTokenRepository() {
        return this.refreshTokenRepository;
    }
}

