/*
 * Decompiled with CFR 0.152.
 */
package oidc.endpoints;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.crypto.tink.CleartextKeysetHandle;
import com.google.crypto.tink.JsonKeysetWriter;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.KeysetWriter;
import com.google.crypto.tink.aead.AeadKeyTemplates;
import com.google.crypto.tink.proto.KeyTemplate;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.RSAKey;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONObject;
import oidc.endpoints.MapTypeReference;
import oidc.secure.TokenGenerator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class JwkKeysEndpoint
implements MapTypeReference {
    private TokenGenerator tokenGenerator;
    private Map<String, Object> wellKnownConfiguration;
    private ObjectMapper objectMapper;

    public JwkKeysEndpoint(TokenGenerator tokenGenerator, ObjectMapper objectMapper, @Value(value="${openid_configuration_path}") Resource configurationPath, @Value(value="${spring.security.saml2.service-provider.entity-id}") String issuer) throws IOException {
        this.tokenGenerator = tokenGenerator;
        this.wellKnownConfiguration = (Map)objectMapper.readValue(configurationPath.getInputStream(), mapTypeReference);
        this.objectMapper = objectMapper;
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    @GetMapping(value={"oidc/generate-jwks-keystore"})
    public Map<String, List<JSONObject>> generate(@RequestParam(value="keyID", required=false, defaultValue="oidc") String keyID) throws Exception {
        RSAKey build = this.tokenGenerator.generateRsaKey(keyID);
        return Collections.singletonMap("keys", Collections.singletonList(build.toJSONObject()));
    }

    @GetMapping(value={"oidc/generate-secret-key-set"})
    public Map<String, Object> generateSymmetricSecretKey() throws GeneralSecurityException, IOException {
        KeysetHandle keysetHandle = KeysetHandle.generateNew((KeyTemplate)AeadKeyTemplates.AES256_CTR_HMAC_SHA256);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        CleartextKeysetHandle.write((KeysetHandle)keysetHandle, (KeysetWriter)JsonKeysetWriter.withOutputStream((OutputStream)outputStream));
        return (Map)this.objectMapper.readValue(outputStream.toString(), mapTypeReference);
    }

    @GetMapping(value={"/oidc/certs"}, produces={"application/json;charset=UTF-8"})
    public String publishClientJwk() {
        return new JWKSet(this.tokenGenerator.getAllPublicKeys()).toJSONObject().toString();
    }

    @GetMapping(value={"oidc/.well-known/openid-configuration"})
    public Map<String, Object> wellKnownConfiguration() {
        return this.wellKnownConfiguration;
    }
}

