/*
 * Decompiled with CFR 0.152.
 */
package oidc.secure;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import oidc.model.SigningKey;
import oidc.secure.TokenGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class KeyRollover {
    private static final Log LOG = LogFactory.getLog(KeyRollover.class);
    private TokenGenerator tokenGenerator;
    private boolean cronJobResponsible;

    public KeyRollover(TokenGenerator tokenGenerator, @Value(value="${cron.node-cron-job-responsible}") boolean cronJobResponsible) {
        this.tokenGenerator = tokenGenerator;
        this.cronJobResponsible = cronJobResponsible;
    }

    @Scheduled(cron="${cron.key-rollover-expression}")
    public void clean() {
        if (!this.cronJobResponsible) {
            return;
        }
        try {
            SigningKey signingKey = this.tokenGenerator.rolloverSigningKeys();
            LOG.info((Object)("Successful signing key rollover. New signing key: " + signingKey.getKeyId()));
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            LOG.error((Object)"Rollover exception", (Throwable)e);
        }
    }
}

