/*
 * Decompiled with CFR 0.152.
 */
package oidc.user;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import oidc.model.User;
import oidc.repository.UserRepository;
import oidc.user.OidcSamlAuthentication;
import oidc.user.UserAttribute;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.saml.saml2.attribute.Attribute;
import org.springframework.security.saml.saml2.authentication.Assertion;
import org.springframework.security.saml.spi.DefaultSamlAuthentication;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class SamlProvisioningAuthenticationManager
implements AuthenticationManager {
    private static final Log LOG = LogFactory.getLog(SamlProvisioningAuthenticationManager.class);
    private UserRepository userRepository;
    private List<UserAttribute> userAttributes;

    public SamlProvisioningAuthenticationManager(UserRepository userRepository, ObjectMapper objectMapper) throws IOException {
        this.userRepository = userRepository;
        this.userAttributes = (List)objectMapper.readValue(new ClassPathResource("oidc/saml_mapping.json").getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        DefaultSamlAuthentication samlAuthentication = (DefaultSamlAuthentication)authentication;
        User user = this.buildUser(samlAuthentication);
        Optional existingUserOptional = this.userRepository.findOptionalUserBySub(user.getSub());
        if (existingUserOptional.isPresent()) {
            User existingUser = (User)existingUserOptional.get();
            LOG.info((Object)("Authenticate with existing user: " + existingUser));
            user.setId(existingUser.getId());
            if (!user.equals((Object)existingUser)) {
                LOG.info((Object)("Saving existing user with changed attributes: " + existingUser));
                this.userRepository.save((Object)existingUser);
            }
        } else {
            LOG.info((Object)("Provisioning new user : " + user));
            this.userRepository.insert((Object)user);
        }
        OidcSamlAuthentication oidcSamlAuthentication = new OidcSamlAuthentication(samlAuthentication.getAssertion(), user);
        SecurityContextHolder.getContext().setAuthentication((Authentication)oidcSamlAuthentication);
        return oidcSamlAuthentication;
    }

    private User buildUser(DefaultSamlAuthentication samlAuthentication) {
        Assertion assertion = samlAuthentication.getAssertion();
        String unspecifiedNameId = assertion.getSubject().getPrincipal().getValue();
        List authenticationStatements = assertion.getAuthenticationStatements();
        AtomicReference authenticatingAuthority = new AtomicReference();
        if (!CollectionUtils.isEmpty((Collection)authenticationStatements)) {
            authenticationStatements.stream().map(as -> as.getAuthenticationContext().getAuthenticatingAuthorities()).flatMap(Collection::stream).findAny().ifPresent(aa -> authenticatingAuthority.set(aa));
        }
        String clientId = samlAuthentication.getRelayState();
        String eduPersonTargetedId = this.getAttributeValue("urn:mace:dir:attribute-def:eduPersonTargetedID", assertion);
        String sub = StringUtils.hasText((String)eduPersonTargetedId) ? eduPersonTargetedId : UUID.nameUUIDFromBytes((unspecifiedNameId + "_" + clientId).getBytes()).toString();
        Map<String, Object> attributes = this.userAttributes.stream().filter(ua -> !ua.customMapping).map(ua -> new Object[]{ua.oidc, ua.multiValue ? this.getAttributeValues(ua.saml, assertion) : this.getAttributeValue(ua.saml, assertion)}).filter(oo -> oo[1] != null).collect(Collectors.toMap(oo -> (String)oo[0], oo -> oo[1]));
        return new User(sub, unspecifiedNameId, (String)authenticatingAuthority.get(), clientId, attributes);
    }

    private String getAttributeValue(String samlAttributeName, Assertion assertion) {
        Set values = this.getAttributeValues(samlAttributeName, assertion);
        return !CollectionUtils.isEmpty((Collection)values) ? (String)values.iterator().next() : null;
    }

    private Set<String> getAttributeValues(String samlAttributeName, Assertion assertion) {
        List values;
        Attribute firstAttribute = assertion.getFirstAttribute(samlAttributeName);
        if (firstAttribute != null && !CollectionUtils.isEmpty((Collection)(values = firstAttribute.getValues())) && values.size() > 0) {
            return values.stream().filter(val -> val != null).map(val -> val.toString()).collect(Collectors.toSet());
        }
        return null;
    }
}

