/*
 * Decompiled with CFR 0.152.
 */
package oidc.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import oidc.model.User;
import oidc.repository.UserRepository;
import oidc.user.OidcSamlAuthentication;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.saml.saml2.authentication.Assertion;
import org.springframework.security.saml.saml2.authentication.NameIdPrincipal;
import org.springframework.security.saml.saml2.authentication.Subject;
import org.springframework.security.saml.saml2.metadata.NameId;
import org.springframework.security.saml.spi.DefaultSamlAuthentication;
import org.springframework.web.filter.GenericFilterBean;

public class FakeSamlAuthenticationFilter
extends GenericFilterBean {
    private UserRepository userRepository;
    private ObjectMapper objectMapper;

    public FakeSamlAuthenticationFilter(UserRepository userRepository, ObjectMapper objectMapper) {
        this.userRepository = userRepository;
        this.objectMapper = objectMapper;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (!(authentication != null && authentication.isAuthenticated() || authentication instanceof DefaultSamlAuthentication)) {
            User user = (User)this.objectMapper.readValue(IOUtils.toString((InputStream)new ClassPathResource("data/user.json").getInputStream(), (Charset)Charset.defaultCharset()), User.class);
            this.userRepository.deleteAll();
            this.userRepository.insert((Object)user);
            OidcSamlAuthentication samlAuthentication = new OidcSamlAuthentication(this.getAssertion(), user);
            SecurityContextHolder.getContext().setAuthentication((Authentication)samlAuthentication);
        }
        chain.doFilter(request, response);
    }

    private Assertion getAssertion() {
        Assertion assertion = new Assertion();
        Subject subject = new Subject();
        NameIdPrincipal principal = new NameIdPrincipal();
        principal.setValue("urn:collab:person:example.com:admin");
        principal.setFormat(NameId.UNSPECIFIED);
        subject.setPrincipal(principal);
        assertion.setSubject(subject);
        assertion.setAttributes(Collections.emptyList());
        return assertion;
    }
}

